/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.ScmUtils;
import org.apache.hadoop.hdds.scm.ha.SCMNodeDetails;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.recon.ReconConstants;
import org.apache.hadoop.ozone.recon.api.types.DUResponse;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.scm.ReconContainerReportQueue;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.hadoop.ozone.recon.schema.tables.daos.GlobalStatsDao;
import org.hadoop.ozone.recon.schema.tables.pojos.GlobalStats;
import org.jetbrains.annotations.NotNull;
import org.jooq.Configuration;
import org.jooq.ResultQuery;
import org.jooq.SelectField;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReconUtils {
    private static final int WRITE_BUFFER = 0x100000;
    private static Logger log = LoggerFactory.getLogger(ReconUtils.class);
    private static AtomicBoolean rebuildTriggered = new AtomicBoolean(false);

    public static File getReconScmDbDir(ConfigurationSource conf) {
        return new ReconUtils().getReconDbDir(conf, "ozone.recon.scm.db.dirs");
    }

    @NotNull
    public static List<BlockingQueue<SCMDatanodeHeartbeatDispatcher.ContainerReport>> initContainerReportQueue(OzoneConfiguration configuration) {
        int threadPoolSize = configuration.getInt(ScmUtils.getContainerReportConfPrefix() + ".thread.pool.size", 10);
        int queueSize = configuration.getInt(ScmUtils.getContainerReportConfPrefix() + ".queue.size", 100000);
        ArrayList<BlockingQueue<SCMDatanodeHeartbeatDispatcher.ContainerReport>> queues = new ArrayList<BlockingQueue<SCMDatanodeHeartbeatDispatcher.ContainerReport>>();
        for (int i = 0; i < threadPoolSize; ++i) {
            queues.add((BlockingQueue<SCMDatanodeHeartbeatDispatcher.ContainerReport>)((Object)new ReconContainerReportQueue(queueSize)));
        }
        return queues;
    }

    public File getReconDbDir(ConfigurationSource conf, String dirConfigKey) {
        File metadataDir = ServerUtils.getDirectoryFromConfig((ConfigurationSource)conf, (String)dirConfigKey, (String)"Recon");
        if (metadataDir != null) {
            return metadataDir;
        }
        log.warn("{} is not configured. We recommend adding this setting. Falling back to {} instead.", (Object)dirConfigKey, (Object)"ozone.metadata.dirs");
        return ServerUtils.getOzoneMetaDirPath((ConfigurationSource)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTarFile(Path sourcePath) throws IOException {
        File file;
        TarArchiveOutputStream tarOs = null;
        FileOutputStream fileOutputStream = null;
        try {
            String sourceDir = sourcePath.toString();
            String fileName = sourceDir.concat(".tar");
            fileOutputStream = new FileOutputStream(fileName);
            tarOs = new TarArchiveOutputStream((OutputStream)fileOutputStream);
            tarOs.setBigNumberMode(2);
            File folder = new File(sourceDir);
            File[] filesInDir = folder.listFiles();
            if (filesInDir != null) {
                for (File file2 : filesInDir) {
                    ReconUtils.addFilesToArchive(file2.getName(), file2, tarOs);
                }
            }
            file = new File(fileName);
        }
        catch (Throwable throwable) {
            try {
                org.apache.hadoop.io.IOUtils.closeStream(tarOs);
                org.apache.hadoop.io.IOUtils.closeStream(fileOutputStream);
            }
            catch (Exception e) {
                log.error("Exception encountered when closing TAR file output stream: " + e);
            }
            throw throwable;
        }
        try {
            org.apache.hadoop.io.IOUtils.closeStream((Closeable)tarOs);
            org.apache.hadoop.io.IOUtils.closeStream((Closeable)fileOutputStream);
        }
        catch (Exception e) {
            log.error("Exception encountered when closing TAR file output stream: " + e);
        }
        return file;
    }

    private static void addFilesToArchive(String source, File file, TarArchiveOutputStream tarFileOutputStream) throws IOException {
        tarFileOutputStream.putArchiveEntry(new TarArchiveEntry(file, source));
        if (file.isFile()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                IOUtils.copy((InputStream)bufferedInputStream, (OutputStream)tarFileOutputStream);
                tarFileOutputStream.closeArchiveEntry();
            }
        } else if (file.isDirectory()) {
            tarFileOutputStream.closeArchiveEntry();
            File[] filesInDir = file.listFiles();
            if (filesInDir != null) {
                for (File cFile : filesInDir) {
                    ReconUtils.addFilesToArchive(cFile.getAbsolutePath(), cFile, tarFileOutputStream);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void untarCheckpointFile(File tarFile, Path destPath) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            boolean success;
            fileInputStream = new FileInputStream(tarFile);
            if (!destPath.toFile().exists() && !(success = destPath.toFile().mkdirs())) {
                throw new IOException("Unable to create Destination directory.");
            }
            try (TarArchiveInputStream tarInStream = new TarArchiveInputStream((InputStream)fileInputStream);){
                TarArchiveEntry entry;
                while ((entry = tarInStream.getNextEntry()) != null) {
                    BufferedOutputStream dest;
                    block27: {
                        Path path = Paths.get(destPath.toString(), entry.getName());
                        HddsUtils.validatePath((Path)path, (Path)destPath);
                        File f = path.toFile();
                        if (entry.isDirectory()) {
                            boolean success2 = f.mkdirs();
                            if (success2) continue;
                            log.error("Unable to create directory found in tar.");
                            continue;
                        }
                        byte[] data = new byte[0x100000];
                        FileOutputStream fos = new FileOutputStream(f);
                        dest = new BufferedOutputStream(fos, 0x100000);
                        Throwable throwable = null;
                        try {
                            int count;
                            while ((count = tarInStream.read(data, 0, 0x100000)) != -1) {
                                dest.write(data, 0, count);
                            }
                            if (dest == null) continue;
                            if (throwable == null) break block27;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (dest == null) throw throwable3;
                                if (throwable == null) {
                                    dest.close();
                                    throw throwable3;
                                }
                                try {
                                    dest.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            dest.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    dest.close();
                }
            }
        }
        catch (Throwable throwable) {
            org.apache.hadoop.io.IOUtils.closeStream(fileInputStream);
            throw throwable;
        }
        org.apache.hadoop.io.IOUtils.closeStream((Closeable)fileInputStream);
    }

    public static String constructFullPath(OmKeyInfo omKeyInfo, ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager) throws IOException {
        StringBuilder fullPath = new StringBuilder(omKeyInfo.getKeyName());
        long parentId = omKeyInfo.getParentObjectID();
        boolean isDirectoryPresent = false;
        while (parentId != 0L) {
            NSSummary nsSummary = reconNamespaceSummaryManager.getNSSummary(parentId);
            if (nsSummary == null) {
                log.warn("NSSummary tree is currently being rebuilt or the directory could be in the progress of deletion, returning empty string for path construction.");
                return "";
            }
            if (nsSummary.getParentId() == -1L) {
                if (rebuildTriggered.compareAndSet(false, true)) {
                    ReconUtils.triggerRebuild(reconNamespaceSummaryManager, omMetadataManager);
                }
                log.warn("NSSummary tree is currently being rebuilt, returning empty string for path construction.");
                return "";
            }
            fullPath.insert(0, nsSummary.getDirName() + "/");
            parentId = nsSummary.getParentId();
            isDirectoryPresent = true;
        }
        String volumeName = omKeyInfo.getVolumeName();
        String bucketName = omKeyInfo.getBucketName();
        fullPath.insert(0, volumeName + "/" + bucketName + "/");
        if (isDirectoryPresent) {
            return OmUtils.normalizeKey((String)fullPath.toString(), (boolean)true);
        }
        return fullPath.toString();
    }

    private static void triggerRebuild(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager) {
        ExecutorService executor = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r);
            t.setName("RebuildNSSummaryThread");
            return t;
        });
        executor.submit(() -> {
            long startTime = System.currentTimeMillis();
            log.info("Rebuilding NSSummary tree...");
            try {
                reconNamespaceSummaryManager.rebuildNSSummaryTree(omMetadataManager);
            }
            finally {
                long endTime = System.currentTimeMillis();
                log.info("NSSummary tree rebuild completed in {} ms.", (Object)(endTime - startTime));
            }
        });
        executor.shutdown();
    }

    public HttpURLConnection makeHttpCall(URLConnectionFactory connectionFactory, String url, boolean isSpnego) throws IOException, AuthenticationException {
        HttpURLConnection urlConnection = (HttpURLConnection)connectionFactory.openConnection(new URL(url), isSpnego);
        urlConnection.connect();
        return urlConnection;
    }

    public File getLastKnownDB(File reconDbDir, String fileNamePrefix) {
        File[] snapshotFiles;
        String lastKnownSnapshotFileName = null;
        long lastKnonwnSnapshotTs = Long.MIN_VALUE;
        if (reconDbDir != null && (snapshotFiles = reconDbDir.listFiles((dir, name) -> name.startsWith(fileNamePrefix))) != null) {
            for (File snapshotFile : snapshotFiles) {
                String fileName = snapshotFile.getName();
                try {
                    long snapshotTimestamp;
                    String[] fileNameSplits = fileName.split("_");
                    if (fileNameSplits.length <= 1 || lastKnonwnSnapshotTs >= (snapshotTimestamp = Long.parseLong(fileNameSplits[1]))) continue;
                    lastKnonwnSnapshotTs = snapshotTimestamp;
                    lastKnownSnapshotFileName = fileName;
                }
                catch (NumberFormatException nfEx) {
                    log.warn("Unknown file found in Recon DB dir : {}", (Object)fileName);
                }
            }
        }
        return lastKnownSnapshotFileName == null ? null : new File(reconDbDir.getPath(), lastKnownSnapshotFileName);
    }

    public static void upsertGlobalStatsTable(Configuration sqlConfiguration, GlobalStatsDao globalStatsDao, String key, Long count) {
        Timestamp now = (Timestamp)DSL.using((Configuration)sqlConfiguration).fetchValue((ResultQuery)DSL.select((SelectField)DSL.currentTimestamp()));
        GlobalStats record = globalStatsDao.fetchOneByKey(key);
        GlobalStats newRecord = new GlobalStats(key, count, now);
        if (record == null) {
            globalStatsDao.insert(newRecord);
        } else {
            globalStatsDao.update(newRecord);
        }
    }

    public static List<DUResponse.DiskUsage> sortDiskUsageDescendingWithLimit(List<DUResponse.DiskUsage> diskUsageList, int limit) {
        return diskUsageList.parallelStream().sorted((du1, du2) -> Long.compare(du2.getSize(), du1.getSize())).limit(limit).collect(Collectors.toList());
    }

    public static long getFileSizeUpperBound(long fileSize) {
        if (fileSize >= 0x4000000000000L) {
            return Long.MAX_VALUE;
        }
        int binIndex = ReconUtils.getFileSizeBinIndex(fileSize);
        return (long)Math.pow(2.0, 10 + binIndex);
    }

    public static long getContainerSizeUpperBound(long containerSize) {
        if (containerSize >= 0x4000000000000L) {
            return Long.MAX_VALUE;
        }
        int binIndex = ReconUtils.getContainerSizeBinIndex(containerSize);
        return (long)Math.pow(2.0, 29 + binIndex);
    }

    public static int getFileSizeBinIndex(long fileSize) {
        Preconditions.checkArgument((fileSize >= 0L ? 1 : 0) != 0, (String)"fileSize = %s < 0", (long)fileSize);
        if (fileSize >= 0x4000000000000L) {
            return ReconConstants.NUM_OF_FILE_SIZE_BINS - 1;
        }
        int index = ReconUtils.nextClosestPowerIndexOfTwo(fileSize);
        return index < 10 ? 0 : index - 10;
    }

    public static int getContainerSizeBinIndex(long containerSize) {
        Preconditions.checkArgument((containerSize >= 0L ? 1 : 0) != 0, (String)"containerSize = %s < 0", (long)containerSize);
        if (containerSize >= 0x4000000000000L) {
            return ReconConstants.NUM_OF_CONTAINER_SIZE_BINS - 1;
        }
        int index = ReconUtils.nextClosestPowerIndexOfTwo(containerSize);
        return index < 29 ? 0 : index - 29;
    }

    static int nextClosestPowerIndexOfTwo(long n) {
        return n > 0L ? 64 - Long.numberOfLeadingZeros(n - 1L) : (n == 0L ? 0 : (n == Long.MIN_VALUE ? -63 : -ReconUtils.nextClosestPowerIndexOfTwo(-n)));
    }

    public SCMNodeDetails getReconNodeDetails(OzoneConfiguration conf) {
        SCMNodeDetails.Builder builder = new SCMNodeDetails.Builder();
        builder.setSCMNodeId("Recon");
        builder.setDatanodeProtocolServerAddress(HddsServerUtil.getReconDataNodeBindAddress((ConfigurationSource)conf));
        return builder.build();
    }

    @VisibleForTesting
    public static void setLogger(Logger logger) {
        log = logger;
    }
}

