/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.fsck;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.ozone.recon.scm.ReconNodeManager;
import org.apache.hadoop.ozone.recon.scm.ReconSafeModeManager;
import org.apache.hadoop.ozone.recon.tasks.ReconTaskConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconSafeModeMgrTask {
    private static final Logger LOG = LoggerFactory.getLogger(ReconSafeModeMgrTask.class);
    private ContainerManager containerManager;
    private ReconNodeManager nodeManager;
    private ReconSafeModeManager safeModeManager;
    private List<DatanodeDetails> allNodes;
    private List<ContainerInfo> containers;
    private OzoneConfiguration ozoneConfiguration;
    private final long interval;
    private final long dnHBInterval;

    public ReconSafeModeMgrTask(ContainerManager containerManager, ReconNodeManager nodeManager, ReconSafeModeManager safeModeManager, ReconTaskConfig reconTaskConfig, OzoneConfiguration ozoneConfiguration) {
        this.safeModeManager = safeModeManager;
        this.containerManager = containerManager;
        this.nodeManager = nodeManager;
        this.allNodes = nodeManager.getAllNodes();
        this.containers = containerManager.getContainers();
        this.ozoneConfiguration = ozoneConfiguration;
        this.interval = reconTaskConfig.getSafeModeWaitThreshold().toMillis();
        this.dnHBInterval = ozoneConfiguration.getTimeDuration("hdds.heartbeat.interval", "30s", TimeUnit.MILLISECONDS);
    }

    public synchronized void start() {
        block4: {
            try {
                this.tryReconExitSafeMode();
                for (long timeElapsed = 0L; this.safeModeManager.getInSafeMode() && timeElapsed <= this.interval; timeElapsed += this.dnHBInterval) {
                    this.wait(this.dnHBInterval);
                    this.allNodes = this.nodeManager.getAllNodes();
                    this.containers = this.containerManager.getContainers();
                    this.tryReconExitSafeMode();
                }
                if (this.safeModeManager.getInSafeMode()) {
                    this.safeModeManager.setInSafeMode(false);
                }
            }
            catch (Throwable t) {
                LOG.error("Exception in Missing Container task Thread.", t);
                if (!(t instanceof InterruptedException)) break block4;
                Thread.currentThread().interrupt();
            }
        }
    }

    private void tryReconExitSafeMode() throws InterruptedException {
        if (null == this.allNodes || this.allNodes.size() == 0) {
            return;
        }
        if (null == this.containers || this.containers.size() == 0) {
            return;
        }
        HashSet currentContainersInAllDatanodes = new HashSet(this.containers.size());
        this.allNodes.forEach(node -> {
            try {
                currentContainersInAllDatanodes.addAll(this.nodeManager.getContainers((DatanodeDetails)node));
            }
            catch (NodeNotFoundException e) {
                LOG.error("{} node not found.", (Object)node.getUuid());
            }
        });
        if (this.containers.size() == currentContainersInAllDatanodes.size()) {
            this.safeModeManager.setInSafeMode(false);
        }
    }
}

