/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.heatmap;

import com.google.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.recon.api.types.EntityReadAccessHeatMapResponse;
import org.apache.hadoop.ozone.recon.heatmap.HeatMapService;
import org.apache.hadoop.ozone.recon.heatmap.HeatMapUtil;
import org.apache.hadoop.ozone.recon.heatmap.IHeatMapProvider;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeatMapServiceImpl
extends HeatMapService {
    private static final Logger LOG = LoggerFactory.getLogger(HeatMapServiceImpl.class);
    private final OzoneConfiguration ozoneConfiguration;
    private final ReconNamespaceSummaryManager reconNamespaceSummaryManager;
    private final ReconOMMetadataManager omMetadataManager;
    private final OzoneStorageContainerManager reconSCM;
    private IHeatMapProvider heatMapProvider;
    private HeatMapUtil heatMapUtil;

    @Inject
    public HeatMapServiceImpl(OzoneConfiguration ozoneConfiguration, ReconNamespaceSummaryManager namespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM) {
        this.ozoneConfiguration = ozoneConfiguration;
        this.reconNamespaceSummaryManager = namespaceSummaryManager;
        this.omMetadataManager = omMetadataManager;
        this.reconSCM = reconSCM;
        this.heatMapUtil = new HeatMapUtil(this.reconNamespaceSummaryManager, omMetadataManager, reconSCM, ozoneConfiguration);
        this.initializeProvider();
    }

    private void initializeProvider() {
        String heatMapProviderCls = this.ozoneConfiguration.get("ozone.recon.heatmap.provider");
        LOG.info("HeatMapProvider: {}", (Object)heatMapProviderCls);
        if (!StringUtils.isEmpty((CharSequence)heatMapProviderCls)) {
            try {
                this.heatMapProvider = HeatMapUtil.loadHeatMapProvider(heatMapProviderCls);
            }
            catch (Exception e) {
                LOG.error("Loading HeatMapProvider fails!!! : {}", (Throwable)e);
                return;
            }
            if (null != this.heatMapProvider) {
                try {
                    this.heatMapProvider.init(this.ozoneConfiguration, this.omMetadataManager, this.reconNamespaceSummaryManager, this.reconSCM);
                }
                catch (Exception e) {
                    LOG.error("Initializing HeatMapProvider fails!!! : {}", (Throwable)e);
                    this.heatMapProvider = null;
                }
            } else {
                LOG.error("Loading HeatMapProvider fails!!!");
            }
        }
    }

    @Override
    public EntityReadAccessHeatMapResponse retrieveData(String path, String entityType, String startDate) throws Exception {
        return this.heatMapUtil.retrieveDataAndGenerateHeatMap(this.heatMapProvider, this.validatePath(path), entityType, startDate);
    }

    private String validatePath(String path) {
        if (null != path && path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }
}

