/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.ha.InterSCMGrpcClient;
import org.apache.hadoop.hdds.scm.ha.SCMHAUtils;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.server.SCMHTTPServerConfig;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.server.http.HttpConfig;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.RocksDBCheckpoint;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.scm.ReconStorageConfig;
import org.apache.hadoop.ozone.recon.security.ReconCertificateClient;
import org.apache.hadoop.ozone.recon.spi.StorageContainerServiceProvider;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ratis.proto.RaftProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageContainerServiceProviderImpl
implements StorageContainerServiceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StorageContainerServiceProviderImpl.class);
    private StorageContainerLocationProtocol scmClient;
    private final OzoneConfiguration configuration;
    private String scmDBSnapshotUrl;
    private File scmSnapshotDBParentDir;
    private URLConnectionFactory connectionFactory;
    private ReconUtils reconUtils;
    private ReconStorageConfig reconStorage;

    @Inject
    public StorageContainerServiceProviderImpl(StorageContainerLocationProtocol scmClient, ReconUtils reconUtils, OzoneConfiguration configuration, ReconStorageConfig reconStorage) {
        int connectionTimeout = (int)configuration.getTimeDuration("ozone.recon.scm.connection.timeout", "5s", TimeUnit.MILLISECONDS);
        int connectionRequestTimeout = (int)configuration.getTimeDuration("ozone.recon.scm.connection.request.timeout", "5s", TimeUnit.MILLISECONDS);
        this.connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((int)connectionTimeout, (int)connectionRequestTimeout, (Configuration)configuration);
        String scmHttpAddress = configuration.get("ozone.scm.http-address");
        String scmHttpsAddress = configuration.get("ozone.scm.https-address");
        HttpConfig.Policy policy = HttpConfig.getHttpPolicy((MutableConfigurationSource)configuration);
        this.scmSnapshotDBParentDir = ReconUtils.getReconScmDbDir((ConfigurationSource)configuration);
        this.scmDBSnapshotUrl = "http://" + scmHttpAddress + "/dbCheckpoint";
        if (policy.isHttpsEnabled()) {
            this.scmDBSnapshotUrl = "https://" + scmHttpsAddress + "/dbCheckpoint";
        }
        this.reconUtils = reconUtils;
        this.scmClient = scmClient;
        this.configuration = configuration;
        this.reconStorage = reconStorage;
    }

    @Override
    public List<Pipeline> getPipelines() throws IOException {
        return this.scmClient.listPipelines();
    }

    @Override
    public Pipeline getPipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        return this.scmClient.getPipeline(pipelineID);
    }

    @Override
    public ContainerWithPipeline getContainerWithPipeline(long containerId) throws IOException {
        return this.scmClient.getContainerWithPipeline(containerId);
    }

    @Override
    public List<ContainerWithPipeline> getExistContainerWithPipelinesInBatch(List<Long> containerIDs) {
        return this.scmClient.getExistContainerWithPipelinesInBatch(containerIDs);
    }

    @Override
    public List<HddsProtos.Node> getNodes() throws IOException {
        return this.scmClient.queryNode(null, null, HddsProtos.QueryScope.CLUSTER, "", ClientVersion.CURRENT_VERSION);
    }

    @Override
    public long getContainerCount() throws IOException {
        return this.scmClient.getContainerCount();
    }

    @Override
    public long getContainerCount(HddsProtos.LifeCycleState state) throws IOException {
        return this.scmClient.getContainerCount(state);
    }

    public String getScmDBSnapshotUrl() {
        return this.scmDBSnapshotUrl;
    }

    private boolean isOmSpnegoEnabled() {
        return this.configuration.get(SCMHTTPServerConfig.ConfigStrings.HDDS_SCM_HTTP_AUTH_TYPE, "simple").equals("kerberos");
    }

    @Override
    public DBCheckpoint getSCMDBSnapshot() {
        String snapshotFileName = "scm.snapshot.db_" + System.currentTimeMillis();
        File targetFile = new File(this.scmSnapshotDBParentDir, snapshotFileName + ".tar");
        try {
            if (!SCMHAUtils.isSCMHAEnabled((ConfigurationSource)this.configuration)) {
                SecurityUtil.doAsLoginUser(() -> {
                    try (InputStream inputStream = this.reconUtils.makeHttpCall(this.connectionFactory, this.getScmDBSnapshotUrl(), this.isOmSpnegoEnabled()).getInputStream();){
                        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)targetFile);
                    }
                    return null;
                });
                LOG.info("Downloaded SCM Snapshot from SCM");
            } else {
                List ratisRoles = this.scmClient.getScmInfo().getRatisPeerRoles();
                for (String ratisRole : ratisRoles) {
                    String[] role = ratisRole.split(":");
                    if (!role[2].equals(RaftProtos.RaftPeerRole.LEADER.toString())) continue;
                    String hostAddress = role[4].trim();
                    int grpcPort = this.configuration.getInt("ozone.scm.grpc.port", 9895);
                    SecurityConfig secConf = new SecurityConfig((ConfigurationSource)this.configuration);
                    SCMSecurityProtocolClientSideTranslatorPB scmSecurityClient = HddsServerUtil.getScmSecurityClientWithMaxRetry((OzoneConfiguration)this.configuration, (UserGroupInformation)UserGroupInformation.getCurrentUser());
                    try (ReconCertificateClient certClient = new ReconCertificateClient(secConf, scmSecurityClient, this.reconStorage, null, null);
                         InterSCMGrpcClient downloadClient = new InterSCMGrpcClient(hostAddress, grpcPort, (ConfigurationSource)this.configuration, (CertificateClient)certClient);){
                        downloadClient.download(targetFile.toPath()).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        LOG.error("Rocks DB checkpoint downloading failed", (Throwable)e);
                        throw new IOException(e);
                    }
                    LOG.info("Downloaded SCM Snapshot from Leader SCM");
                    break;
                }
            }
            Path untarredDbDir = Paths.get(this.scmSnapshotDBParentDir.getAbsolutePath(), snapshotFileName);
            this.reconUtils.untarCheckpointFile(targetFile, untarredDbDir);
            FileUtils.deleteQuietly((File)targetFile);
            return new RocksDBCheckpoint(untarredDbDir);
        }
        catch (IOException e) {
            LOG.error("Unable to obtain SCM DB Snapshot. ", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<ContainerInfo> getListOfContainers(long startContainerID, int count, HddsProtos.LifeCycleState state) throws IOException {
        return this.scmClient.getListOfContainers(startContainerID, count, state);
    }
}

