/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.scm.ReconScmTask;
import org.apache.hadoop.ozone.recon.spi.StorageContainerServiceProvider;
import org.apache.hadoop.ozone.recon.tasks.ReconTaskConfig;
import org.hadoop.ozone.recon.schema.ContainerSchemaDefinition;
import org.hadoop.ozone.recon.schema.UtilizationSchemaDefinition;
import org.hadoop.ozone.recon.schema.tables.ContainerCountBySizeTable;
import org.hadoop.ozone.recon.schema.tables.daos.ContainerCountBySizeDao;
import org.hadoop.ozone.recon.schema.tables.daos.ReconTaskStatusDao;
import org.hadoop.ozone.recon.schema.tables.pojos.ContainerCountBySize;
import org.jooq.DSLContext;
import org.jooq.Record1;
import org.jooq.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerSizeCountTask
extends ReconScmTask {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerSizeCountTask.class);
    private StorageContainerServiceProvider scmClient;
    private ContainerManager containerManager;
    private final long interval;
    private ContainerCountBySizeDao containerCountBySizeDao;
    private DSLContext dslContext;
    private HashMap<ContainerID, Long> processedContainers = new HashMap();
    private Map<ContainerSchemaDefinition.UnHealthyContainerStates, Map<String, Long>> unhealthyContainerStateStatsMap;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public ContainerSizeCountTask(ContainerManager containerManager, StorageContainerServiceProvider scmClient, ReconTaskStatusDao reconTaskStatusDao, ReconTaskConfig reconTaskConfig, ContainerCountBySizeDao containerCountBySizeDao, UtilizationSchemaDefinition utilizationSchemaDefinition) {
        super(reconTaskStatusDao);
        this.scmClient = scmClient;
        this.containerManager = containerManager;
        this.containerCountBySizeDao = containerCountBySizeDao;
        this.dslContext = utilizationSchemaDefinition.getDSLContext();
        this.interval = reconTaskConfig.getContainerSizeCountTaskInterval().toMillis();
    }

    @Override
    protected synchronized void run() {
        block6: {
            try {
                while (this.canRun()) {
                    this.wait(this.interval);
                    List containers = this.containerManager.getContainers();
                    if (this.processedContainers.isEmpty()) {
                        try {
                            int execute = this.dslContext.truncate((Table)ContainerCountBySizeTable.CONTAINER_COUNT_BY_SIZE).execute();
                            LOG.info("Deleted {} records from {}", (Object)execute, (Object)ContainerCountBySizeTable.CONTAINER_COUNT_BY_SIZE);
                        }
                        catch (Exception e) {
                            LOG.error("An error occurred while truncating the table {}: {}", new Object[]{ContainerCountBySizeTable.CONTAINER_COUNT_BY_SIZE, e.getMessage(), e});
                            return;
                        }
                    }
                    long startTime = System.nanoTime();
                    this.process(containers);
                    long endTime = System.nanoTime();
                    long duration = endTime - startTime;
                    long durationMilliseconds = duration / 1000000L;
                    LOG.info("Elapsed Time in milliseconds for Process() execution: {}", (Object)durationMilliseconds);
                }
            }
            catch (Throwable t) {
                LOG.error("Exception in Container Size Distribution task Thread.", t);
                if (!(t instanceof InterruptedException)) break block6;
                Thread.currentThread().interrupt();
            }
        }
    }

    private void process(ContainerInfo container, Map<ContainerSizeCountKey, Long> map) {
        long currentSize;
        ContainerID id = container.containerID();
        long usedBytes = container.getUsedBytes();
        if (usedBytes < 0L) {
            LOG.warn("Negative usedBytes ({}) for container {}, treating it as 0", (Object)usedBytes, (Object)id);
            currentSize = 0L;
        } else {
            currentSize = usedBytes;
        }
        Long previousSize = this.processedContainers.put(id, currentSize);
        if (previousSize != null) {
            ContainerSizeCountTask.decrementContainerSizeCount(previousSize, map);
        }
        ContainerSizeCountTask.incrementContainerSizeCount(currentSize, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(List<ContainerInfo> containers) {
        this.lock.writeLock().lock();
        try {
            HashMap<ContainerSizeCountKey, Long> containerSizeCountMap = new HashMap<ContainerSizeCountKey, Long>();
            HashMap<ContainerID, Long> deletedContainers = new HashMap<ContainerID, Long>(this.processedContainers);
            for (ContainerInfo container : containers) {
                if (container.getState().equals((Object)HddsProtos.LifeCycleState.DELETED)) continue;
                deletedContainers.remove(container.containerID());
                try {
                    this.process(container, containerSizeCountMap);
                }
                catch (Exception e) {
                    LOG.error("FIXME: Failed to process " + container, (Throwable)e);
                }
            }
            this.handleContainerDeleteOperations(deletedContainers, containerSizeCountMap);
            this.writeCountsToDB(false, containerSizeCountMap);
            containerSizeCountMap.clear();
            LOG.info("Completed a 'process' run of ContainerSizeCountTask.");
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void writeCountsToDB(boolean isDbTruncated, Map<ContainerSizeCountKey, Long> containerSizeCountMap) {
        ArrayList insertToDb = new ArrayList();
        ArrayList updateInDb = new ArrayList();
        containerSizeCountMap.keySet().forEach(key -> {
            ContainerCountBySize newRecord = new ContainerCountBySize();
            newRecord.setContainerSize(((ContainerSizeCountKey)key).containerSizeUpperBound);
            newRecord.setCount((Long)containerSizeCountMap.get(key));
            if (!isDbTruncated) {
                Record1 recordToFind = this.dslContext.newRecord(ContainerCountBySizeTable.CONTAINER_COUNT_BY_SIZE.CONTAINER_SIZE).value1((Object)((ContainerSizeCountKey)key).containerSizeUpperBound);
                ContainerCountBySize containerCountRecord = (ContainerCountBySize)this.containerCountBySizeDao.findById(recordToFind.value1());
                if (containerCountRecord == null && newRecord.getCount() > 0L) {
                    insertToDb.add(newRecord);
                } else if (containerCountRecord != null) {
                    newRecord.setCount(containerCountRecord.getCount() + (Long)containerSizeCountMap.get(key));
                    updateInDb.add(newRecord);
                }
            } else if (newRecord.getCount() > 0L) {
                insertToDb.add(newRecord);
            }
        });
        this.containerCountBySizeDao.insert(insertToDb);
        this.containerCountBySizeDao.update(updateInDb);
    }

    @Override
    public String getTaskName() {
        return "ContainerSizeCountTask";
    }

    private void handleContainerDeleteOperations(Map<ContainerID, Long> deletedContainers, Map<ContainerSizeCountKey, Long> containerSizeCountMap) {
        for (Map.Entry<ContainerID, Long> containerId : deletedContainers.entrySet()) {
            this.processedContainers.remove(containerId.getKey());
            long containerSize = deletedContainers.get(containerId.getKey());
            ContainerSizeCountTask.decrementContainerSizeCount(containerSize, containerSizeCountMap);
        }
    }

    private static void incrementContainerSizeCount(long containerSize, Map<ContainerSizeCountKey, Long> containerSizeCountMap) {
        ContainerSizeCountTask.updateContainerSizeCount(containerSize, 1, containerSizeCountMap);
    }

    private static void decrementContainerSizeCount(long containerSize, Map<ContainerSizeCountKey, Long> containerSizeCountMap) {
        ContainerSizeCountTask.updateContainerSizeCount(containerSize, -1, containerSizeCountMap);
    }

    private static void updateContainerSizeCount(long containerSize, int delta, Map<ContainerSizeCountKey, Long> containerSizeCountMap) {
        ContainerSizeCountKey key = ContainerSizeCountTask.getContainerSizeCountKey(containerSize);
        containerSizeCountMap.compute(key, (k, previous) -> previous != null ? previous + (long)delta : (long)delta);
    }

    private static ContainerSizeCountKey getContainerSizeCountKey(long containerSize) {
        if (containerSize == 0L) {
            return new ContainerSizeCountKey(0L);
        }
        return new ContainerSizeCountKey(ReconUtils.getContainerSizeUpperBound(containerSize));
    }

    private static class ContainerSizeCountKey {
        private Long containerSizeUpperBound;

        ContainerSizeCountKey(Long containerSizeUpperBound) {
            this.containerSizeUpperBound = containerSizeUpperBound;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContainerSizeCountKey) {
                ContainerSizeCountKey s = (ContainerSizeCountKey)obj;
                return this.containerSizeUpperBound.equals(s.containerSizeUpperBound);
            }
            return false;
        }

        public int hashCode() {
            return this.containerSizeUpperBound.hashCode();
        }
    }
}

