/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;
import org.hadoop.ozone.recon.schema.tables.daos.GlobalStatsDao;
import org.hadoop.ozone.recon.schema.tables.pojos.GlobalStats;
import org.jooq.Configuration;
import org.jooq.ResultQuery;
import org.jooq.SelectField;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmTableInsightTask
implements ReconOmTask {
    private static final Logger LOG = LoggerFactory.getLogger(OmTableInsightTask.class);
    private GlobalStatsDao globalStatsDao;
    private Configuration sqlConfiguration;
    private ReconOMMetadataManager reconOMMetadataManager;

    @Inject
    public OmTableInsightTask(GlobalStatsDao globalStatsDao, Configuration sqlConfiguration, ReconOMMetadataManager reconOMMetadataManager) {
        this.globalStatsDao = globalStatsDao;
        this.sqlConfiguration = sqlConfiguration;
        this.reconOMMetadataManager = reconOMMetadataManager;
    }

    @Override
    public Pair<String, Boolean> reprocess(OMMetadataManager omMetadataManager) {
        HashMap<String, Long> objectCountMap = this.initializeCountMap();
        HashMap<String, Long> unReplicatedSizeCountMap = this.initializeSizeMap(false);
        HashMap<String, Long> replicatedSizeCountMap = this.initializeSizeMap(true);
        for (String tableName : this.getTaskTables()) {
            Table table = omMetadataManager.getTable(tableName);
            if (table == null) {
                LOG.error("Table " + tableName + " not found in OM Metadata.");
                return new ImmutablePair((Object)this.getTaskName(), (Object)false);
            }
            try {
                TableIterator iterator = table.iterator();
                Throwable throwable = null;
                try {
                    if (this.getTablesToCalculateSize().contains(tableName)) {
                        Triple<Long, Long, Long> details = this.getTableSizeAndCount(iterator);
                        objectCountMap.put(OmTableInsightTask.getTableCountKeyFromTable(tableName), (Long)details.getLeft());
                        unReplicatedSizeCountMap.put(OmTableInsightTask.getUnReplicatedSizeKeyFromTable(tableName), (Long)details.getMiddle());
                        replicatedSizeCountMap.put(OmTableInsightTask.getReplicatedSizeKeyFromTable(tableName), (Long)details.getRight());
                        continue;
                    }
                    long count = Iterators.size((Iterator)iterator);
                    objectCountMap.put(OmTableInsightTask.getTableCountKeyFromTable(tableName), count);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iterator == null) continue;
                    if (throwable != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iterator.close();
                }
            }
            catch (IOException ioEx) {
                LOG.error("Unable to populate Table Count in Recon DB.", (Throwable)ioEx);
                return new ImmutablePair((Object)this.getTaskName(), (Object)false);
            }
        }
        if (!objectCountMap.isEmpty()) {
            this.writeDataToDB(objectCountMap);
        }
        if (!unReplicatedSizeCountMap.isEmpty()) {
            this.writeDataToDB(unReplicatedSizeCountMap);
        }
        if (!replicatedSizeCountMap.isEmpty()) {
            this.writeDataToDB(replicatedSizeCountMap);
        }
        LOG.info("Completed a 'reprocess' run of OmTableInsightTask.");
        return new ImmutablePair((Object)this.getTaskName(), (Object)true);
    }

    private Triple<Long, Long, Long> getTableSizeAndCount(TableIterator<String, ? extends Table.KeyValue<String, ?>> iterator) throws IOException {
        long count = 0L;
        long unReplicatedSize = 0L;
        long replicatedSize = 0L;
        if (iterator != null) {
            while (iterator.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                if (kv == null || kv.getValue() == null) continue;
                if (kv.getValue() instanceof OmKeyInfo) {
                    OmKeyInfo omKeyInfo = (OmKeyInfo)kv.getValue();
                    unReplicatedSize += omKeyInfo.getDataSize();
                    replicatedSize += omKeyInfo.getReplicatedSize();
                    ++count;
                }
                if (!(kv.getValue() instanceof RepeatedOmKeyInfo)) continue;
                RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)kv.getValue();
                ImmutablePair result = repeatedOmKeyInfo.getTotalSize();
                unReplicatedSize += ((Long)result.getRight()).longValue();
                replicatedSize += ((Long)result.getLeft()).longValue();
                count += (long)repeatedOmKeyInfo.getOmKeyInfoList().size();
            }
        }
        return Triple.of((Object)count, (Object)unReplicatedSize, (Object)replicatedSize);
    }

    public Collection<String> getTablesToCalculateSize() {
        ArrayList<String> taskTables = new ArrayList<String>();
        taskTables.add("openKeyTable");
        taskTables.add("openFileTable");
        taskTables.add("deletedTable");
        return taskTables;
    }

    @Override
    public String getTaskName() {
        return "OmTableInsightTask";
    }

    public Collection<String> getTaskTables() {
        return new ArrayList<String>(this.reconOMMetadataManager.listTableNames());
    }

    @Override
    public Pair<String, Boolean> process(OMUpdateEventBatch events) {
        Iterator<OMDBUpdateEvent> eventIterator = events.getIterator();
        HashMap<String, Long> objectCountMap = this.initializeCountMap();
        HashMap<String, Long> unreplicatedSizeCountMap = this.initializeSizeMap(false);
        HashMap<String, Long> replicatedSizeCountMap = this.initializeSizeMap(true);
        Collection<String> taskTables = this.getTaskTables();
        Collection<String> sizeRelatedTables = this.getTablesToCalculateSize();
        while (eventIterator.hasNext()) {
            OMDBUpdateEvent omdbUpdateEvent = eventIterator.next();
            String tableName = omdbUpdateEvent.getTable();
            if (!taskTables.contains(tableName)) continue;
            try {
                switch (omdbUpdateEvent.getAction()) {
                    case PUT: {
                        this.handlePutEvent(omdbUpdateEvent, tableName, sizeRelatedTables, objectCountMap, unreplicatedSizeCountMap, replicatedSizeCountMap);
                        break;
                    }
                    case DELETE: {
                        this.handleDeleteEvent(omdbUpdateEvent, tableName, sizeRelatedTables, objectCountMap, unreplicatedSizeCountMap, replicatedSizeCountMap);
                        break;
                    }
                    case UPDATE: {
                        this.handleUpdateEvent(omdbUpdateEvent, tableName, sizeRelatedTables, objectCountMap, unreplicatedSizeCountMap, replicatedSizeCountMap);
                        break;
                    }
                    default: {
                        LOG.trace("Skipping DB update event : Table: {}, Action: {}", (Object)tableName, (Object)omdbUpdateEvent.getAction());
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Unexpected exception while processing the table {}, Action: {}", new Object[]{tableName, omdbUpdateEvent.getAction(), e});
                return new ImmutablePair((Object)this.getTaskName(), (Object)false);
            }
        }
        if (!objectCountMap.isEmpty()) {
            this.writeDataToDB(objectCountMap);
        }
        if (!unreplicatedSizeCountMap.isEmpty()) {
            this.writeDataToDB(unreplicatedSizeCountMap);
        }
        if (!replicatedSizeCountMap.isEmpty()) {
            this.writeDataToDB(replicatedSizeCountMap);
        }
        LOG.info("Completed a 'process' run of OmTableInsightTask.");
        return new ImmutablePair((Object)this.getTaskName(), (Object)true);
    }

    private void handlePutEvent(OMDBUpdateEvent<String, Object> event, String tableName, Collection<String> sizeRelatedTables, HashMap<String, Long> objectCountMap, HashMap<String, Long> unreplicatedSizeCountMap, HashMap<String, Long> replicatedSizeCountMap) {
        if (sizeRelatedTables.contains(tableName)) {
            this.handleSizeRelatedTablePutEvent(event, tableName, objectCountMap, unreplicatedSizeCountMap, replicatedSizeCountMap);
        } else {
            String countKey = OmTableInsightTask.getTableCountKeyFromTable(tableName);
            objectCountMap.computeIfPresent(countKey, (k, count) -> count + 1L);
        }
    }

    private void handleSizeRelatedTablePutEvent(OMDBUpdateEvent<String, Object> event, String tableName, HashMap<String, Long> objectCountMap, HashMap<String, Long> unreplicatedSizeCountMap, HashMap<String, Long> replicatedSizeCountMap) {
        String countKey = OmTableInsightTask.getTableCountKeyFromTable(tableName);
        String unReplicatedSizeKey = OmTableInsightTask.getUnReplicatedSizeKeyFromTable(tableName);
        String replicatedSizeKey = OmTableInsightTask.getReplicatedSizeKeyFromTable(tableName);
        if (event.getValue() instanceof OmKeyInfo) {
            OmKeyInfo omKeyInfo = (OmKeyInfo)event.getValue();
            objectCountMap.computeIfPresent(countKey, (k, count) -> count + 1L);
            unreplicatedSizeCountMap.computeIfPresent(unReplicatedSizeKey, (k, size) -> size + omKeyInfo.getDataSize());
            replicatedSizeCountMap.computeIfPresent(replicatedSizeKey, (k, size) -> size + omKeyInfo.getReplicatedSize());
        } else if (event.getValue() instanceof RepeatedOmKeyInfo) {
            RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)event.getValue();
            objectCountMap.computeIfPresent(countKey, (k, count) -> count + (long)repeatedOmKeyInfo.getOmKeyInfoList().size());
            ImmutablePair result = repeatedOmKeyInfo.getTotalSize();
            unreplicatedSizeCountMap.computeIfPresent(unReplicatedSizeKey, (arg_0, arg_1) -> OmTableInsightTask.lambda$handleSizeRelatedTablePutEvent$5((Pair)result, arg_0, arg_1));
            replicatedSizeCountMap.computeIfPresent(replicatedSizeKey, (arg_0, arg_1) -> OmTableInsightTask.lambda$handleSizeRelatedTablePutEvent$6((Pair)result, arg_0, arg_1));
        }
    }

    private void handleDeleteEvent(OMDBUpdateEvent<String, Object> event, String tableName, Collection<String> sizeRelatedTables, HashMap<String, Long> objectCountMap, HashMap<String, Long> unreplicatedSizeCountMap, HashMap<String, Long> replicatedSizeCountMap) {
        if (event.getValue() != null) {
            if (sizeRelatedTables.contains(tableName)) {
                this.handleSizeRelatedTableDeleteEvent(event, tableName, objectCountMap, unreplicatedSizeCountMap, replicatedSizeCountMap);
            } else {
                String countKey = OmTableInsightTask.getTableCountKeyFromTable(tableName);
                objectCountMap.computeIfPresent(countKey, (k, count) -> count > 0L ? count - 1L : 0L);
            }
        }
    }

    private void handleSizeRelatedTableDeleteEvent(OMDBUpdateEvent<String, Object> event, String tableName, HashMap<String, Long> objectCountMap, HashMap<String, Long> unreplicatedSizeCountMap, HashMap<String, Long> replicatedSizeCountMap) {
        String countKey = OmTableInsightTask.getTableCountKeyFromTable(tableName);
        String unReplicatedSizeKey = OmTableInsightTask.getUnReplicatedSizeKeyFromTable(tableName);
        String replicatedSizeKey = OmTableInsightTask.getReplicatedSizeKeyFromTable(tableName);
        if (event.getValue() instanceof OmKeyInfo) {
            OmKeyInfo omKeyInfo = (OmKeyInfo)event.getValue();
            objectCountMap.computeIfPresent(countKey, (k, count) -> count > 0L ? count - 1L : 0L);
            unreplicatedSizeCountMap.computeIfPresent(unReplicatedSizeKey, (k, size) -> size > omKeyInfo.getDataSize() ? size - omKeyInfo.getDataSize() : 0L);
            replicatedSizeCountMap.computeIfPresent(replicatedSizeKey, (k, size) -> size > omKeyInfo.getReplicatedSize() ? size - omKeyInfo.getReplicatedSize() : 0L);
        } else if (event.getValue() instanceof RepeatedOmKeyInfo) {
            RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)event.getValue();
            objectCountMap.computeIfPresent(countKey, (k, count) -> count > 0L ? count - (long)repeatedOmKeyInfo.getOmKeyInfoList().size() : 0L);
            ImmutablePair result = repeatedOmKeyInfo.getTotalSize();
            unreplicatedSizeCountMap.computeIfPresent(unReplicatedSizeKey, (arg_0, arg_1) -> OmTableInsightTask.lambda$handleSizeRelatedTableDeleteEvent$12((Pair)result, arg_0, arg_1));
            replicatedSizeCountMap.computeIfPresent(replicatedSizeKey, (arg_0, arg_1) -> OmTableInsightTask.lambda$handleSizeRelatedTableDeleteEvent$13((Pair)result, arg_0, arg_1));
        }
    }

    private void handleUpdateEvent(OMDBUpdateEvent<String, Object> event, String tableName, Collection<String> sizeRelatedTables, HashMap<String, Long> objectCountMap, HashMap<String, Long> unreplicatedSizeCountMap, HashMap<String, Long> replicatedSizeCountMap) {
        if (event.getValue() != null && sizeRelatedTables.contains(tableName)) {
            this.handleSizeRelatedTableUpdateEvent(event, tableName, objectCountMap, unreplicatedSizeCountMap, replicatedSizeCountMap);
        }
    }

    private void handleSizeRelatedTableUpdateEvent(OMDBUpdateEvent<String, Object> event, String tableName, HashMap<String, Long> objectCountMap, HashMap<String, Long> unreplicatedSizeCountMap, HashMap<String, Long> replicatedSizeCountMap) {
        if (event.getOldValue() == null) {
            LOG.warn("Update event does not have the old Key Info for {}.", (Object)event.getKey());
            return;
        }
        String countKey = OmTableInsightTask.getTableCountKeyFromTable(tableName);
        String unReplicatedSizeKey = OmTableInsightTask.getUnReplicatedSizeKeyFromTable(tableName);
        String replicatedSizeKey = OmTableInsightTask.getReplicatedSizeKeyFromTable(tableName);
        if (event.getValue() instanceof OmKeyInfo) {
            OmKeyInfo oldKeyInfo = (OmKeyInfo)event.getOldValue();
            OmKeyInfo newKeyInfo = (OmKeyInfo)event.getValue();
            unreplicatedSizeCountMap.computeIfPresent(unReplicatedSizeKey, (k, size) -> size - oldKeyInfo.getDataSize() + newKeyInfo.getDataSize());
            replicatedSizeCountMap.computeIfPresent(replicatedSizeKey, (k, size) -> size - oldKeyInfo.getReplicatedSize() + newKeyInfo.getReplicatedSize());
        } else if (event.getValue() instanceof RepeatedOmKeyInfo) {
            RepeatedOmKeyInfo oldRepeatedOmKeyInfo = (RepeatedOmKeyInfo)event.getOldValue();
            RepeatedOmKeyInfo newRepeatedOmKeyInfo = (RepeatedOmKeyInfo)event.getValue();
            objectCountMap.computeIfPresent(countKey, (k, count) -> count > 0L ? count - (long)oldRepeatedOmKeyInfo.getOmKeyInfoList().size() + (long)newRepeatedOmKeyInfo.getOmKeyInfoList().size() : 0L);
            ImmutablePair oldSize = oldRepeatedOmKeyInfo.getTotalSize();
            ImmutablePair newSize = newRepeatedOmKeyInfo.getTotalSize();
            unreplicatedSizeCountMap.computeIfPresent(unReplicatedSizeKey, (arg_0, arg_1) -> OmTableInsightTask.lambda$handleSizeRelatedTableUpdateEvent$17((Pair)oldSize, (Pair)newSize, arg_0, arg_1));
            replicatedSizeCountMap.computeIfPresent(replicatedSizeKey, (arg_0, arg_1) -> OmTableInsightTask.lambda$handleSizeRelatedTableUpdateEvent$18((Pair)oldSize, (Pair)newSize, arg_0, arg_1));
        }
    }

    private void writeDataToDB(Map<String, Long> dataMap) {
        ArrayList<GlobalStats> insertGlobalStats = new ArrayList<GlobalStats>();
        ArrayList<GlobalStats> updateGlobalStats = new ArrayList<GlobalStats>();
        for (Map.Entry<String, Long> entry : dataMap.entrySet()) {
            Timestamp now = (Timestamp)DSL.using((Configuration)this.sqlConfiguration).fetchValue((ResultQuery)DSL.select((SelectField)DSL.currentTimestamp()));
            GlobalStats record = this.globalStatsDao.fetchOneByKey(entry.getKey());
            GlobalStats newRecord = new GlobalStats(entry.getKey(), entry.getValue(), now);
            if (record == null) {
                insertGlobalStats.add(newRecord);
                continue;
            }
            updateGlobalStats.add(newRecord);
        }
        this.globalStatsDao.insert(insertGlobalStats);
        this.globalStatsDao.update(updateGlobalStats);
    }

    private HashMap<String, Long> initializeCountMap() {
        Collection<String> tables = this.getTaskTables();
        HashMap<String, Long> objectCountMap = new HashMap<String, Long>(tables.size());
        for (String tableName : tables) {
            String key = OmTableInsightTask.getTableCountKeyFromTable(tableName);
            objectCountMap.put(key, this.getValueForKey(key));
        }
        return objectCountMap;
    }

    private HashMap<String, Long> initializeSizeMap(boolean replicated) {
        Collection<String> tables = this.getTablesToCalculateSize();
        HashMap<String, Long> sizeCountMap = new HashMap<String, Long>(tables.size());
        for (String tableName : tables) {
            String key = replicated ? OmTableInsightTask.getReplicatedSizeKeyFromTable(tableName) : OmTableInsightTask.getUnReplicatedSizeKeyFromTable(tableName);
            sizeCountMap.put(key, this.getValueForKey(key));
        }
        return sizeCountMap;
    }

    public static String getTableCountKeyFromTable(String tableName) {
        return tableName + "Count";
    }

    public static String getReplicatedSizeKeyFromTable(String tableName) {
        return tableName + "ReplicatedDataSize";
    }

    public static String getUnReplicatedSizeKeyFromTable(String tableName) {
        return tableName + "UnReplicatedDataSize";
    }

    private long getValueForKey(String key) {
        GlobalStats record = this.globalStatsDao.fetchOneByKey(key);
        return record == null ? 0L : record.getValue();
    }

    private static /* synthetic */ Long lambda$handleSizeRelatedTableUpdateEvent$18(Pair oldSize, Pair newSize, String k, Long size) {
        return size - (Long)oldSize.getRight() + (Long)newSize.getRight();
    }

    private static /* synthetic */ Long lambda$handleSizeRelatedTableUpdateEvent$17(Pair oldSize, Pair newSize, String k, Long size) {
        return size - (Long)oldSize.getLeft() + (Long)newSize.getLeft();
    }

    private static /* synthetic */ Long lambda$handleSizeRelatedTableDeleteEvent$13(Pair result, String k, Long size) {
        return size > (Long)result.getRight() ? size - (Long)result.getRight() : 0L;
    }

    private static /* synthetic */ Long lambda$handleSizeRelatedTableDeleteEvent$12(Pair result, String k, Long size) {
        return size > (Long)result.getLeft() ? size - (Long)result.getLeft() : 0L;
    }

    private static /* synthetic */ Long lambda$handleSizeRelatedTablePutEvent$6(Pair result, String k, Long size) {
        return size + (Long)result.getRight();
    }

    private static /* synthetic */ Long lambda$handleSizeRelatedTablePutEvent$5(Pair result, String k, Long size) {
        return size + (Long)result.getLeft();
    }
}

