/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigurationException;
import org.apache.hadoop.hdds.conf.ConfigurationReflectionUtil;
import org.apache.hadoop.hdds.conf.StorageSize;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.conf.TimeDurationUtil;

public interface ConfigurationSource {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public String get(String var1);

    public Collection<String> getConfigKeys();

    public char[] getPassword(String var1) throws IOException;

    default public String get(String key, String defaultValue) {
        String value = this.get(key);
        return value != null ? value : defaultValue;
    }

    default public int getInt(String key, int defaultValue) {
        String value = this.get(key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    default public int[] getInts(String name) {
        String[] strings = this.getTrimmedStrings(name);
        int[] ints = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            ints[i] = Integer.parseInt(strings[i]);
        }
        return ints;
    }

    default public long getLong(String key, long defaultValue) {
        String value = this.get(key);
        return value != null ? Long.parseLong(value) : defaultValue;
    }

    default public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.get(key);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    default public float getFloat(String key, float defaultValue) {
        String value = this.get(key);
        return value != null ? Float.parseFloat(value) : defaultValue;
    }

    default public double getDouble(String key, double defaultValue) {
        String value = this.get(key);
        return value != null ? Double.parseDouble(value) : defaultValue;
    }

    default public String getTrimmed(String key) {
        String value = this.get(key);
        return value != null ? value.trim() : null;
    }

    default public String getTrimmed(String key, String defaultValue) {
        String value = this.getTrimmed(key);
        return value != null ? value : defaultValue;
    }

    default public String[] getTrimmedStrings(String name) {
        String valueString = this.get(name);
        if (null == valueString || valueString.trim().isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        return valueString.trim().split("\\s*[,\n]\\s*");
    }

    default public Map<String, String> getPropsMatchPrefixAndTrimPrefix(String keyPrefix) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        for (String name : this.getConfigKeys()) {
            if (!name.startsWith(keyPrefix)) continue;
            String value = this.get(name);
            String keyName = name.substring(keyPrefix.length());
            configMap.put(keyName, value);
        }
        return configMap;
    }

    default public Map<String, String> getPropsMatchPrefix(String keyPrefix) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        for (String name : this.getConfigKeys()) {
            if (!name.startsWith(keyPrefix)) continue;
            String value = this.get(name);
            configMap.put(name, value);
        }
        return configMap;
    }

    default public boolean isConfigured(String key) {
        return this.get(key) != null;
    }

    default public <T> T getObject(Class<T> configurationClass) {
        T configObject;
        try {
            configObject = configurationClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException("Configuration class can't be created: " + configurationClass, e);
        }
        ConfigGroup configGroup = configurationClass.getAnnotation(ConfigGroup.class);
        String prefix = configGroup.prefix();
        ConfigurationReflectionUtil.injectConfiguration(this, configurationClass, configObject, prefix, false);
        ConfigurationReflectionUtil.callPostConstruct(configObject);
        return configObject;
    }

    default public <T> void reconfigure(Class<T> configClass, T object) {
        ConfigGroup configGroup = configClass.getAnnotation(ConfigGroup.class);
        String prefix = configGroup.prefix();
        ConfigurationReflectionUtil.injectConfiguration(this, configClass, object, prefix, true);
    }

    default public <U> Class<? extends U> getClass(String name, Class<? extends U> defaultValue, Class<U> xface) {
        try {
            Class<?> theClass = this.getClass(name, defaultValue);
            if (theClass != null && !xface.isAssignableFrom(theClass)) {
                throw new RuntimeException(theClass + " not " + xface.getName());
            }
            if (theClass != null) {
                return theClass.asSubclass(xface);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public Class<?> getClass(String name, Class<?> defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    default public Class<?>[] getClasses(String name, Class<?> ... defaultValue) {
        String valueString = this.get(name);
        if (null == valueString) {
            return defaultValue;
        }
        String[] classnames = this.getTrimmedStrings(name);
        try {
            Class[] classes = new Class[classnames.length];
            for (int i = 0; i < classnames.length; ++i) {
                classes[i] = Class.forName(classnames[i]);
            }
            return classes;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    default public long getTimeDuration(String name, long defaultValue, TimeUnit unit) {
        String vStr = this.get(name);
        if (null == vStr) {
            return defaultValue;
        }
        return TimeDurationUtil.getTimeDurationHelper(name, vStr, unit);
    }

    default public long getTimeDuration(String name, String defaultValue, TimeUnit unit) {
        String vStr = this.get(name);
        if (null == vStr) {
            return TimeDurationUtil.getTimeDurationHelper(name, defaultValue, unit);
        }
        return TimeDurationUtil.getTimeDurationHelper(name, vStr, unit);
    }

    default public int getBufferSize(String name, String defaultValue) {
        double size = this.getStorageSize(name, defaultValue, StorageUnit.BYTES);
        if (size <= 0.0) {
            throw new IllegalArgumentException(name + " <= 0");
        }
        if (size > 2.147483647E9) {
            throw new IllegalArgumentException(name + " > Integer.MAX_VALUE = " + Integer.MAX_VALUE);
        }
        return (int)size;
    }

    default public double getStorageSize(String name, String defaultValue, StorageUnit targetUnit) {
        String vString = this.get(name);
        if (vString == null) {
            vString = defaultValue;
        }
        StorageSize measure = StorageSize.parse(vString);
        double byteValue = measure.getUnit().toBytes(measure.getValue());
        return targetUnit.fromBytes(byteValue);
    }

    default public Collection<String> getTrimmedStringCollection(String key) {
        return Arrays.asList(this.getTrimmedStrings(key));
    }

    default public <T extends Enum<T>> T getEnum(String name, T defaultValue) {
        String val = this.getTrimmed(name);
        return null == val ? defaultValue : Enum.valueOf(defaultValue.getDeclaringClass(), val);
    }
}

