/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.crypto.CryptoOutputStream;
import org.apache.hadoop.hdds.scm.storage.ByteBufferStreamOutput;
import org.apache.hadoop.ozone.client.io.ByteBufferOutputStream;
import org.apache.hadoop.ozone.client.io.CipherOutputStreamOzone;
import org.apache.hadoop.ozone.client.io.KeyDataStreamOutput;
import org.apache.hadoop.ozone.client.io.KeyMetadataAware;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;

public class OzoneDataStreamOutput
extends ByteBufferOutputStream
implements KeyMetadataAware {
    private final ByteBufferStreamOutput byteBufferStreamOutput;

    public OzoneDataStreamOutput(ByteBufferStreamOutput byteBufferStreamOutput) {
        this.byteBufferStreamOutput = byteBufferStreamOutput;
    }

    public void write(ByteBuffer b, int off, int len) throws IOException {
        this.byteBufferStreamOutput.write(b, off, len);
    }

    public synchronized void flush() throws IOException {
        this.byteBufferStreamOutput.flush();
    }

    public synchronized void close() throws IOException {
        this.byteBufferStreamOutput.close();
    }

    public OmMultipartCommitUploadPartInfo getCommitUploadPartInfo() {
        KeyDataStreamOutput keyDataStreamOutput = this.getKeyDataStreamOutput();
        if (keyDataStreamOutput != null) {
            return keyDataStreamOutput.getCommitUploadPartInfo();
        }
        return null;
    }

    public KeyDataStreamOutput getKeyDataStreamOutput() {
        if (this.byteBufferStreamOutput instanceof OzoneOutputStream) {
            OutputStream wrappedStream;
            OutputStream outputStream = ((OzoneOutputStream)this.byteBufferStreamOutput).getOutputStream();
            if (outputStream instanceof KeyDataStreamOutput) {
                return (KeyDataStreamOutput)((Object)outputStream);
            }
            if (outputStream instanceof CryptoOutputStream) {
                OutputStream wrappedStream2 = ((CryptoOutputStream)outputStream).getWrappedStream();
                if (wrappedStream2 instanceof KeyDataStreamOutput) {
                    return (KeyDataStreamOutput)((Object)wrappedStream2);
                }
            } else if (outputStream instanceof CipherOutputStreamOzone && (wrappedStream = ((CipherOutputStreamOzone)outputStream).getWrappedStream()) instanceof KeyDataStreamOutput) {
                return (KeyDataStreamOutput)((Object)wrappedStream);
            }
        } else if (this.byteBufferStreamOutput instanceof KeyDataStreamOutput) {
            return (KeyDataStreamOutput)this.byteBufferStreamOutput;
        }
        return null;
    }

    public ByteBufferStreamOutput getByteBufStreamOutput() {
        return this.byteBufferStreamOutput;
    }

    @Override
    public Map<String, String> getMetadata() {
        return ((KeyMetadataAware)this.byteBufferStreamOutput).getMetadata();
    }
}

