/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.balancer;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.PlacementPolicyValidateProxy;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.balancer.ContainerBalancerConfiguration;
import org.apache.hadoop.hdds.scm.container.balancer.ContainerMoveSelection;
import org.apache.hadoop.hdds.scm.container.balancer.FindTargetStrategy;
import org.apache.hadoop.hdds.scm.node.DatanodeUsageInfo;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.slf4j.Logger;

public abstract class AbstractFindTargetGreedy
implements FindTargetStrategy {
    private Logger logger;
    private ContainerManager containerManager;
    private PlacementPolicyValidateProxy placementPolicyValidateProxy;
    private Map<DatanodeDetails, Long> sizeEnteringNode = new HashMap<DatanodeDetails, Long>();
    private NodeManager nodeManager;
    private ContainerBalancerConfiguration config;
    private Double upperLimit;
    private Collection<DatanodeUsageInfo> potentialTargets;

    protected AbstractFindTargetGreedy(ContainerManager containerManager, PlacementPolicyValidateProxy placementPolicyValidateProxy, NodeManager nodeManager) {
        this.containerManager = containerManager;
        this.placementPolicyValidateProxy = placementPolicyValidateProxy;
        this.nodeManager = nodeManager;
    }

    protected void setLogger(Logger log) {
        this.logger = log;
    }

    protected void setPotentialTargets(Collection<DatanodeUsageInfo> pt) {
        this.potentialTargets = pt;
    }

    private void setUpperLimit(Double upperLimit) {
        this.upperLimit = upperLimit;
    }

    protected int compareByUsage(DatanodeUsageInfo a, DatanodeUsageInfo b) {
        double currentUsageOfB;
        double currentUsageOfA = a.calculateUtilization(this.sizeEnteringNode.get(a.getDatanodeDetails()));
        int ret = Double.compare(currentUsageOfA, currentUsageOfB = b.calculateUtilization(this.sizeEnteringNode.get(b.getDatanodeDetails())));
        if (ret != 0) {
            return ret;
        }
        UUID uuidA = a.getDatanodeDetails().getUuid();
        UUID uuidB = b.getDatanodeDetails().getUuid();
        return uuidA.compareTo(uuidB);
    }

    private void setConfiguration(ContainerBalancerConfiguration conf) {
        this.config = conf;
    }

    @Override
    public ContainerMoveSelection findTargetForContainerMove(DatanodeDetails source, Set<ContainerID> candidateContainers) {
        this.sortTargetForSource(source);
        for (DatanodeUsageInfo targetInfo : this.potentialTargets) {
            DatanodeDetails target = targetInfo.getDatanodeDetails();
            for (ContainerID container : candidateContainers) {
                ContainerInfo containerInfo;
                Set<ContainerReplica> replicas;
                try {
                    replicas = this.containerManager.getContainerReplicas(container);
                    containerInfo = this.containerManager.getContainer(container);
                }
                catch (ContainerNotFoundException e) {
                    this.logger.warn("Could not get Container {} from Container Manager for obtaining replicas in Container Balancer.", (Object)container, (Object)e);
                    continue;
                }
                if (!replicas.stream().noneMatch(replica -> replica.getDatanodeDetails().equals((Object)target)) || !this.containerMoveSatisfiesPlacementPolicy(container, replicas, source, target) || !this.canSizeEnterTarget(target, containerInfo.getUsedBytes())) continue;
                return new ContainerMoveSelection(target, container);
            }
        }
        this.logger.info("Container Balancer could not find a target for source datanode {}", (Object)source.getUuidString());
        return null;
    }

    private boolean containerMoveSatisfiesPlacementPolicy(ContainerID containerID, Set<ContainerReplica> replicas, DatanodeDetails source, DatanodeDetails target) {
        ContainerInfo containerInfo;
        try {
            containerInfo = this.containerManager.getContainer(containerID);
        }
        catch (ContainerNotFoundException e) {
            this.logger.warn("Could not get Container {} from Container Manager while checking if container move satisfies placement policy in Container Balancer.", (Object)containerID.toString(), (Object)e);
            return false;
        }
        List<DatanodeDetails> replicaList = replicas.stream().map(ContainerReplica::getDatanodeDetails).filter(datanodeDetails -> !datanodeDetails.equals((Object)source)).collect(Collectors.toList());
        replicaList.add(target);
        ContainerPlacementStatus placementStatus = this.placementPolicyValidateProxy.validateContainerPlacement(replicaList, containerInfo);
        boolean isPolicySatisfied = placementStatus.isPolicySatisfied();
        if (!isPolicySatisfied) {
            this.logger.debug("Moving container {} from source {} to target {} will not satisfy placement policy.", new Object[]{containerID, source.getUuidString(), target.getUuidString()});
        }
        return isPolicySatisfied;
    }

    private boolean canSizeEnterTarget(DatanodeDetails target, long size) {
        if (this.sizeEnteringNode.containsKey(target)) {
            long sizeEnteringAfterMove = this.sizeEnteringNode.get(target) + size;
            if (sizeEnteringAfterMove > this.config.getMaxSizeEnteringTarget()) {
                this.logger.debug("{} bytes cannot enter datanode {} because 'size.entering.target.max' limit is {} and {} bytes have already entered.", new Object[]{size, target.getUuidString(), this.config.getMaxSizeEnteringTarget(), this.sizeEnteringNode.get(target)});
                return false;
            }
            if (Double.compare(this.nodeManager.getUsageInfo(target).calculateUtilization(sizeEnteringAfterMove), this.upperLimit) > 0) {
                this.logger.debug("{} bytes cannot enter datanode {} because its utilization will exceed the upper limit of {}.", new Object[]{size, target.getUuidString(), this.upperLimit});
                return false;
            }
            return true;
        }
        this.logger.warn("No record of how much size has entered datanode {}", (Object)target.getUuidString());
        return false;
    }

    @Override
    public void increaseSizeEntering(DatanodeDetails target, long size) {
        if (this.sizeEnteringNode.containsKey(target)) {
            long totalEnteringSize = this.sizeEnteringNode.get(target) + size;
            this.sizeEnteringNode.put(target, totalEnteringSize);
            this.potentialTargets.removeIf(c -> c.getDatanodeDetails().equals((Object)target));
            if (totalEnteringSize < this.config.getMaxSizeEnteringTarget()) {
                this.potentialTargets.add(this.nodeManager.getUsageInfo(target));
            }
            return;
        }
        this.logger.warn("Cannot find {} in the candidates target nodes", (Object)target.getUuid());
    }

    @Override
    public void reInitialize(List<DatanodeUsageInfo> potentialDataNodes, ContainerBalancerConfiguration conf, Double upLimit) {
        this.setConfiguration(conf);
        this.setUpperLimit(upLimit);
        this.sizeEnteringNode.clear();
        this.resetTargets(potentialDataNodes);
    }

    @VisibleForTesting
    public Collection<DatanodeUsageInfo> getPotentialTargets() {
        return this.potentialTargets;
    }

    @VisibleForTesting
    public abstract void sortTargetForSource(DatanodeDetails var1);

    void resetTargets(Collection<DatanodeUsageInfo> targets) {
        this.potentialTargets.clear();
        targets.forEach(datanodeUsageInfo -> {
            this.sizeEnteringNode.putIfAbsent(datanodeUsageInfo.getDatanodeDetails(), 0L);
            this.potentialTargets.add((DatanodeUsageInfo)datanodeUsageInfo);
        });
    }

    NodeManager getNodeManager() {
        return this.nodeManager;
    }
}

