/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.UnhealthyReplicationHandler;

public abstract class AbstractOverReplicationHandler
implements UnhealthyReplicationHandler {
    private final PlacementPolicy placementPolicy;

    protected AbstractOverReplicationHandler(PlacementPolicy placementPolicy) {
        this.placementPolicy = placementPolicy;
    }

    public boolean isPlacementStatusActuallyEqualAfterRemove(Set<ContainerReplica> replicas, ContainerReplica replica, int replicationFactor) {
        ContainerPlacementStatus currentCPS = this.getPlacementStatus(replicas, replicationFactor);
        replicas.remove(replica);
        ContainerPlacementStatus newCPS = this.getPlacementStatus(replicas, replicationFactor);
        replicas.add(replica);
        return this.isPlacementStatusActuallyEqual(currentCPS, newCPS);
    }

    protected Set<ContainerReplica> selectReplicasToRemove(Set<ContainerReplica> replicas, int expectedCountPerUniqueReplica) {
        return this.placementPolicy.replicasToRemoveToFixOverreplication(replicas, expectedCountPerUniqueReplica);
    }

    private ContainerPlacementStatus getPlacementStatus(Set<ContainerReplica> replicas, int replicationFactor) {
        List<DatanodeDetails> replicaDns = replicas.stream().map(ContainerReplica::getDatanodeDetails).collect(Collectors.toList());
        return this.placementPolicy.validateContainerPlacement(replicaDns, replicationFactor);
    }

    private boolean isPlacementStatusActuallyEqual(ContainerPlacementStatus cps1, ContainerPlacementStatus cps2) {
        return !cps1.isPolicySatisfied() && cps1.actualPlacementCount() == cps2.actualPlacementCount() || cps1.isPolicySatisfied() && cps2.isPolicySatisfied();
    }
}

