/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import org.apache.hadoop.hdds.protocol.DatanodeDetails;

public class ContainerReplicaOp {
    private final PendingOpType opType;
    private final DatanodeDetails target;
    private final int replicaIndex;
    private final long deadlineEpochMillis;

    public static ContainerReplicaOp create(PendingOpType opType, DatanodeDetails target, int replicaIndex) {
        return new ContainerReplicaOp(opType, target, replicaIndex, System.currentTimeMillis());
    }

    public ContainerReplicaOp(PendingOpType opType, DatanodeDetails target, int replicaIndex, long deadlineEpochMillis) {
        this.opType = opType;
        this.target = target;
        this.replicaIndex = replicaIndex;
        this.deadlineEpochMillis = deadlineEpochMillis;
    }

    public PendingOpType getOpType() {
        return this.opType;
    }

    public DatanodeDetails getTarget() {
        return this.target;
    }

    public int getReplicaIndex() {
        return this.replicaIndex;
    }

    public long getDeadlineEpochMillis() {
        return this.deadlineEpochMillis;
    }

    public static enum PendingOpType {
        ADD,
        DELETE;

    }
}

