/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.ContainerHealthResult;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeStatus;

public class RatisContainerReplicaCount
implements ContainerReplicaCount {
    private int healthyReplicaCount;
    private int unhealthyReplicaCount;
    private int misMatchedReplicaCount;
    private int matchingReplicaCount;
    private int decommissionCount;
    private int maintenanceCount;
    private int unhealthyDecommissionCount;
    private int unhealthyMaintenanceCount;
    private int inFlightAdd;
    private int inFlightDel;
    private final int repFactor;
    private final int minHealthyForMaintenance;
    private final ContainerInfo container;
    private final List<ContainerReplica> replicas;
    private boolean considerUnhealthy = false;

    public RatisContainerReplicaCount(ContainerInfo container, Set<ContainerReplica> replicas, int inFlightAdd, int inFlightDelete, int replicationFactor, int minHealthyForMaintenance) {
        this.inFlightAdd = inFlightAdd;
        this.inFlightDel = inFlightDelete;
        this.repFactor = replicationFactor;
        this.replicas = replicas.stream().sorted(Comparator.comparingLong(ContainerReplica::hashCode)).collect(Collectors.toList());
        this.minHealthyForMaintenance = Math.min(this.repFactor, minHealthyForMaintenance);
        this.container = container;
        this.countReplicas();
    }

    public RatisContainerReplicaCount(ContainerInfo containerInfo, Set<ContainerReplica> replicas, List<ContainerReplicaOp> replicaPendingOps, int minHealthyForMaintenance, boolean considerUnhealthy) {
        this.replicas = replicas.stream().sorted(Comparator.comparingLong(ContainerReplica::hashCode)).collect(Collectors.toList());
        this.container = containerInfo;
        this.repFactor = containerInfo.getReplicationFactor().getNumber();
        this.minHealthyForMaintenance = Math.min(this.repFactor, minHealthyForMaintenance);
        this.considerUnhealthy = considerUnhealthy;
        HashSet<DatanodeDetails> unhealthyReplicaDNs = new HashSet<DatanodeDetails>();
        for (ContainerReplica r : replicas) {
            if (r.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY) continue;
            unhealthyReplicaDNs.add(r.getDatanodeDetails());
        }
        for (ContainerReplicaOp op : replicaPendingOps) {
            if (op.getOpType() == ContainerReplicaOp.PendingOpType.ADD) {
                ++this.inFlightAdd;
                continue;
            }
            if (op.getOpType() != ContainerReplicaOp.PendingOpType.DELETE || unhealthyReplicaDNs.contains(op.getTarget()) && !considerUnhealthy) continue;
            ++this.inFlightDel;
        }
        this.countReplicas();
    }

    private void countReplicas() {
        for (ContainerReplica cr : this.replicas) {
            boolean unhealthy;
            HddsProtos.NodeOperationalState state = cr.getDatanodeDetails().getPersistedOpState();
            boolean bl = unhealthy = cr.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY || cr.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED && this.container.getState() == HddsProtos.LifeCycleState.CLOSED && this.container.getSequenceId() != cr.getSequenceId().longValue();
            if (state == HddsProtos.NodeOperationalState.DECOMMISSIONED || state == HddsProtos.NodeOperationalState.DECOMMISSIONING) {
                if (unhealthy) {
                    ++this.unhealthyDecommissionCount;
                    continue;
                }
                ++this.decommissionCount;
                continue;
            }
            if (state == HddsProtos.NodeOperationalState.IN_MAINTENANCE || state == HddsProtos.NodeOperationalState.ENTERING_MAINTENANCE) {
                if (unhealthy) {
                    ++this.unhealthyMaintenanceCount;
                    continue;
                }
                ++this.maintenanceCount;
                continue;
            }
            if (unhealthy) {
                ++this.unhealthyReplicaCount;
                continue;
            }
            ++this.healthyReplicaCount;
            if (ReplicationManager.compareState(this.container.getState(), cr.getState())) {
                ++this.matchingReplicaCount;
                continue;
            }
            ++this.misMatchedReplicaCount;
        }
    }

    public int getHealthyReplicaCount() {
        return this.healthyReplicaCount + this.healthyReplicaCountAdapter() + this.decommissionCount + this.maintenanceCount;
    }

    public int getUnhealthyReplicaCount() {
        return this.unhealthyReplicaCount + this.getUnhealthyReplicaCountAdapter() + this.unhealthyDecommissionCount + this.unhealthyMaintenanceCount;
    }

    protected int getUnhealthyReplicaCountAdapter() {
        return 0;
    }

    public int getMisMatchedReplicaCount() {
        return this.misMatchedReplicaCount;
    }

    public int getMatchingReplicaCount() {
        return this.matchingReplicaCount;
    }

    private int getAvailableReplicas() {
        int available = this.healthyReplicaCount + this.healthyReplicaCountAdapter();
        if (this.considerUnhealthy) {
            available += this.unhealthyReplicaCount + this.getUnhealthyReplicaCountAdapter();
        }
        return available;
    }

    protected int healthyReplicaCountAdapter() {
        return 0;
    }

    @Override
    public int getDecommissionCount() {
        return this.considerUnhealthy ? this.decommissionCount + this.unhealthyDecommissionCount : this.decommissionCount;
    }

    @Override
    public int getMaintenanceCount() {
        return this.considerUnhealthy ? this.maintenanceCount + this.unhealthyMaintenanceCount : this.maintenanceCount;
    }

    public int getReplicationFactor() {
        return this.repFactor;
    }

    @Override
    public ContainerInfo getContainer() {
        return this.container;
    }

    @Override
    public List<ContainerReplica> getReplicas() {
        return new ArrayList<ContainerReplica>(this.replicas);
    }

    public String toString() {
        String result = "Container State: " + this.container.getState() + " Replica Count: " + this.replicas.size() + " Healthy (I/D/M): " + this.healthyReplicaCount + "/" + this.decommissionCount + "/" + this.maintenanceCount + " Unhealthy (I/D/M): " + this.unhealthyReplicaCount + "/" + this.unhealthyDecommissionCount + "/" + this.unhealthyMaintenanceCount + " inFlightAdd: " + this.inFlightAdd + " inFightDel: " + this.inFlightDel + " ReplicationFactor: " + this.repFactor + " minMaintenance: " + this.minHealthyForMaintenance;
        if (this.considerUnhealthy) {
            result = result + " +considerUnhealthy";
        }
        return result;
    }

    public int additionalReplicaNeeded() {
        int delta = this.missingReplicas();
        if (delta < 0) {
            return delta + this.inFlightDel;
        }
        return Math.max(0, delta - this.inFlightAdd + this.inFlightDel);
    }

    private int missingReplicas() {
        int availableReplicas = this.getAvailableReplicas();
        int delta = this.repFactor - availableReplicas;
        if (delta < 0) {
            return delta;
        }
        if (delta > 0) {
            delta = Math.max(0, delta - this.getMaintenanceCount());
            int neededHealthy = Math.max(0, this.minHealthyForMaintenance - availableReplicas);
            delta = Math.max(neededHealthy, delta);
            return delta;
        }
        return delta;
    }

    @Override
    public boolean isSufficientlyReplicated() {
        return this.isSufficientlyReplicated(false);
    }

    @Override
    public boolean isSufficientlyReplicatedForOffline(DatanodeDetails datanode, NodeManager nodeManager) {
        return this.isSufficientlyReplicated();
    }

    @Override
    public boolean isHealthyEnoughForOffline() {
        long countInService = this.getReplicas().stream().filter(r -> r.getDatanodeDetails().getPersistedOpState() == HddsProtos.NodeOperationalState.IN_SERVICE).count();
        if (countInService == 0L) {
            return false;
        }
        HddsProtos.LifeCycleState containerState = this.getContainer().getState();
        return (containerState == HddsProtos.LifeCycleState.CLOSED || containerState == HddsProtos.LifeCycleState.QUASI_CLOSED) && this.getReplicas().stream().filter(r -> r.getDatanodeDetails().getPersistedOpState() == HddsProtos.NodeOperationalState.IN_SERVICE).filter(r -> r.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY).allMatch(r -> ReplicationManager.compareState(containerState, r.getState()));
    }

    public List<ContainerReplica> getVulnerableUnhealthyReplicas(Function<DatanodeDetails, NodeStatus> nodeStatusFn) {
        if (this.container.getState() != HddsProtos.LifeCycleState.QUASI_CLOSED) {
            return Collections.emptyList();
        }
        boolean foundHealthy = false;
        ArrayList<ContainerReplica> unhealthyReplicas = new ArrayList<ContainerReplica>();
        for (ContainerReplica replica2 : this.replicas) {
            if (replica2.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY) {
                foundHealthy = true;
            }
            if (replica2.getSequenceId().longValue() != this.container.getSequenceId() || replica2.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY || replica2.isEmpty()) continue;
            unhealthyReplicas.add(replica2);
        }
        if (!foundHealthy) {
            return Collections.emptyList();
        }
        unhealthyReplicas.removeIf(replica -> {
            NodeStatus status = (NodeStatus)nodeStatusFn.apply(replica.getDatanodeDetails());
            return status == null || !status.isHealthy();
        });
        this.replicas.removeIf(replica -> {
            NodeStatus status = (NodeStatus)nodeStatusFn.apply(replica.getDatanodeDetails());
            return status == null || !status.isHealthy();
        });
        HashSet<UUID> originsOfInServiceReplicas = new HashSet<UUID>();
        for (ContainerReplica replica3 : this.replicas) {
            if (!replica3.getDatanodeDetails().getPersistedOpState().equals((Object)HddsProtos.NodeOperationalState.IN_SERVICE) || !replica3.getSequenceId().equals(this.container.getSequenceId())) continue;
            originsOfInServiceReplicas.add(replica3.getOriginDatanodeId());
        }
        unhealthyReplicas.removeIf(replica -> originsOfInServiceReplicas.contains(replica.getOriginDatanodeId()));
        return unhealthyReplicas;
    }

    public boolean isSufficientlyReplicated(boolean includePendingAdd) {
        int delta = this.redundancyDelta(true, includePendingAdd);
        return delta <= 0;
    }

    public boolean isUnderReplicated() {
        return !this.isSufficientlyReplicated();
    }

    @Override
    public boolean isOverReplicated() {
        return this.isOverReplicated(true);
    }

    public boolean isOverReplicated(boolean includePendingDelete) {
        return this.getExcessRedundancy(includePendingDelete) > 0;
    }

    public boolean isSafelyOverReplicated() {
        if (!this.isOverReplicated(true)) {
            return false;
        }
        return this.getMatchingReplicaCount() >= this.repFactor;
    }

    public int getExcessRedundancy(boolean includePendingDelete) {
        int excessRedundancy = this.redundancyDelta(includePendingDelete, false);
        if (excessRedundancy >= 0) {
            return 0;
        }
        return -excessRedundancy;
    }

    private int redundancyDelta(boolean includePendingDelete, boolean includePendingAdd) {
        int excessRedundancy = this.missingReplicas();
        if (includePendingDelete) {
            excessRedundancy += this.inFlightDel;
        }
        if (includePendingAdd) {
            excessRedundancy -= this.inFlightAdd;
        }
        return excessRedundancy;
    }

    boolean insufficientDueToOutOfService() {
        int delta = this.redundancyDelta(true, false);
        return 0 < delta && delta <= this.getDecommissionCount() + this.getMaintenanceCount();
    }

    public int getRemainingRedundancy() {
        int availableReplicas = this.getAvailableReplicas() + this.getDecommissionCount() + this.getMaintenanceCount();
        return Math.max(0, availableReplicas - this.inFlightDel - 1);
    }

    @Override
    public boolean isUnrecoverable() {
        return this.getReplicas().isEmpty();
    }

    public ContainerHealthResult.UnderReplicatedHealthResult toUnderHealthResult() {
        ContainerHealthResult.UnderReplicatedHealthResult result = new ContainerHealthResult.UnderReplicatedHealthResult(this.getContainer(), this.getRemainingRedundancy(), this.insufficientDueToOutOfService(), this.isSufficientlyReplicated(true), this.isUnrecoverable());
        result.setHasHealthyReplicas(this.getHealthyReplicaCount() > 0);
        return result;
    }

    public ContainerHealthResult.OverReplicatedHealthResult toOverHealthResult() {
        ContainerHealthResult.OverReplicatedHealthResult result = new ContainerHealthResult.OverReplicatedHealthResult(this.getContainer(), this.getExcessRedundancy(false), !this.isOverReplicated(true));
        result.setHasMismatchedReplicas(this.getMisMatchedReplicaCount() > 0);
        result.setIsSafelyOverReplicated(this.isSafelyOverReplicated());
        return result;
    }
}

