/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReplicationManagerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationManagerUtil.class);

    private ReplicationManagerUtil() {
    }

    public static List<DatanodeDetails> getTargetDatanodes(PlacementPolicy policy, int requiredNodes, List<DatanodeDetails> usedNodes, List<DatanodeDetails> excludedNodes, long defaultContainerSize, ContainerInfo container) throws SCMException {
        long dataSizeRequired = Math.max(container.getUsedBytes(), defaultContainerSize);
        for (int mutableRequiredNodes = requiredNodes; mutableRequiredNodes > 0; --mutableRequiredNodes) {
            try {
                if (usedNodes == null) {
                    return policy.chooseDatanodes(excludedNodes, null, mutableRequiredNodes, 0L, dataSizeRequired);
                }
                return policy.chooseDatanodes(usedNodes, excludedNodes, null, mutableRequiredNodes, 0L, dataSizeRequired);
            }
            catch (IOException e) {
                LOG.debug("Placement policy was not able to return {} nodes for container {}.", new Object[]{mutableRequiredNodes, container.getContainerID(), e});
                continue;
            }
        }
        throw new SCMException(String.format("Placement Policy: %s did not return any nodes. Number of required Nodes %d, Datasize Required: %d", policy.getClass(), requiredNodes, dataSizeRequired), SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE);
    }

    public static ExcludedAndUsedNodes getExcludedAndUsedNodes(ContainerInfo container, List<ContainerReplica> replicas, Set<ContainerReplica> toBeRemoved, List<ContainerReplicaOp> pendingReplicaOps, ReplicationManager replicationManager) {
        ArrayList<DatanodeDetails> excludedNodes = new ArrayList<DatanodeDetails>();
        ArrayList<DatanodeDetails> usedNodes = new ArrayList<DatanodeDetails>();
        List<ContainerReplica> nonUniqueUnhealthy = null;
        if (container.getState() == HddsProtos.LifeCycleState.QUASI_CLOSED) {
            nonUniqueUnhealthy = ReplicationManagerUtil.selectUnhealthyReplicasForDelete(container, new HashSet<ContainerReplica>(replicas), 0, dn -> {
                try {
                    return replicationManager.getNodeStatus((DatanodeDetails)dn);
                }
                catch (NodeNotFoundException e) {
                    LOG.warn("Exception for {} while selecting used and excluded nodes for container {}.", dn, (Object)container);
                    return null;
                }
            });
        }
        for (ContainerReplica r : replicas) {
            block12: {
                if (r.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY) {
                    if (container.getState() == HddsProtos.LifeCycleState.QUASI_CLOSED) {
                        if (nonUniqueUnhealthy != null && nonUniqueUnhealthy.contains(r)) {
                            excludedNodes.add(r.getDatanodeDetails());
                            continue;
                        }
                    } else {
                        excludedNodes.add(r.getDatanodeDetails());
                        continue;
                    }
                }
                if (toBeRemoved.contains(r)) {
                    excludedNodes.add(r.getDatanodeDetails());
                    continue;
                }
                try {
                    NodeStatus nodeStatus = replicationManager.getNodeStatus(r.getDatanodeDetails());
                    if (nodeStatus.isDecommission()) {
                        excludedNodes.add(r.getDatanodeDetails());
                    }
                    break block12;
                }
                catch (NodeNotFoundException e) {
                    LOG.warn("Node {} not found in node manager.", (Object)r.getDatanodeDetails());
                    excludedNodes.add(r.getDatanodeDetails());
                }
                continue;
            }
            usedNodes.add(r.getDatanodeDetails());
        }
        for (ContainerReplicaOp pending : pendingReplicaOps) {
            if (pending.getOpType() == ContainerReplicaOp.PendingOpType.ADD) {
                usedNodes.add(pending.getTarget());
            }
            if (pending.getOpType() != ContainerReplicaOp.PendingOpType.DELETE) continue;
            excludedNodes.add(pending.getTarget());
        }
        return new ExcludedAndUsedNodes(excludedNodes, usedNodes);
    }

    public static List<ContainerReplica> selectUnhealthyReplicasForDelete(ContainerInfo containerInfo, Set<ContainerReplica> replicas, int pendingDeletes, Function<DatanodeDetails, NodeStatus> nodeStatusFn) {
        if (pendingDeletes > 0) {
            LOG.debug("Container {} has {} pending deletes which will free nodes.", (Object)containerInfo, (Object)pendingDeletes);
            return null;
        }
        if (replicas.size() <= 2) {
            LOG.debug("There are only {} replicas for container {} so no more will be deleted", (Object)replicas.size(), (Object)containerInfo);
            return null;
        }
        boolean foundMatchingReplica = false;
        for (ContainerReplica containerReplica : replicas) {
            if (!ReplicationManager.compareState(containerInfo.getState(), containerReplica.getState())) continue;
            foundMatchingReplica = true;
            break;
        }
        if (!foundMatchingReplica) {
            LOG.debug("No matching replica found for container {} with replicas {}. No unhealthy replicas can be safely delete.", (Object)containerInfo, replicas);
            return null;
        }
        ArrayList<ContainerReplica> deleteCandidates = new ArrayList<ContainerReplica>();
        for (ContainerReplica r : replicas) {
            NodeStatus nodeStatus = nodeStatusFn.apply(r.getDatanodeDetails());
            if (nodeStatus == null || !nodeStatus.isHealthy() || !nodeStatus.isInService()) continue;
            if (containerInfo.getState() != HddsProtos.LifeCycleState.QUASI_CLOSED && r.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED) {
                if (r.getSequenceId() >= containerInfo.getSequenceId()) continue;
                deleteCandidates.add(r);
                continue;
            }
            if (r.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY) continue;
            deleteCandidates.add(r);
        }
        deleteCandidates.sort(Comparator.comparingLong(ContainerReplica::getSequenceId));
        if (containerInfo.getState() == HddsProtos.LifeCycleState.CLOSED) {
            return deleteCandidates.size() > 0 ? deleteCandidates : null;
        }
        if (containerInfo.getState() == HddsProtos.LifeCycleState.QUASI_CLOSED) {
            List<ContainerReplica> list = ReplicationManagerUtil.findNonUniqueDeleteCandidates(replicas, deleteCandidates, nodeStatusFn);
            return list.size() > 0 ? list : null;
        }
        return null;
    }

    public static ContainerReplica selectUnhealthyReplicaForDelete(ContainerInfo containerInfo, Set<ContainerReplica> replicas, int pendingDeletes, Function<DatanodeDetails, NodeStatus> nodeStatusFn) {
        List<ContainerReplica> containerReplicas = ReplicationManagerUtil.selectUnhealthyReplicasForDelete(containerInfo, replicas, pendingDeletes, nodeStatusFn);
        return containerReplicas != null ? containerReplicas.get(0) : null;
    }

    static List<ContainerReplica> findNonUniqueDeleteCandidates(Set<ContainerReplica> allReplicas, List<ContainerReplica> deleteCandidates, Function<DatanodeDetails, NodeStatus> nodeStatusFn) {
        Set<UUID> existingOriginNodeIDs = allReplicas.stream().filter(r -> !deleteCandidates.contains(r)).filter(r -> {
            NodeStatus status = (NodeStatus)nodeStatusFn.apply(r.getDatanodeDetails());
            return status != null && status.isHealthy() && status.isInService();
        }).map(ContainerReplica::getOriginDatanodeId).collect(Collectors.toSet());
        ArrayList<ContainerReplica> nonUniqueDeleteCandidates = new ArrayList<ContainerReplica>();
        for (ContainerReplica replica : deleteCandidates) {
            if (replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY) continue;
            ReplicationManagerUtil.checkUniqueness(existingOriginNodeIDs, nonUniqueDeleteCandidates, replica);
        }
        for (ContainerReplica replica : deleteCandidates) {
            if (replica.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY) continue;
            ReplicationManagerUtil.checkUniqueness(existingOriginNodeIDs, nonUniqueDeleteCandidates, replica);
        }
        return nonUniqueDeleteCandidates;
    }

    private static void checkUniqueness(Set<UUID> existingOriginNodeIDs, List<ContainerReplica> nonUniqueDeleteCandidates, ContainerReplica replica) {
        if (existingOriginNodeIDs.contains(replica.getOriginDatanodeId())) {
            nonUniqueDeleteCandidates.add(replica);
        } else {
            existingOriginNodeIDs.add(replica.getOriginDatanodeId());
        }
    }

    public static class ExcludedAndUsedNodes {
        private final List<DatanodeDetails> excludedNodes;
        private final List<DatanodeDetails> usedNodes;

        public ExcludedAndUsedNodes(List<DatanodeDetails> excludedNodes, List<DatanodeDetails> usedNodes) {
            this.excludedNodes = excludedNodes;
            this.usedNodes = usedNodes;
        }

        public List<DatanodeDetails> getExcludedNodes() {
            return this.excludedNodes;
        }

        public List<DatanodeDetails> getUsedNodes() {
            return this.usedNodes;
        }
    }
}

