/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.scm.ha.SCMHADBTransactionBuffer;
import org.apache.hadoop.hdds.scm.ha.SCMHAInvocationHandler;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.ha.StatefulServiceStateManager;
import org.apache.hadoop.hdds.scm.metadata.DBTransactionBuffer;
import org.apache.hadoop.hdds.utils.db.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatefulServiceStateManagerImpl
implements StatefulServiceStateManager {
    public static final Logger LOG = LoggerFactory.getLogger(StatefulServiceStateManagerImpl.class);
    private Table<String, ByteString> statefulServiceConfig;
    private final DBTransactionBuffer transactionBuffer;

    private StatefulServiceStateManagerImpl(Table<String, ByteString> statefulServiceConfig, DBTransactionBuffer scmDBTransactionBuffer) {
        this.statefulServiceConfig = statefulServiceConfig;
        this.transactionBuffer = scmDBTransactionBuffer;
    }

    @Override
    public void saveConfiguration(String serviceName, ByteString bytes) throws IOException {
        this.transactionBuffer.addToBuffer(this.statefulServiceConfig, (Object)serviceName, (Object)bytes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Added specified bytes to the transaction buffer for key {} to table {}", (Object)serviceName, (Object)this.statefulServiceConfig.getName());
        }
        if (this.transactionBuffer instanceof SCMHADBTransactionBuffer) {
            SCMHADBTransactionBuffer buffer = (SCMHADBTransactionBuffer)this.transactionBuffer;
            buffer.flush();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Transaction buffer flushed");
            }
        }
    }

    @Override
    public ByteString readConfiguration(String serviceName) throws IOException {
        return (ByteString)this.statefulServiceConfig.get((Object)serviceName);
    }

    @Override
    public void deleteConfiguration(String serviceName) throws IOException {
        this.statefulServiceConfig.delete((Object)serviceName);
    }

    @Override
    public void reinitialize(Table<String, ByteString> configs) {
        this.statefulServiceConfig = configs;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Table<String, ByteString> statefulServiceConfig;
        private DBTransactionBuffer transactionBuffer;
        private SCMRatisServer scmRatisServer;

        public Builder setStatefulServiceConfig(Table<String, ByteString> statefulServiceConfig) {
            this.statefulServiceConfig = statefulServiceConfig;
            return this;
        }

        public Builder setSCMDBTransactionBuffer(DBTransactionBuffer dbTransactionBuffer) {
            this.transactionBuffer = dbTransactionBuffer;
            return this;
        }

        public Builder setRatisServer(SCMRatisServer ratisServer) {
            this.scmRatisServer = ratisServer;
            return this;
        }

        public StatefulServiceStateManager build() {
            Preconditions.checkNotNull(this.statefulServiceConfig);
            Preconditions.checkNotNull((Object)this.transactionBuffer);
            StatefulServiceStateManagerImpl stateManager = new StatefulServiceStateManagerImpl(this.statefulServiceConfig, this.transactionBuffer);
            SCMHAInvocationHandler invocationHandler = new SCMHAInvocationHandler(SCMRatisProtocol.RequestType.STATEFUL_SERVICE_CONFIG, stateManager, this.scmRatisServer);
            return (StatefulServiceStateManager)Proxy.newProxyInstance(SCMHAInvocationHandler.class.getClassLoader(), new Class[]{StatefulServiceStateManager.class}, (InvocationHandler)invocationHandler);
        }
    }
}

