/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeExitRule;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeProtocolServer;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.server.events.TypedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerSafeModeRule
extends SafeModeExitRule<SCMDatanodeProtocolServer.NodeRegistrationContainerReport> {
    public static final Logger LOG = LoggerFactory.getLogger(ContainerSafeModeRule.class);
    private double safeModeCutoff;
    private Map<Long, ContainerInfo> containerMap;
    private double maxContainer;
    private AtomicLong containerWithMinReplicas = new AtomicLong(0L);
    private final ContainerManager containerManager;

    public ContainerSafeModeRule(String ruleName, EventQueue eventQueue, ConfigurationSource conf, List<ContainerInfo> containers, ContainerManager containerManager, SCMSafeModeManager manager) {
        super(manager, ruleName, eventQueue);
        this.containerManager = containerManager;
        this.safeModeCutoff = conf.getDouble("hdds.scm.safemode.threshold.pct", 0.99);
        Preconditions.checkArgument((this.safeModeCutoff >= 0.0 && this.safeModeCutoff <= 1.0 ? 1 : 0) != 0, (Object)"hdds.scm.safemode.threshold.pct value should be >= 0.0 and <= 1.0");
        this.containerMap = new ConcurrentHashMap<Long, ContainerInfo>();
        containers.forEach(container -> Optional.ofNullable(container.getState()).filter(state -> (state == HddsProtos.LifeCycleState.QUASI_CLOSED || state == HddsProtos.LifeCycleState.CLOSED) && container.getNumberOfKeys() > 0L).ifPresent(s -> this.containerMap.put(container.getContainerID(), (ContainerInfo)container)));
        this.maxContainer = this.containerMap.size();
        long cutOff = (long)Math.ceil(this.maxContainer * this.safeModeCutoff);
        this.getSafeModeMetrics().setNumContainerWithOneReplicaReportedThreshold(cutOff);
        LOG.info("containers with one replica threshold count {}", (Object)cutOff);
    }

    @Override
    protected TypedEvent<SCMDatanodeProtocolServer.NodeRegistrationContainerReport> getEventType() {
        return SCMEvents.NODE_REGISTRATION_CONT_REPORT;
    }

    @Override
    protected synchronized boolean validate() {
        return this.getCurrentContainerThreshold() >= this.safeModeCutoff;
    }

    @VisibleForTesting
    public synchronized double getCurrentContainerThreshold() {
        if (this.maxContainer == 0.0) {
            return 1.0;
        }
        return this.containerWithMinReplicas.doubleValue() / this.maxContainer;
    }

    @Override
    protected synchronized void process(SCMDatanodeProtocolServer.NodeRegistrationContainerReport reportsProto) {
        ((StorageContainerDatanodeProtocolProtos.ContainerReportsProto)reportsProto.getReport()).getReportsList().forEach(c -> {
            if (this.containerMap.containsKey(c.getContainerID()) && this.containerMap.remove(c.getContainerID()) != null) {
                this.containerWithMinReplicas.getAndAdd(1L);
                this.getSafeModeMetrics().incCurrentContainersWithOneReplicaReportedCount();
            }
        });
        if (this.scmInSafeMode()) {
            SCMSafeModeManager.getLogger().info("SCM in safe mode. {} % containers have at least one reported replica.", (Object)(this.containerWithMinReplicas.doubleValue() / this.maxContainer * 100.0));
        }
    }

    @Override
    protected synchronized void cleanup() {
        this.containerMap.clear();
    }

    @Override
    public String getStatusText() {
        return String.format("%% of containers with at least one reported replica (=%1.2f) >= safeModeCutoff (=%1.2f)", this.getCurrentContainerThreshold(), this.safeModeCutoff);
    }

    @Override
    public synchronized void refresh(boolean forceRefresh) {
        if (forceRefresh) {
            this.reInitializeRule();
        } else if (!this.validate()) {
            this.reInitializeRule();
        }
    }

    private void reInitializeRule() {
        this.containerMap.clear();
        this.containerManager.getContainers().forEach(container -> Optional.ofNullable(container.getState()).filter(state -> (state == HddsProtos.LifeCycleState.QUASI_CLOSED || state == HddsProtos.LifeCycleState.CLOSED) && container.getNumberOfKeys() > 0L).ifPresent(s -> this.containerMap.put(container.getContainerID(), (ContainerInfo)container)));
        this.maxContainer = this.containerMap.size();
        long cutOff = (long)Math.ceil(this.maxContainer * this.safeModeCutoff);
        LOG.info("Refreshed one replica container threshold {}, currentThreshold {}", (Object)cutOff, (Object)this.containerWithMinReplicas.get());
        this.getSafeModeMetrics().setNumContainerWithOneReplicaReportedThreshold(cutOff);
    }
}

