/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.update.server;

import java.util.UUID;
import org.apache.hadoop.hdds.protocol.scm.proto.SCMUpdateServiceGrpc;
import org.apache.hadoop.hdds.protocol.scm.proto.SCMUpdateServiceProtos;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.update.client.CRLStore;
import org.apache.hadoop.hdds.scm.update.server.SCMCRLUpdateHandler;
import org.apache.hadoop.hdds.scm.update.server.SCMUpdateClientInfo;
import org.apache.hadoop.hdds.scm.update.server.SCMUpdateClientManager;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMUpdateServiceImpl
extends SCMUpdateServiceGrpc.SCMUpdateServiceImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(SCMUpdateServiceImpl.class);
    private SCMUpdateClientManager clientManager = new SCMUpdateClientManager();

    public SCMUpdateServiceImpl(CRLStore crlStore) {
        this.clientManager.registerHandler(new SCMCRLUpdateHandler(crlStore));
    }

    public void subscribe(SCMUpdateServiceProtos.SubscribeRequest request, StreamObserver<SCMUpdateServiceProtos.SubscribeResponse> responseObserver) {
        UUID clientId;
        try {
            clientId = this.clientManager.addClient();
        }
        catch (SCMException ex) {
            LOG.error("Fail to subscribe for Client.", (Throwable)ex);
            responseObserver.onError((Throwable)ex);
            return;
        }
        responseObserver.onNext((Object)SCMUpdateServiceProtos.SubscribeResponse.newBuilder().setClientId(SCMUpdateClientInfo.toClientIdProto((UUID)clientId)).build());
        responseObserver.onCompleted();
        LOG.info("Client {} subscribed.", (Object)clientId);
    }

    public void unsubscribe(SCMUpdateServiceProtos.UnsubscribeRequest request, StreamObserver<SCMUpdateServiceProtos.UnsubscribeResponse> responseObserver) {
        UUID clientId = SCMUpdateClientInfo.fromClientIdProto((SCMUpdateServiceProtos.ClientId)request.getClientId());
        boolean removed = this.clientManager.removeClient(clientId);
        if (removed) {
            LOG.info("Client {} unsubscribed.", (Object)clientId);
        } else {
            LOG.info("Client {} does not exist, no-op for unsubscribe", (Object)clientId);
        }
        responseObserver.onNext((Object)SCMUpdateServiceProtos.UnsubscribeResponse.getDefaultInstance());
        responseObserver.onCompleted();
    }

    public StreamObserver<SCMUpdateServiceProtos.UpdateRequest> updateStatus(final StreamObserver<SCMUpdateServiceProtos.UpdateResponse> responseObserver) {
        return new StreamObserver<SCMUpdateServiceProtos.UpdateRequest>(){

            public void onNext(SCMUpdateServiceProtos.UpdateRequest updateRequest) {
                LOG.debug("UpdateStatus onNext");
                SCMUpdateServiceImpl.this.clientManager.handleClientUpdate(updateRequest, (StreamObserver<SCMUpdateServiceProtos.UpdateResponse>)responseObserver);
            }

            public void onError(Throwable throwable) {
                LOG.debug("UpdateStatus onError", throwable);
                SCMUpdateServiceImpl.this.clientManager.removeClient((StreamObserver<SCMUpdateServiceProtos.UpdateResponse>)responseObserver);
            }

            public void onCompleted() {
                LOG.debug("UpdateStatus(Client) onComplete");
                responseObserver.onCompleted();
                SCMUpdateServiceImpl.this.clientManager.removeClient((StreamObserver<SCMUpdateServiceProtos.UpdateResponse>)responseObserver);
            }
        };
    }

    public void notifyUpdate(SCMUpdateServiceProtos.Type type) {
        this.clientManager.onUpdate(type);
    }
}

