/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class BasicOmKeyInfo {
    private String volumeName;
    private String bucketName;
    private String keyName;
    private long dataSize;
    private long creationTime;
    private long modificationTime;
    private ReplicationConfig replicationConfig;
    private boolean isFile;
    private final String eTag;

    public BasicOmKeyInfo(String volumeName, String bucketName, String keyName, long dataSize, long creationTime, long modificationTime, ReplicationConfig replicationConfig, boolean isFile, String eTag) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.dataSize = dataSize;
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
        this.replicationConfig = replicationConfig;
        this.isFile = isFile;
        this.eTag = StringUtils.isNotEmpty((CharSequence)eTag) ? eTag : null;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public String getETag() {
        return this.eTag;
    }

    public OzoneManagerProtocolProtos.BasicKeyInfo getProtobuf() {
        OzoneManagerProtocolProtos.BasicKeyInfo.Builder builder = OzoneManagerProtocolProtos.BasicKeyInfo.newBuilder().setKeyName(this.keyName).setDataSize(this.dataSize).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).setType(this.replicationConfig.getReplicationType());
        if (this.replicationConfig instanceof ECReplicationConfig) {
            builder.setEcReplicationConfig(((ECReplicationConfig)this.replicationConfig).toProto());
        } else {
            builder.setFactor(ReplicationConfig.getLegacyFactor((ReplicationConfig)this.replicationConfig));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.eTag)) {
            builder.setETag(this.eTag);
        }
        return builder.build();
    }

    public static BasicOmKeyInfo getFromProtobuf(OzoneManagerProtocolProtos.BasicKeyInfo basicKeyInfo, OzoneManagerProtocolProtos.ListKeysRequest request) throws IOException {
        if (basicKeyInfo == null || request == null) {
            return null;
        }
        String keyName = basicKeyInfo.getKeyName();
        Builder builder = new Builder().setVolumeName(request.getVolumeName()).setBucketName(request.getBucketName()).setKeyName(keyName).setDataSize(basicKeyInfo.getDataSize()).setCreationTime(basicKeyInfo.getCreationTime()).setModificationTime(basicKeyInfo.getModificationTime()).setReplicationConfig(ReplicationConfig.fromProto((HddsProtos.ReplicationType)basicKeyInfo.getType(), (HddsProtos.ReplicationFactor)basicKeyInfo.getFactor(), (HddsProtos.ECReplicationConfig)basicKeyInfo.getEcReplicationConfig())).setETag(basicKeyInfo.getETag()).setIsFile(!keyName.endsWith("/"));
        return builder.build();
    }

    public static BasicOmKeyInfo getFromProtobuf(String volumeName, String bucketName, OzoneManagerProtocolProtos.BasicKeyInfo basicKeyInfo) throws IOException {
        if (basicKeyInfo == null) {
            return null;
        }
        String keyName = basicKeyInfo.getKeyName();
        Builder builder = new Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setDataSize(basicKeyInfo.getDataSize()).setCreationTime(basicKeyInfo.getCreationTime()).setModificationTime(basicKeyInfo.getModificationTime()).setReplicationConfig(ReplicationConfig.fromProto((HddsProtos.ReplicationType)basicKeyInfo.getType(), (HddsProtos.ReplicationFactor)basicKeyInfo.getFactor(), (HddsProtos.ECReplicationConfig)basicKeyInfo.getEcReplicationConfig())).setETag(basicKeyInfo.getETag()).setIsFile(!keyName.endsWith("/"));
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicOmKeyInfo basicOmKeyInfo = (BasicOmKeyInfo)o;
        return this.volumeName.equals(basicOmKeyInfo.volumeName) && this.bucketName.equals(basicOmKeyInfo.bucketName) && this.keyName.equals(basicOmKeyInfo.keyName) && this.dataSize == basicOmKeyInfo.dataSize && this.creationTime == basicOmKeyInfo.creationTime && this.modificationTime == basicOmKeyInfo.modificationTime && this.replicationConfig.equals(basicOmKeyInfo.replicationConfig) && Objects.equals(this.eTag, basicOmKeyInfo.eTag) && this.isFile == basicOmKeyInfo.isFile;
    }

    public int hashCode() {
        return Objects.hash(this.volumeName, this.bucketName, this.keyName);
    }

    public static BasicOmKeyInfo fromOmKeyInfo(OmKeyInfo omKeyInfo) {
        return new BasicOmKeyInfo(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName(), omKeyInfo.getKeyName(), omKeyInfo.getDataSize(), omKeyInfo.getCreationTime(), omKeyInfo.getModificationTime(), omKeyInfo.getReplicationConfig(), omKeyInfo.isFile(), omKeyInfo.getMetadata().get("ETag"));
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private String keyName;
        private long dataSize;
        private long creationTime;
        private long modificationTime;
        private ReplicationConfig replicationConfig;
        private boolean isFile;
        private String eTag;

        public Builder setVolumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public Builder setBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder setKeyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder setDataSize(long dataSize) {
            this.dataSize = dataSize;
            return this;
        }

        public Builder setCreationTime(long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder setModificationTime(long modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public Builder setReplicationConfig(ReplicationConfig replicationConfig) {
            this.replicationConfig = replicationConfig;
            return this;
        }

        public Builder setIsFile(boolean isFile) {
            this.isFile = isFile;
            return this;
        }

        public Builder setETag(String etag) {
            this.eTag = etag;
            return this;
        }

        public BasicOmKeyInfo build() {
            return new BasicOmKeyInfo(this.volumeName, this.bucketName, this.keyName, this.dataSize, this.creationTime, this.modificationTime, this.replicationConfig, this.isFile, this.eTag);
        }
    }
}

