/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class KeyInfoWithVolumeContext {
    private final Optional<OmVolumeArgs> volumeArgs;
    private final Optional<String> userPrincipal;
    private final OmKeyInfo keyInfo;

    public KeyInfoWithVolumeContext(OmVolumeArgs volumeArgs, String userPrincipal, OmKeyInfo keyInfo) {
        this.volumeArgs = Optional.ofNullable(volumeArgs);
        this.userPrincipal = Optional.ofNullable(userPrincipal);
        this.keyInfo = keyInfo;
    }

    public static KeyInfoWithVolumeContext fromProtobuf(OzoneManagerProtocolProtos.GetKeyInfoResponse proto) throws IOException {
        return KeyInfoWithVolumeContext.newBuilder().setVolumeArgs(proto.hasVolumeInfo() ? OmVolumeArgs.getFromProtobuf(proto.getVolumeInfo()) : null).setUserPrincipal(proto.getUserPrincipal()).setKeyInfo(OmKeyInfo.getFromProtobuf(proto.getKeyInfo())).build();
    }

    public OzoneManagerProtocolProtos.GetKeyInfoResponse toProtobuf(int clientVersion) {
        OzoneManagerProtocolProtos.GetKeyInfoResponse.Builder builder = OzoneManagerProtocolProtos.GetKeyInfoResponse.newBuilder();
        this.volumeArgs.ifPresent(v -> builder.setVolumeInfo(v.getProtobuf()));
        this.userPrincipal.ifPresent(arg_0 -> ((OzoneManagerProtocolProtos.GetKeyInfoResponse.Builder)builder).setUserPrincipal(arg_0));
        builder.setKeyInfo(this.keyInfo.getProtobuf(clientVersion));
        return builder.build();
    }

    public OmKeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public Optional<OmVolumeArgs> getVolumeArgs() {
        return this.volumeArgs;
    }

    public Optional<String> getUserPrincipal() {
        return this.userPrincipal;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private OmVolumeArgs volumeArgs;
        private String userPrincipal;
        private OmKeyInfo keyInfo;

        public Builder setVolumeArgs(OmVolumeArgs volumeArgs) {
            this.volumeArgs = volumeArgs;
            return this;
        }

        public Builder setUserPrincipal(String userPrincipal) {
            this.userPrincipal = userPrincipal;
            return this;
        }

        public Builder setKeyInfo(OmKeyInfo keyInfo) {
            this.keyInfo = keyInfo;
            return this;
        }

        public KeyInfoWithVolumeContext build() {
            return new KeyInfoWithVolumeContext(this.volumeArgs, this.userPrincipal, this.keyInfo);
        }
    }
}

