/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.snapshot;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.shell.Handler;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketUri;
import picocli.CommandLine;

@CommandLine.Command(name="diff", aliases={"snapshotDiff"}, description={"Get the differences between two snapshots"})
public class SnapshotDiffHandler
extends Handler {
    @CommandLine.Mixin
    private BucketUri snapshotPath;
    @CommandLine.Parameters(description={"from snapshot name"}, index="1")
    private String fromSnapshot;
    @CommandLine.Parameters(description={"to snapshot name"}, index="2")
    private String toSnapshot;
    @CommandLine.Option(names={"-t", "--token"}, description={"continuation token for next page (optional)"})
    private String token;
    @CommandLine.Option(names={"-p", "--page-size"}, description={"number of diff entries to be returned in the response (optional)"})
    private int pageSize;
    @CommandLine.Option(names={"--ffd", "--force-full-diff"}, description={"perform full diff of snapshot without using optimised DAG based pruning approach (optional)"}, hidden=true)
    private boolean forceFullDiff;
    @CommandLine.Option(names={"-c", "--cancel"}, description={"Request to cancel a running SnapshotDiff job. If the job is not IN_PROGRESS, the request will fail."}, defaultValue="false")
    private boolean cancel;
    @CommandLine.Option(names={"--dnld", "--disable-native-libs-diff"}, description={"perform diff of snapshot without using native libs (optional)"}, hidden=true)
    private boolean diffDisableNativeLibs;

    @Override
    protected OzoneAddress getAddress() {
        return this.snapshotPath.getValue();
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = this.snapshotPath.getValue().getVolumeName();
        String bucketName = this.snapshotPath.getValue().getBucketName();
        OmUtils.validateSnapshotName((String)this.fromSnapshot);
        OmUtils.validateSnapshotName((String)this.toSnapshot);
        if (this.cancel) {
            this.cancelSnapshotDiff(client.getObjectStore(), volumeName, bucketName);
        } else {
            this.getSnapshotDiff(client.getObjectStore(), volumeName, bucketName);
        }
    }

    private void getSnapshotDiff(ObjectStore store, String volumeName, String bucketName) throws IOException {
        try (PrintStream stream = this.out();){
            stream.println(store.snapshotDiff(volumeName, bucketName, this.fromSnapshot, this.toSnapshot, this.token, this.pageSize, this.forceFullDiff, this.diffDisableNativeLibs));
        }
    }

    private void cancelSnapshotDiff(ObjectStore store, String volumeName, String bucketName) throws IOException {
        try (PrintStream stream = this.out();){
            stream.print(store.cancelSnapshotDiff(volumeName, bucketName, this.fromSnapshot, this.toSnapshot));
        }
    }
}

