/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.server.JsonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="report", description={"Display the container summary report"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ReportSubcommand
extends ScmSubcommand {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--json"}, defaultValue="false", description={"Format output as JSON"})
    private boolean json;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        ReplicationManagerReport report = scmClient.getReplicationManagerReport();
        if (this.json) {
            this.output(JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)report));
            return;
        }
        this.outputHeader(report.getReportTimeStamp());
        this.blankLine();
        this.outputContainerStats(report);
        this.blankLine();
        this.outputContainerHealthStats(report);
        this.blankLine();
        this.outputContainerSamples(report);
    }

    private void outputHeader(long epochMs) {
        Instant reportTime = Instant.ofEpochSecond(epochMs / 1000L);
        this.outputHeading("Container Summary Report generated at " + reportTime);
    }

    private void outputContainerStats(ReplicationManagerReport report) {
        this.outputHeading("Container State Summary");
        for (HddsProtos.LifeCycleState state : HddsProtos.LifeCycleState.values()) {
            long stat = report.getStat(state);
            if (stat == -1L) continue;
            this.output(state + ": " + stat);
        }
    }

    private void outputContainerHealthStats(ReplicationManagerReport report) {
        this.outputHeading("Container Health Summary");
        for (ReplicationManagerReport.HealthState state : ReplicationManagerReport.HealthState.values()) {
            long stat = report.getStat(state);
            if (stat == -1L) continue;
            this.output(state + ": " + stat);
        }
    }

    private void outputContainerSamples(ReplicationManagerReport report) {
        for (ReplicationManagerReport.HealthState state : ReplicationManagerReport.HealthState.values()) {
            List containers = report.getSample(state);
            if (containers.size() <= 0) continue;
            this.output("First 100 " + state + " containers:");
            this.output(containers.stream().map(ContainerID::toString).collect(Collectors.joining(", ")));
            this.blankLine();
        }
    }

    private void blankLine() {
        System.out.print("\n");
    }

    private void output(String s) {
        System.out.println(s);
    }

    private void outputHeading(String s) {
        this.output(s);
        for (int i = 0; i < s.length(); ++i) {
            System.out.print("=");
        }
        System.out.print("\n");
    }
}

