/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container.upgrade;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.cli.container.upgrade.UpgradeTask;
import org.apache.hadoop.hdds.scm.cli.container.upgrade.UpgradeUtils;
import org.apache.hadoop.ozone.container.common.utils.HddsVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.container.metadata.DatanodeStoreSchemaThreeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeManager {
    public static final Logger LOG = LoggerFactory.getLogger(UpgradeManager.class);
    private final Map<String, DatanodeStoreSchemaThreeImpl> volumeStoreMap = new HashMap<String, DatanodeStoreSchemaThreeImpl>();

    public void run(OzoneConfiguration configuration) throws IOException {
        DatanodeDetails detail = UpgradeUtils.getDatanodeDetails(configuration);
        MutableVolumeSet dataVolumeSet = UpgradeUtils.getHddsVolumes(configuration, StorageVolume.VolumeType.DATA_VOLUME, detail.getUuidString());
        HddsVolumeUtil.loadAllHddsVolumeDbStore((MutableVolumeSet)dataVolumeSet, null, (boolean)false, (Logger)LOG);
        this.initVolumeStoreMap(dataVolumeSet, configuration);
        this.upgradeAll(dataVolumeSet, configuration);
    }

    public void initVolumeStoreMap(MutableVolumeSet dataVolumeSet, OzoneConfiguration configuration) throws IOException {
        for (StorageVolume storageVolume : dataVolumeSet.getVolumesList()) {
            HddsVolume volume = (HddsVolume)storageVolume;
            File containerDBPath = UpgradeUtils.getContainerDBPath(volume);
            DatanodeStoreSchemaThreeImpl datanodeStoreSchemaThree = new DatanodeStoreSchemaThreeImpl((ConfigurationSource)configuration, containerDBPath.getAbsolutePath(), false);
            this.volumeStoreMap.put(volume.getStorageDir().getAbsolutePath(), datanodeStoreSchemaThree);
        }
    }

    public List<Result> upgradeAll(MutableVolumeSet volumeSet, OzoneConfiguration configuration) {
        HddsVolume hddsVolume;
        ArrayList<Result> results = new ArrayList<Result>();
        List volumesList = volumeSet.getVolumesList();
        HashMap<HddsVolume, CompletableFuture<Result>> volumeFutures = new HashMap<HddsVolume, CompletableFuture<Result>>();
        long startTime = System.currentTimeMillis();
        LOG.info("Start upgrade {} volumes container LayoutVersion", (Object)volumesList.size());
        for (StorageVolume storageVolume : volumesList) {
            hddsVolume = (HddsVolume)storageVolume;
            UpgradeTask task = new UpgradeTask((ConfigurationSource)configuration, hddsVolume, this.getDBStore(hddsVolume));
            CompletableFuture<Result> future = task.getUpgradeFutureByVolume();
            volumeFutures.put(hddsVolume, future);
        }
        for (Map.Entry entry : volumeFutures.entrySet()) {
            hddsVolume = (HddsVolume)entry.getKey();
            CompletableFuture volumeFuture = (CompletableFuture)entry.getValue();
            try {
                Result result = (Result)volumeFuture.get();
                results.add(result);
                LOG.info("Finish upgrade containers on volume {}, result {}", (Object)hddsVolume.getVolumeRootDir(), (Object)result);
            }
            catch (Exception e) {
                LOG.error("Upgrade containers on volume {} failed", (Object)hddsVolume.getVolumeRootDir(), (Object)e);
            }
        }
        LOG.info("Upgrade all volume container LayoutVersion costs {}s", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        return results;
    }

    @VisibleForTesting
    public DatanodeStoreSchemaThreeImpl getDBStore(HddsVolume volume) {
        return this.volumeStoreMap.get(volume.getStorageDir().getAbsolutePath());
    }

    public static class Result {
        private Map<Long, UpgradeTask.UpgradeContainerResult> resultMap;
        private final HddsVolume hddsVolume;
        private final long startTimeMs = System.currentTimeMillis();
        private long endTimeMs = 0L;
        private Exception e = null;
        private Status status = Status.FAIL;

        public Result(HddsVolume hddsVolume) {
            this.hddsVolume = hddsVolume;
        }

        public HddsVolume getHddsVolume() {
            return this.hddsVolume;
        }

        public long getCost() {
            return this.endTimeMs - this.startTimeMs;
        }

        public void setResultList(List<UpgradeTask.UpgradeContainerResult> resultList) {
            this.resultMap = new HashMap<Long, UpgradeTask.UpgradeContainerResult>();
            resultList.forEach(res -> this.resultMap.put(res.getOriginContainerData().getContainerID(), (UpgradeTask.UpgradeContainerResult)res));
        }

        public Map<Long, UpgradeTask.UpgradeContainerResult> getResultMap() {
            return this.resultMap;
        }

        public void success() {
            this.endTimeMs = System.currentTimeMillis();
            this.status = Status.SUCCESS;
        }

        public void fail(Exception exception) {
            this.endTimeMs = System.currentTimeMillis();
            this.status = Status.FAIL;
            this.e = exception;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Result{");
            stringBuilder.append("volumeDir=");
            stringBuilder.append(this.getHddsVolume().getHddsRootDir());
            stringBuilder.append(", resultList=");
            AtomicLong total = new AtomicLong(0L);
            this.resultMap.forEach((k, r) -> {
                stringBuilder.append(r.toString());
                stringBuilder.append("\n");
                total.addAndGet(r.getTotalRow());
            });
            stringBuilder.append(", totalRow=");
            stringBuilder.append(total.get());
            stringBuilder.append(", costMs=");
            stringBuilder.append(this.getCost());
            stringBuilder.append("ms, status=");
            stringBuilder.append((Object)this.status);
            if (this.e != null) {
                stringBuilder.append(", Exception=");
                stringBuilder.append(this.e);
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        static enum Status {
            SUCCESS,
            FAIL;

        }
    }
}

