/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.pipeline;

import java.io.IOException;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"create pipeline"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class CreatePipelineSubcommand
extends ScmSubcommand {
    @CommandLine.Option(names={"-t", "--replication-type", "--replicationType"}, description={"Replication type (STAND_ALONE, RATIS). Full name --replicationType will be removed in later versions."}, defaultValue="STAND_ALONE")
    private HddsProtos.ReplicationType type;
    @CommandLine.Option(names={"-f", "--replication-factor", "--replicationFactor"}, description={"Replication factor (ONE, THREE). Full name --replicationFactor will be removed in later versions."}, defaultValue="ONE")
    private HddsProtos.ReplicationFactor factor;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        if (this.type == HddsProtos.ReplicationType.CHAINED || this.type == HddsProtos.ReplicationType.EC) {
            throw new IllegalArgumentException(this.type.name() + " is not supported yet.");
        }
        Pipeline pipeline = scmClient.createReplicationPipeline(this.type, this.factor, HddsProtos.NodePool.getDefaultInstance());
        if (pipeline != null) {
            System.out.println(pipeline.getId().toString() + " is created. " + pipeline.toString());
        }
    }
}

