/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import java.util.Objects;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicatedReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfigValidator;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.OzoneConfigKeys;

public interface ReplicationConfig {
    public static ReplicationConfig fromProtoTypeAndFactor(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor) {
        switch (type) {
            case RATIS: {
                return RatisReplicationConfig.getInstance(factor);
            }
            case STAND_ALONE: {
                return StandaloneReplicationConfig.getInstance(factor);
            }
        }
        throw new UnsupportedOperationException("Not supported replication: " + type);
    }

    public static ReplicationConfig fromTypeAndFactor(ReplicationType type, ReplicationFactor factor) {
        return ReplicationConfig.fromProtoTypeAndFactor(HddsProtos.ReplicationType.valueOf((String)type.name()), HddsProtos.ReplicationFactor.valueOf((String)factor.name()));
    }

    public static ReplicationConfig getDefault(ConfigurationSource config) {
        String replication = config.get("ozone.replication", OzoneConfigKeys.OZONE_REPLICATION_DEFAULT);
        return ReplicationConfig.parse(null, replication, config);
    }

    public static ReplicationConfig resolve(ReplicationConfig replicationConfig, ReplicationConfig bucketReplicationConfig, ConfigurationSource conf) {
        if (replicationConfig == null) {
            replicationConfig = bucketReplicationConfig;
        }
        if (replicationConfig == null) {
            replicationConfig = ReplicationConfig.getDefault(conf);
        }
        return replicationConfig;
    }

    public static ReplicationConfig fromProto(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, HddsProtos.ECReplicationConfig ecConfig) {
        switch (type) {
            case EC: {
                return new ECReplicationConfig(ecConfig);
            }
            case RATIS: 
            case STAND_ALONE: {
                return ReplicationConfig.fromProtoTypeAndFactor(type, factor);
            }
        }
        throw new UnsupportedOperationException("Not supported replication: " + type);
    }

    public static HddsProtos.ReplicationFactor getLegacyFactor(ReplicationConfig replicationConfig) {
        if (replicationConfig instanceof ReplicatedReplicationConfig) {
            return ((ReplicatedReplicationConfig)replicationConfig).getReplicationFactor();
        }
        throw new UnsupportedOperationException("Replication configuration of type " + replicationConfig.getReplicationType() + " does not have a replication factor property.");
    }

    public static ReplicationConfig adjustReplication(ReplicationConfig config, short replication, ConfigurationSource conf) {
        ReplicationType replicationType = ReplicationType.valueOf(config.getReplicationType().toString());
        if (replicationType.equals((Object)ReplicationType.EC)) {
            return config;
        }
        return ReplicationConfig.parse(replicationType, Short.toString(replication), conf);
    }

    public static ReplicationConfig parse(ReplicationType type, String replication, ConfigurationSource config) {
        if (type == null) {
            type = ReplicationType.valueOf(config.get("ozone.replication.type", OzoneConfigKeys.OZONE_REPLICATION_TYPE_DEFAULT));
        }
        replication = Objects.toString(replication, config.get("ozone.replication", OzoneConfigKeys.OZONE_REPLICATION_DEFAULT));
        return ReplicationConfig.parseWithoutFallback(type, replication, config);
    }

    public static ReplicationConfig parseWithoutFallback(ReplicationType type, String replication, ConfigurationSource config) {
        ReplicationConfig replicationConfig;
        if (replication == null) {
            throw new IllegalArgumentException("Replication can't be null. Replication type passed was : " + (Object)((Object)type));
        }
        if (type == null) {
            throw new IllegalArgumentException("Replication type must be specified for: " + replication);
        }
        switch (type) {
            case RATIS: 
            case STAND_ALONE: {
                ReplicationFactor factor;
                try {
                    factor = ReplicationFactor.valueOf(Integer.parseInt(replication));
                }
                catch (NumberFormatException ex) {
                    try {
                        factor = ReplicationFactor.valueOf(replication);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(replication + " is not supported for " + (Object)((Object)type) + " replication type", e);
                    }
                }
                replicationConfig = ReplicationConfig.fromTypeAndFactor(type, factor);
                break;
            }
            case EC: {
                replicationConfig = new ECReplicationConfig(replication);
                break;
            }
            default: {
                throw new IllegalArgumentException("Replication type " + (Object)((Object)type) + " can not be parsed.");
            }
        }
        ReplicationConfigValidator validator = (ReplicationConfigValidator)config.getObject(ReplicationConfigValidator.class);
        validator.validate(replicationConfig);
        return replicationConfig;
    }

    public HddsProtos.ReplicationType getReplicationType();

    public int getRequiredNodes();

    public String getReplication();

    public String configFormat();
}

