/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.utils.LeakTracker;
import org.apache.ratis.util.UncheckedAutoCloseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeakDetector {
    private static final Logger LOG = LoggerFactory.getLogger(LeakDetector.class);
    private static final AtomicLong COUNTER = new AtomicLong();
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final Set<LeakTracker> allLeaks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final String name;

    public LeakDetector(String name) {
        this.name = name + COUNTER.getAndIncrement();
        this.start();
    }

    private void start() {
        Thread t = new Thread(this::run);
        t.setName(LeakDetector.class.getSimpleName() + "-" + this.name);
        t.setDaemon(true);
        LOG.info("Starting leak detector thread {}.", (Object)this.name);
        t.start();
    }

    private void run() {
        try {
            while (true) {
                LeakTracker tracker;
                if (!this.allLeaks.remove(tracker = (LeakTracker)this.queue.remove())) {
                    continue;
                }
                tracker.reportLeak();
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Thread interrupted, exiting.", (Throwable)e);
            LOG.warn("Exiting leak detector {}.", (Object)this.name);
            return;
        }
    }

    public UncheckedAutoCloseable track(Object leakable, Runnable reportLeak) {
        LeakTracker tracker = new LeakTracker(leakable, this.queue, this.allLeaks, reportLeak);
        this.allLeaks.add(tracker);
        return tracker;
    }
}

