/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.CopyObject;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.KeyManagerImpl;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;

public class ListIterator {

    public static class CacheIter<Value>
    implements ClosableIterator {
        private final Map<String, Value> cacheKeyMap = new TreeMap<String, Value>();
        private final Iterator<Map.Entry<String, Value>> cacheCreatedKeyIter;
        private final String prefixKey;
        private final String startKey;
        private final String tableName;
        private final int entryIteratorId;

        CacheIter(int entryIteratorId, String tableName, Iterator<Map.Entry<CacheKey<String>, CacheValue<Value>>> cacheIter, String startKey, String prefixKey) {
            this.startKey = startKey;
            this.prefixKey = prefixKey;
            this.tableName = tableName;
            this.entryIteratorId = entryIteratorId;
            this.populateCacheMap(cacheIter);
            this.cacheCreatedKeyIter = this.cacheKeyMap.entrySet().iterator();
        }

        private void populateCacheMap(Iterator<Map.Entry<CacheKey<String>, CacheValue<Value>>> cacheIter) {
            while (cacheIter.hasNext()) {
                Map.Entry<CacheKey<String>, CacheValue<Value>> entry = cacheIter.next();
                String cacheKey = (String)entry.getKey().getCacheKey();
                Object cacheOmInfo = entry.getValue().getCacheValue();
                if (cacheOmInfo instanceof CopyObject) {
                    cacheOmInfo = ((CopyObject)cacheOmInfo).copyObject();
                }
                if (StringUtils.isBlank((CharSequence)this.startKey)) {
                    if (!cacheKey.startsWith(this.prefixKey)) continue;
                    this.cacheKeyMap.put(cacheKey, cacheOmInfo);
                    continue;
                }
                if (!cacheKey.startsWith(this.prefixKey) || cacheKey.compareTo(this.startKey) < 0) continue;
                this.cacheKeyMap.put(cacheKey, cacheOmInfo);
            }
        }

        @Override
        public boolean hasNext() {
            return this.cacheCreatedKeyIter.hasNext();
        }

        @Override
        public HeapEntry next() {
            Map.Entry<String, Value> entry = this.cacheCreatedKeyIter.next();
            return new HeapEntry(this.entryIteratorId, this.tableName, entry.getKey(), entry.getValue());
        }

        @Override
        public void close() {
        }
    }

    public static interface ClosableIterator
    extends Iterator<HeapEntry>,
    Closeable {
    }

    public static class DbTableIter<Value>
    implements ClosableIterator {
        private final int entryIteratorId;
        private final TableIterator<String, ? extends Table.KeyValue<String, Value>> tableIterator;
        private final Table<String, Value> table;
        private HeapEntry currentKey;

        DbTableIter(int entryIteratorId, Table<String, Value> table, String prefixKey, String startKey) throws IOException {
            this.entryIteratorId = entryIteratorId;
            this.table = table;
            this.tableIterator = table.iterator((Object)prefixKey);
            this.currentKey = null;
            if (!StringUtils.isBlank((CharSequence)startKey) && startKey.compareTo(prefixKey) > 0) {
                this.tableIterator.seek((Object)startKey);
            }
        }

        private void getNextKey() throws IOException {
            while (this.tableIterator.hasNext() && this.currentKey == null) {
                Table.KeyValue entry = (Table.KeyValue)this.tableIterator.next();
                String entryKey = (String)entry.getKey();
                if (KeyManagerImpl.isKeyInCache(entryKey, this.table)) continue;
                this.currentKey = new HeapEntry(this.entryIteratorId, this.table.getName(), entryKey, entry.getValue());
            }
        }

        @Override
        public boolean hasNext() {
            try {
                this.getNextKey();
            }
            catch (IOException t) {
                throw new UncheckedIOException(t);
            }
            return this.currentKey != null;
        }

        @Override
        public HeapEntry next() {
            if (this.hasNext()) {
                HeapEntry ret = this.currentKey;
                this.currentKey = null;
                return ret;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void close() throws IOException {
            this.tableIterator.close();
        }
    }

    public static class HeapEntry
    implements Comparable<HeapEntry> {
        private final int entryIteratorId;
        private final String tableName;
        private final String key;
        private final Object value;

        HeapEntry(int entryIteratorId, String tableName, String key, Object value) {
            this.entryIteratorId = entryIteratorId;
            this.tableName = tableName;
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        private int getEntryIteratorId() {
            return this.entryIteratorId;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public int compareTo(HeapEntry other) {
            return Comparator.comparing(HeapEntry::getKey).thenComparing(HeapEntry::getEntryIteratorId).compare(this, other);
        }

        public boolean equals(Object other) {
            if (!(other instanceof HeapEntry)) {
                return false;
            }
            HeapEntry that = (HeapEntry)other;
            return this.compareTo(that) == 0;
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    public static class MinHeapIterator
    implements ClosableIterator {
        private final PriorityQueue<HeapEntry> minHeap = new PriorityQueue();
        private final ArrayList<ClosableIterator> iterators = new ArrayList();

        MinHeapIterator(OMMetadataManager omMetadataManager, String prefixKey, BucketLayout bucketLayout, String startKey, String volumeName, String bucketName) throws IOException {
            this(omMetadataManager, prefixKey, startKey, volumeName, bucketName, omMetadataManager.getDirectoryTable(), omMetadataManager.getKeyTable(bucketLayout));
        }

        /*
         * WARNING - void declaration
         */
        MinHeapIterator(OMMetadataManager omMetadataManager, String prefixKey, String startKey, String volumeName, String bucketName, Table ... tables) throws IOException {
            omMetadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            try {
                boolean bl = false;
                Table[] tableArray = tables;
                int n = tables.length;
                int n2 = 0;
                while (n2 < n) {
                    void var7_8;
                    Table table = tableArray[n2];
                    this.iterators.add(new CacheIter((int)var7_8, table.getName(), table.cacheIterator(), startKey, prefixKey));
                    this.iterators.add(new DbTableIter((int)(++var7_8), table, prefixKey, startKey));
                    ++var7_8;
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                omMetadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
            omMetadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            for (Iterator iterator : this.iterators) {
                try {
                    if (!iterator.hasNext()) continue;
                    this.minHeap.add((HeapEntry)iterator.next());
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
            }
        }

        @Override
        public boolean hasNext() {
            return !this.minHeap.isEmpty();
        }

        @Override
        public HeapEntry next() {
            HeapEntry heapEntry = (HeapEntry)this.minHeap.remove();
            Iterator iter = this.iterators.get(heapEntry.getEntryIteratorId());
            if (iter.hasNext()) {
                this.minHeap.add((HeapEntry)iter.next());
            }
            return heapEntry;
        }

        @Override
        public void close() throws IOException {
            this.iterators.forEach(closableIterator -> IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{closableIterator}));
        }
    }
}

