/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.om.IOmMetadataReader;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmMetadataReader;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OmSnapshotMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PrefixManager;
import org.apache.hadoop.ozone.om.helpers.BasicOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.KeyInfoWithVolumeContext;
import org.apache.hadoop.ozone.om.helpers.ListKeysLightResult;
import org.apache.hadoop.ozone.om.helpers.ListKeysResult;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatusLight;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneAuthorizerFactory;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmSnapshot
implements IOmMetadataReader,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(OmSnapshot.class);
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.OMLOGGER);
    private final OmMetadataReader omMetadataReader;
    private final String volumeName;
    private final String bucketName;
    private final String snapshotName;
    private final UUID snapshotID;
    private final OMMetadataManager omMetadataManager;
    private final KeyManager keyManager;

    public OmSnapshot(KeyManager keyManager, PrefixManager prefixManager, OzoneManager ozoneManager, String volumeName, String bucketName, String snapshotName, UUID snapshotID) {
        IAccessAuthorizer accessAuthorizer = OzoneAuthorizerFactory.forSnapshot(ozoneManager, keyManager, prefixManager);
        this.omMetadataReader = new OmMetadataReader(keyManager, prefixManager, ozoneManager, LOG, AUDIT, OmSnapshotMetrics.getInstance(), accessAuthorizer);
        this.snapshotName = snapshotName;
        this.bucketName = bucketName;
        this.volumeName = volumeName;
        this.snapshotID = snapshotID;
        this.keyManager = keyManager;
        this.omMetadataManager = keyManager.getMetadataManager();
    }

    public OmKeyInfo lookupKey(OmKeyArgs args) throws IOException {
        return this.denormalizeOmKeyInfo(this.omMetadataReader.lookupKey(this.normalizeOmKeyArgs(args)));
    }

    public KeyInfoWithVolumeContext getKeyInfo(OmKeyArgs args, boolean assumeS3Context) throws IOException {
        return this.denormalizeKeyInfoWithVolumeContext(this.omMetadataReader.getKeyInfo(this.normalizeOmKeyArgs(args), assumeS3Context));
    }

    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries, boolean allowPartialPrefixes) throws IOException {
        List<OzoneFileStatus> l = this.omMetadataReader.listStatus(this.normalizeOmKeyArgs(args), recursive, this.normalizeKeyName(startKey), numEntries, allowPartialPrefixes);
        return l.stream().map(this::denormalizeOzoneFileStatus).collect(Collectors.toList());
    }

    public List<OzoneFileStatusLight> listStatusLight(OmKeyArgs args, boolean recursive, String startKey, long numEntries, boolean allowPartialPrefixes) throws IOException {
        List<OzoneFileStatus> ozoneFileStatuses = this.listStatus(args, recursive, startKey, numEntries, allowPartialPrefixes);
        return ozoneFileStatuses.stream().map(OzoneFileStatusLight::fromOzoneFileStatus).collect(Collectors.toList());
    }

    public OzoneFileStatus getFileStatus(OmKeyArgs args) throws IOException {
        return this.denormalizeOzoneFileStatus(this.omMetadataReader.getFileStatus(this.normalizeOmKeyArgs(args)));
    }

    public OmKeyInfo lookupFile(OmKeyArgs args) throws IOException {
        return this.denormalizeOmKeyInfo(this.omMetadataReader.lookupFile(this.normalizeOmKeyArgs(args)));
    }

    public ListKeysResult listKeys(String vname, String bname, String startKey, String keyPrefix, int maxKeys) throws IOException {
        ListKeysResult listKeysResult = this.omMetadataReader.listKeys(vname, bname, this.normalizeKeyName(startKey), this.normalizeKeyName(keyPrefix), maxKeys);
        return new ListKeysResult(listKeysResult.getKeys().stream().map(this::denormalizeOmKeyInfo).collect(Collectors.toList()), listKeysResult.isTruncated());
    }

    public ListKeysLightResult listKeysLight(String volName, String buckName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        ListKeysResult listKeysResult = this.listKeys(this.volumeName, this.bucketName, startKey, keyPrefix, maxKeys);
        List keys = listKeysResult.getKeys();
        List basicKeysList = keys.stream().map(BasicOmKeyInfo::fromOmKeyInfo).collect(Collectors.toList());
        return new ListKeysLightResult(basicKeysList, listKeysResult.isTruncated());
    }

    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        return this.omMetadataReader.getAcl(this.normalizeOzoneObj(obj));
    }

    private OzoneObj normalizeOzoneObj(OzoneObj o) {
        if (o == null) {
            return null;
        }
        return OzoneObjInfo.Builder.getBuilder((OzoneObj.ResourceType)o.getResourceType(), (OzoneObj.StoreType)o.getStoreType(), (String)o.getVolumeName(), (String)o.getBucketName(), (String)this.normalizeKeyName(o.getKeyName())).setOzonePrefixPath(o.getOzonePrefixPathViewer()).build();
    }

    private String normalizeKeyName(String keyname) {
        if (keyname == null) {
            return null;
        }
        String[] keyParts = keyname.split("/");
        if (OmSnapshotManager.isSnapshotKey(keyParts)) {
            if (keyParts.length == 2) {
                return "";
            }
            String normalizedKeyName = String.join((CharSequence)"/", Arrays.copyOfRange(keyParts, 2, keyParts.length));
            if (keyname.endsWith("/")) {
                normalizedKeyName = String.valueOf(normalizedKeyName) + "/";
            }
            return normalizedKeyName;
        }
        return keyname;
    }

    private String denormalizeKeyName(String keyname) {
        if (keyname == null) {
            return null;
        }
        return String.valueOf(OmSnapshotManager.getSnapshotPrefix(this.snapshotName)) + keyname;
    }

    private OmKeyInfo denormalizeOmKeyInfo(OmKeyInfo keyInfo) {
        if (keyInfo == null) {
            return null;
        }
        OmKeyInfo denormalized = keyInfo.copyObject();
        denormalized.setKeyName(this.denormalizeKeyName(keyInfo.getKeyName()));
        return denormalized;
    }

    private OmKeyArgs normalizeOmKeyArgs(OmKeyArgs args) {
        if (args == null) {
            return null;
        }
        return args.toBuilder().setKeyName(this.normalizeKeyName(args.getKeyName())).build();
    }

    private OzoneFileStatus denormalizeOzoneFileStatus(OzoneFileStatus fileStatus) {
        if (fileStatus == null) {
            return null;
        }
        OmKeyInfo omKeyInfo = fileStatus.getKeyInfo() == null ? this.createDenormalizedBucketKeyInfo() : this.denormalizeOmKeyInfo(fileStatus.getKeyInfo());
        return new OzoneFileStatus(omKeyInfo, fileStatus.getBlockSize(), fileStatus.isDirectory());
    }

    private KeyInfoWithVolumeContext denormalizeKeyInfoWithVolumeContext(KeyInfoWithVolumeContext k) {
        return new KeyInfoWithVolumeContext.Builder().setKeyInfo(this.denormalizeOmKeyInfo(k.getKeyInfo())).setVolumeArgs((OmVolumeArgs)k.getVolumeArgs().orElse(null)).setUserPrincipal((String)k.getUserPrincipal().orElse(null)).build();
    }

    private OmKeyInfo createDenormalizedBucketKeyInfo() {
        return new OmKeyInfo.Builder().setVolumeName(this.volumeName).setBucketName(this.bucketName).setKeyName(this.denormalizeKeyName("")).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList()))).setCreationTime(Time.now()).setModificationTime(Time.now()).setDataSize(0L).setReplicationConfig((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ZERO)).build();
    }

    public String getName() {
        return this.snapshotName;
    }

    public UUID getSnapshotID() {
        return this.snapshotID;
    }

    @Override
    public void close() throws IOException {
        this.omMetadataManager.getStore().close();
    }

    protected void finalize() throws Throwable {
        if (!this.omMetadataManager.getStore().isClosed()) {
            LOG.warn("{} is not closed properly. snapshotName: {}", (Object)this.omMetadataManager.getStore().toString(), (Object)this.snapshotName);
        }
        super.finalize();
    }

    @VisibleForTesting
    public OMMetadataManager getMetadataManager() {
        return this.omMetadataManager;
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public String getSnapshotTableKey() {
        return SnapshotInfo.getTableKey((String)this.volumeName, (String)this.bucketName, (String)this.snapshotName);
    }
}

