/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.multitenant;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.om.multitenant.MultiTenantAccessController;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.http.auth.BasicUserPrincipal;
import org.apache.kerby.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerRestMultiTenantAccessController
implements MultiTenantAccessController {
    public static final String OZONE_RANGER_POLICY_HTTP_ENDPOINT = "/service/public/v2/api/policy/";
    public static final String OZONE_RANGER_ROLE_HTTP_ENDPOINT = "/service/public/v2/api/roles/";
    private static final Logger LOG = LoggerFactory.getLogger(RangerRestMultiTenantAccessController.class);
    private final OzoneConfiguration conf;
    private boolean ignoreServerCert = false;
    private int connectionTimeout;
    private int connectionRequestTimeout;
    private String authHeaderValue;
    private final String rangerHttpsAddress;
    private final Gson jsonConverter;
    private final String rangerService;
    private final Map<IAccessAuthorizer.ACLType, String> aclToString;
    private final Map<String, IAccessAuthorizer.ACLType> stringToAcl;
    private long lastPolicyUpdateTimeEpochMillis = -1L;
    private final JsonDeserializer<MultiTenantAccessController.Policy> policyDeserializer = new JsonDeserializer<MultiTenantAccessController.Policy>(){

        public MultiTenantAccessController.Policy deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject policyJson = jsonElement.getAsJsonObject();
            String name = policyJson.get("name").getAsString();
            MultiTenantAccessController.Policy.Builder policyB = new MultiTenantAccessController.Policy.Builder();
            policyB.setName(name);
            if (policyJson.has("description")) {
                policyB.setDescription(policyJson.get("description").getAsString());
            }
            policyB.setEnabled(policyJson.get("isEnabled").getAsBoolean());
            JsonObject resourcesJson = policyJson.get("resources").getAsJsonObject();
            JsonObject jsonVolumeResource = resourcesJson.get("volume").getAsJsonObject();
            JsonArray volumes = jsonVolumeResource.get("values").getAsJsonArray();
            volumes.forEach(vol -> {
                MultiTenantAccessController.Policy.Builder builder2 = policyB.addVolume(vol.getAsString());
            });
            if (resourcesJson.has("bucket")) {
                JsonObject jsonBucketResource = resourcesJson.get("bucket").getAsJsonObject();
                JsonArray buckets = jsonBucketResource.get("values").getAsJsonArray();
                buckets.forEach(bucket -> {
                    MultiTenantAccessController.Policy.Builder builder2 = policyB.addBucket(bucket.getAsString());
                });
            }
            if (resourcesJson.has("key")) {
                JsonObject jsonKeysResource = resourcesJson.get("key").getAsJsonObject();
                JsonArray keys = jsonKeysResource.get("values").getAsJsonArray();
                keys.forEach(key -> {
                    MultiTenantAccessController.Policy.Builder builder2 = policyB.addKey(key.getAsString());
                });
            }
            JsonArray policyItemsJson = policyJson.getAsJsonArray("policyItems");
            for (JsonElement policyItemElement : policyItemsJson) {
                JsonObject policyItemJson = policyItemElement.getAsJsonObject();
                JsonArray jsonRoles = policyItemJson.getAsJsonArray("roles");
                JsonArray jsonAclArray = policyItemJson.getAsJsonArray("accesses");
                for (JsonElement jsonAclElem : jsonAclArray) {
                    JsonObject jsonAcl = jsonAclElem.getAsJsonObject();
                    String aclType = jsonAcl.get("type").getAsString();
                    MultiTenantAccessController.Acl acl = jsonAcl.get("isAllowed").getAsBoolean() ? MultiTenantAccessController.Acl.allow((IAccessAuthorizer.ACLType)RangerRestMultiTenantAccessController.this.stringToAcl.get(aclType)) : MultiTenantAccessController.Acl.deny((IAccessAuthorizer.ACLType)RangerRestMultiTenantAccessController.this.stringToAcl.get(aclType));
                    for (JsonElement roleNameJson : jsonRoles) {
                        policyB.addRoleAcl(roleNameJson.getAsString(), Collections.singleton(acl));
                    }
                }
            }
            return policyB.build();
        }
    };
    private final JsonDeserializer<MultiTenantAccessController.Role> roleDeserializer = new JsonDeserializer<MultiTenantAccessController.Role>(){

        public MultiTenantAccessController.Role deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject roleJson = jsonElement.getAsJsonObject();
            String name = roleJson.get("name").getAsString();
            MultiTenantAccessController.Role.Builder role = new MultiTenantAccessController.Role.Builder();
            role.setName(name);
            if (roleJson.has("description")) {
                role.setDescription(roleJson.get("description").getAsString());
            }
            for (JsonElement jsonUser : roleJson.get("users").getAsJsonArray()) {
                String userName = jsonUser.getAsJsonObject().get("name").getAsString();
                role.addUser(userName, false);
            }
            return role.build();
        }
    };
    private final JsonSerializer<MultiTenantAccessController.Policy> policySerializer = new JsonSerializer<MultiTenantAccessController.Policy>(){

        public JsonElement serialize(MultiTenantAccessController.Policy javaPolicy, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonPolicy = new JsonObject();
            jsonPolicy.addProperty("name", javaPolicy.getName());
            jsonPolicy.addProperty("service", RangerRestMultiTenantAccessController.this.rangerService);
            jsonPolicy.addProperty("isEnabled", Boolean.valueOf(javaPolicy.isEnabled()));
            if (javaPolicy.getDescription().isPresent()) {
                jsonPolicy.addProperty("description", javaPolicy.getDescription().get());
            }
            JsonObject jsonResources = new JsonObject();
            JsonArray jsonVolumeNameArray = new JsonArray();
            for (String volumeName : javaPolicy.getVolumes()) {
                jsonVolumeNameArray.add((JsonElement)new JsonPrimitive(volumeName));
            }
            JsonObject jsonVolumeResource = new JsonObject();
            jsonVolumeResource.add("values", (JsonElement)jsonVolumeNameArray);
            jsonVolumeResource.addProperty("isRecursive", Boolean.valueOf(false));
            jsonVolumeResource.addProperty("isExcludes", Boolean.valueOf(false));
            jsonResources.add("volume", (JsonElement)jsonVolumeResource);
            JsonArray jsonBucketNameArray = new JsonArray();
            for (String bucketName : javaPolicy.getBuckets()) {
                jsonBucketNameArray.add((JsonElement)new JsonPrimitive(bucketName));
            }
            if (jsonBucketNameArray.size() > 0) {
                JsonObject jsonBucketResource = new JsonObject();
                jsonBucketResource.add("values", (JsonElement)jsonBucketNameArray);
                jsonBucketResource.addProperty("isRecursive", Boolean.valueOf(false));
                jsonBucketResource.addProperty("isExcludes", Boolean.valueOf(false));
                jsonResources.add("bucket", (JsonElement)jsonBucketResource);
            }
            JsonArray jsonKeyNameArray = new JsonArray();
            for (String keyName : javaPolicy.getKeys()) {
                jsonKeyNameArray.add((JsonElement)new JsonPrimitive(keyName));
            }
            if (jsonKeyNameArray.size() > 0) {
                JsonObject jsonKeyResource = new JsonObject();
                jsonKeyResource.add("values", (JsonElement)jsonKeyNameArray);
                jsonKeyResource.addProperty("isRecursive", Boolean.valueOf(false));
                jsonKeyResource.addProperty("isExcludes", Boolean.valueOf(false));
                jsonResources.add("key", (JsonElement)jsonKeyResource);
            }
            jsonPolicy.add("resources", (JsonElement)jsonResources);
            JsonArray jsonPolicyItemArray = new JsonArray();
            Map<String, Collection<MultiTenantAccessController.Acl>> roleAcls = javaPolicy.getRoleAcls();
            for (Map.Entry<String, Collection<MultiTenantAccessController.Acl>> entry : roleAcls.entrySet()) {
                String roleName = entry.getKey();
                JsonObject jsonPolicyItem = new JsonObject();
                JsonArray jsonRoles = new JsonArray();
                jsonRoles.add((JsonElement)new JsonPrimitive(roleName));
                jsonPolicyItem.add("roles", (JsonElement)jsonRoles);
                JsonArray jsonAclArray = new JsonArray();
                for (MultiTenantAccessController.Acl acl : entry.getValue()) {
                    JsonObject jsonAcl = new JsonObject();
                    jsonAcl.addProperty("type", (String)RangerRestMultiTenantAccessController.this.aclToString.get(acl.getAclType()));
                    jsonAcl.addProperty("isAllowed", Boolean.valueOf(acl.isAllowed()));
                    jsonAclArray.add((JsonElement)jsonAcl);
                    jsonPolicyItem.add("accesses", (JsonElement)jsonAclArray);
                }
                jsonPolicyItemArray.add((JsonElement)jsonPolicyItem);
            }
            jsonPolicy.add("policyItems", (JsonElement)jsonPolicyItemArray);
            return jsonPolicy;
        }
    };
    private final JsonSerializer<MultiTenantAccessController.Role> roleSerializer = new JsonSerializer<MultiTenantAccessController.Role>(){

        public JsonElement serialize(MultiTenantAccessController.Role javaRole, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonRole = new JsonObject();
            jsonRole.addProperty("name", javaRole.getName());
            JsonArray jsonUserArray = new JsonArray();
            for (String javaUser : javaRole.getUsersMap().keySet()) {
                jsonUserArray.add(RangerRestMultiTenantAccessController.this.jsonConverter.toJsonTree((Object)javaUser));
            }
            jsonRole.add("users", (JsonElement)jsonUserArray);
            return jsonRole;
        }
    };
    private final JsonSerializer<BasicUserPrincipal> userSerializer = new JsonSerializer<BasicUserPrincipal>(){

        public JsonElement serialize(BasicUserPrincipal user, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonMember = new JsonObject();
            jsonMember.addProperty("name", user.getName());
            jsonMember.addProperty("isAdmin", Boolean.valueOf(false));
            return jsonMember;
        }
    };

    private String getPolicyByNameEndpoint(String policyName) {
        return String.valueOf(this.rangerHttpsAddress) + "/service/public/v2/api/service/" + this.rangerService + "/policy/" + policyName;
    }

    private String getRoleByNameEndpoint(String roleName) {
        return String.valueOf(this.rangerHttpsAddress) + "/service/public/v2/api/roles/name/" + roleName;
    }

    public RangerRestMultiTenantAccessController(Configuration configuration) throws IOException {
        this.conf = new OzoneConfiguration(configuration);
        this.rangerHttpsAddress = this.conf.get("ozone.om.ranger.https-address");
        this.rangerService = this.conf.get("ozone.om.ranger.service");
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(MultiTenantAccessController.Policy.class, this.policySerializer);
        gsonBuilder.registerTypeAdapter(MultiTenantAccessController.Policy.class, this.policyDeserializer);
        gsonBuilder.registerTypeAdapter(MultiTenantAccessController.Role.class, this.roleSerializer);
        gsonBuilder.registerTypeAdapter(MultiTenantAccessController.Role.class, this.roleDeserializer);
        gsonBuilder.registerTypeAdapter(BasicUserPrincipal.class, this.userSerializer);
        this.jsonConverter = gsonBuilder.create();
        this.aclToString = new EnumMap<IAccessAuthorizer.ACLType, String>(IAccessAuthorizer.ACLType.class);
        this.stringToAcl = new HashMap<String, IAccessAuthorizer.ACLType>();
        this.fillRangerAclStrings();
        this.initializeRangerConnection();
    }

    private void fillRangerAclStrings() {
        this.aclToString.put(IAccessAuthorizer.ACLType.ALL, "all");
        this.aclToString.put(IAccessAuthorizer.ACLType.LIST, "list");
        this.aclToString.put(IAccessAuthorizer.ACLType.READ, "read");
        this.aclToString.put(IAccessAuthorizer.ACLType.WRITE, "write");
        this.aclToString.put(IAccessAuthorizer.ACLType.CREATE, "create");
        this.aclToString.put(IAccessAuthorizer.ACLType.DELETE, "delete");
        this.aclToString.put(IAccessAuthorizer.ACLType.READ_ACL, "read_acl");
        this.aclToString.put(IAccessAuthorizer.ACLType.WRITE_ACL, "write_acl");
        this.aclToString.put(IAccessAuthorizer.ACLType.NONE, "");
        this.stringToAcl.put("all", IAccessAuthorizer.ACLType.ALL);
        this.stringToAcl.put("list", IAccessAuthorizer.ACLType.LIST);
        this.stringToAcl.put("read", IAccessAuthorizer.ACLType.READ);
        this.stringToAcl.put("write", IAccessAuthorizer.ACLType.WRITE);
        this.stringToAcl.put("create", IAccessAuthorizer.ACLType.CREATE);
        this.stringToAcl.put("delete", IAccessAuthorizer.ACLType.DELETE);
        this.stringToAcl.put("read_acl", IAccessAuthorizer.ACLType.READ_ACL);
        this.stringToAcl.put("write_acl", IAccessAuthorizer.ACLType.WRITE_ACL);
        this.stringToAcl.put("", IAccessAuthorizer.ACLType.NONE);
    }

    private void initializeRangerConnection() {
        this.setupRangerConnectionConfig();
        if (this.ignoreServerCert) {
            this.setupRangerIgnoreServerCertificate();
        }
        this.setupRangerConnectionAuthHeader();
    }

    private void setupRangerConnectionConfig() {
        this.connectionTimeout = (int)this.conf.getTimeDuration("ozone.om.ranger.connection.timeout", this.conf.get("ozone.om.ranger.connection.timeout", "5s"), TimeUnit.MILLISECONDS);
        this.connectionRequestTimeout = (int)this.conf.getTimeDuration("ozone.om.ranger.connection.request.timeout", this.conf.get("ozone.om.ranger.connection.request.timeout", "5s"), TimeUnit.MILLISECONDS);
        this.ignoreServerCert = this.conf.getBoolean("ozone.om.ranger.ignore.cert", true);
    }

    private void setupRangerIgnoreServerCertificate() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {
            LOG.info("Setting DefaultSSLSocketFactory failed.");
        }
    }

    private void setupRangerConnectionAuthHeader() {
        String userName = this.conf.get("ozone.om.ranger.https.admin.api.user");
        String passwd = this.conf.get("ozone.om.ranger.https.admin.api.passwd");
        String auth = String.valueOf(userName) + ":" + passwd;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
        this.authHeaderValue = "Basic " + new String(encodedAuth, StandardCharsets.UTF_8);
    }

    @Override
    public MultiTenantAccessController.Policy createPolicy(MultiTenantAccessController.Policy policy) throws IOException {
        String rangerAdminUrl = String.valueOf(this.rangerHttpsAddress) + OZONE_RANGER_POLICY_HTTP_ENDPOINT;
        HttpsURLConnection conn = this.makeHttpsPostCall(rangerAdminUrl, (JsonElement)this.jsonConverter.toJsonTree((Object)policy).getAsJsonObject());
        if (!this.successfulResponseCode(conn.getResponseCode())) {
            throw new IOException(String.format("Failed to create policy %s. Http response code: %d", policy.getName(), conn.getResponseCode()));
        }
        this.getResponseData(conn);
        return policy;
    }

    @Override
    public void deletePolicy(String policyName) throws IOException {
        String rangerAdminUrl = this.getPolicyByNameEndpoint(policyName);
        HttpsURLConnection conn = this.makeHttpsDeleteCall(rangerAdminUrl);
        if (!this.successfulResponseCode(conn.getResponseCode())) {
            throw new IOException(String.format("Failed to delete policy '%s'. Http response code: %d", policyName, conn.getResponseCode()));
        }
    }

    public Map<Long, MultiTenantAccessController.Policy> getPolicies() throws Exception {
        String rangerAdminUrl = String.valueOf(this.rangerHttpsAddress) + OZONE_RANGER_POLICY_HTTP_ENDPOINT;
        HttpsURLConnection conn = this.makeHttpsGetCall(rangerAdminUrl);
        if (!this.successfulResponseCode(conn.getResponseCode())) {
            throw new IOException(String.format("Failed to get all policies. Http response code: %d", conn.getResponseCode()));
        }
        String allPoliciesString = this.getResponseData(conn);
        JsonArray jsonPoliciesArray = new JsonParser().parse(allPoliciesString).getAsJsonArray();
        HashMap<Long, MultiTenantAccessController.Policy> policies = new HashMap<Long, MultiTenantAccessController.Policy>();
        for (JsonElement jsonPolicy : jsonPoliciesArray) {
            JsonObject jsonPolicyObject = jsonPolicy.getAsJsonObject();
            String service = jsonPolicyObject.get("service").getAsString();
            if (!service.equals(this.rangerService)) continue;
            long id = jsonPolicyObject.get("id").getAsLong();
            policies.put(id, (MultiTenantAccessController.Policy)this.jsonConverter.fromJson((JsonElement)jsonPolicyObject, MultiTenantAccessController.Policy.class));
        }
        return policies;
    }

    @Override
    public MultiTenantAccessController.Policy getPolicy(String policyName) throws IOException {
        String rangerAdminUrl = this.getPolicyByNameEndpoint(policyName);
        HttpsURLConnection conn = this.makeHttpsGetCall(rangerAdminUrl);
        if (!this.successfulResponseCode(conn.getResponseCode())) {
            throw new IOException(String.format("Failed to get policy '%s'. Http response code: %d", policyName, conn.getResponseCode()));
        }
        String policyInfo = this.getResponseData(conn);
        return (MultiTenantAccessController.Policy)this.jsonConverter.fromJson(policyInfo, MultiTenantAccessController.Policy.class);
    }

    @Override
    public List<MultiTenantAccessController.Policy> getLabeledPolicies(String label) throws IOException {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public MultiTenantAccessController.Policy updatePolicy(MultiTenantAccessController.Policy policy) throws IOException {
        throw new NotImplementedException("Not Implemented");
    }

    public void updatePolicy(long policyID, MultiTenantAccessController.Policy policy) throws IOException {
        String rangerAdminUrl = String.valueOf(this.rangerHttpsAddress) + OZONE_RANGER_POLICY_HTTP_ENDPOINT + policyID;
        HttpsURLConnection conn = this.makeHttpsPutCall(rangerAdminUrl, this.jsonConverter.toJsonTree((Object)policy));
        if (!this.successfulResponseCode(conn.getResponseCode())) {
            throw new IOException(String.format("Failed to update policy %d. Http response code: %d", policyID, conn.getResponseCode()));
        }
    }

    @Override
    public MultiTenantAccessController.Role createRole(MultiTenantAccessController.Role role) throws IOException {
        String rangerAdminUrl = String.valueOf(this.rangerHttpsAddress) + OZONE_RANGER_ROLE_HTTP_ENDPOINT;
        HttpsURLConnection conn = this.makeHttpsPostCall(rangerAdminUrl, (JsonElement)this.jsonConverter.toJsonTree((Object)role).getAsJsonObject());
        if (!this.successfulResponseCode(conn.getResponseCode())) {
            throw new IOException(String.format("Failed to create role %s. Http response code: %d", role.getName(), conn.getResponseCode()));
        }
        String responseString = this.getResponseData(conn);
        new JsonParser().parse(responseString).getAsJsonObject();
        return role;
    }

    @Override
    public void deleteRole(String roleName) throws IOException {
        String rangerAdminUrl = this.getRoleByNameEndpoint(roleName);
        HttpsURLConnection conn = this.makeHttpsDeleteCall(rangerAdminUrl);
        if (!this.successfulResponseCode(conn.getResponseCode())) {
            throw new IOException(String.format("Failed to delete role '%s'. Http response code: %d", roleName, conn.getResponseCode()));
        }
    }

    @Override
    public long getRangerServicePolicyVersion() throws IOException {
        throw new NotImplementedException("Not Implemented");
    }

    public Map<Long, MultiTenantAccessController.Role> getRoles() throws Exception {
        String rangerAdminUrl = String.valueOf(this.rangerHttpsAddress) + OZONE_RANGER_ROLE_HTTP_ENDPOINT;
        HttpsURLConnection conn = this.makeHttpsGetCall(rangerAdminUrl);
        if (!this.successfulResponseCode(conn.getResponseCode())) {
            throw new IOException(String.format("Failed to get all roles. Http response code: %d", conn.getResponseCode()));
        }
        String allRolesString = this.getResponseData(conn);
        JsonArray rolesArrayJson = new JsonParser().parse(allRolesString).getAsJsonArray();
        HashMap<Long, MultiTenantAccessController.Role> roles = new HashMap<Long, MultiTenantAccessController.Role>();
        for (JsonElement roleJson : rolesArrayJson) {
            long id = roleJson.getAsJsonObject().get("id").getAsLong();
            roles.put(id, (MultiTenantAccessController.Role)this.jsonConverter.fromJson(roleJson, MultiTenantAccessController.Role.class));
        }
        return roles;
    }

    @Override
    public MultiTenantAccessController.Role getRole(String roleName) throws IOException {
        String rangerAdminUrl = this.getRoleByNameEndpoint(roleName);
        HttpsURLConnection conn = this.makeHttpsGetCall(rangerAdminUrl);
        if (!this.successfulResponseCode(conn.getResponseCode())) {
            throw new IOException(String.format("Failed to get role '%s'. Http response code: %d", roleName, conn.getResponseCode()));
        }
        String roleInfo = this.getResponseData(conn);
        return (MultiTenantAccessController.Role)this.jsonConverter.fromJson(roleInfo, MultiTenantAccessController.Role.class);
    }

    @Override
    public MultiTenantAccessController.Role updateRole(long roleId, MultiTenantAccessController.Role role) throws IOException {
        String rangerAdminUrl = String.valueOf(this.rangerHttpsAddress) + OZONE_RANGER_ROLE_HTTP_ENDPOINT + roleId;
        HttpsURLConnection conn = this.makeHttpsPutCall(rangerAdminUrl, this.jsonConverter.toJsonTree((Object)role));
        if (!this.successfulResponseCode(conn.getResponseCode())) {
            throw new IOException(String.format("Failed to update role %d. Http response code: %d", roleId, conn.getResponseCode()));
        }
        return role;
    }

    private HttpsURLConnection makeHttpsPutCall(String url, JsonElement content) throws IOException {
        HttpsURLConnection connection = this.makeBaseHttpsURLConnection(url);
        connection.setRequestMethod("PUT");
        return this.addJsonContentToConnection(connection, content);
    }

    private HttpsURLConnection makeHttpsPostCall(String url, JsonElement content) throws IOException {
        HttpsURLConnection connection = this.makeBaseHttpsURLConnection(url);
        connection.setRequestMethod("POST");
        return this.addJsonContentToConnection(connection, content);
    }

    private HttpsURLConnection addJsonContentToConnection(HttpsURLConnection connection, JsonElement content) throws IOException {
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/json;");
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = content.toString().getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
            os.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return connection;
    }

    private HttpsURLConnection makeHttpsGetCall(String urlString) throws IOException {
        HttpsURLConnection connection = this.makeBaseHttpsURLConnection(urlString);
        connection.setRequestMethod("GET");
        return connection;
    }

    private HttpsURLConnection makeHttpsDeleteCall(String urlString) throws IOException {
        HttpsURLConnection connection = this.makeBaseHttpsURLConnection(urlString);
        connection.setRequestMethod("DELETE");
        return connection;
    }

    private HttpsURLConnection makeBaseHttpsURLConnection(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
        urlConnection.setConnectTimeout(this.connectionTimeout);
        urlConnection.setReadTimeout(this.connectionRequestTimeout);
        urlConnection.setRequestProperty("Accept", "application/json");
        urlConnection.setRequestProperty("Authorization", this.authHeaderValue);
        return urlConnection;
    }

    private String getResponseData(HttpsURLConnection urlConnection) throws IOException {
        StringBuilder response = new StringBuilder();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.UTF_8));){
            String responseLine;
            while ((responseLine = br.readLine()) != null) {
                response.append(responseLine.trim());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return response.toString();
    }

    private boolean successfulResponseCode(long responseCode) {
        return responseCode >= 200L && responseCode < 300L;
    }

    public void setPolicyLastUpdateTime(long mtime) {
        this.lastPolicyUpdateTimeEpochMillis = mtime;
    }

    public long getPolicyLastUpdateTime() {
        return this.lastPolicyUpdateTimeEpochMillis;
    }

    public HashSet<String> getRoleList() {
        return null;
    }
}

