/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis_snapshot;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.server.http.HttpConfig;
import org.apache.hadoop.hdds.utils.HAUtils;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.hdds.utils.RDBSnapshotProvider;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.helpers.OMNodeDetails;
import org.apache.hadoop.security.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmRatisSnapshotProvider
extends RDBSnapshotProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OmRatisSnapshotProvider.class);
    private final Map<String, OMNodeDetails> peerNodesMap;
    private final HttpConfig.Policy httpPolicy;
    private final boolean spnegoEnabled;
    private final URLConnectionFactory connectionFactory;

    public OmRatisSnapshotProvider(File snapshotDir, Map<String, OMNodeDetails> peerNodesMap, HttpConfig.Policy httpPolicy, boolean spnegoEnabled, URLConnectionFactory connectionFactory) {
        super(snapshotDir, "om.db");
        this.peerNodesMap = new ConcurrentHashMap<String, OMNodeDetails>(peerNodesMap);
        this.httpPolicy = httpPolicy;
        this.spnegoEnabled = spnegoEnabled;
        this.connectionFactory = connectionFactory;
    }

    public OmRatisSnapshotProvider(MutableConfigurationSource conf, File omRatisSnapshotDir, Map<String, OMNodeDetails> peerNodeDetails) {
        super(omRatisSnapshotDir, "om.db");
        LOG.info("Initializing OM Snapshot Provider");
        this.peerNodesMap = new ConcurrentHashMap<String, OMNodeDetails>();
        this.peerNodesMap.putAll(peerNodeDetails);
        this.httpPolicy = HttpConfig.getHttpPolicy((MutableConfigurationSource)conf);
        this.spnegoEnabled = conf.get("ozone.om.http.auth.type", "simple").equals("kerberos");
        TimeUnit connectionTimeoutUnit = OMConfigKeys.OZONE_OM_SNAPSHOT_PROVIDER_CONNECTION_TIMEOUT_DEFAULT.getUnit();
        int connectionTimeoutMS = (int)conf.getTimeDuration("ozone.om.snapshot.provider.connection.timeout", OMConfigKeys.OZONE_OM_SNAPSHOT_PROVIDER_CONNECTION_TIMEOUT_DEFAULT.getDuration(), connectionTimeoutUnit);
        TimeUnit requestTimeoutUnit = OMConfigKeys.OZONE_OM_SNAPSHOT_PROVIDER_REQUEST_TIMEOUT_DEFAULT.getUnit();
        int requestTimeoutMS = (int)conf.getTimeDuration("ozone.om.snapshot.provider.request.timeout", OMConfigKeys.OZONE_OM_SNAPSHOT_PROVIDER_REQUEST_TIMEOUT_DEFAULT.getDuration(), requestTimeoutUnit);
        this.connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((int)connectionTimeoutMS, (int)requestTimeoutMS, (Configuration)LegacyHadoopConfigurationSource.asHadoopConfiguration((ConfigurationSource)conf));
    }

    public void addNewPeerNode(OMNodeDetails newOMNode) {
        this.peerNodesMap.put(newOMNode.getNodeId(), newOMNode);
    }

    public void removeDecommissionedPeerNode(String decommNodeId) {
        this.peerNodesMap.remove(decommNodeId);
    }

    public void downloadSnapshot(String leaderNodeID, File targetFile) throws IOException {
        OMNodeDetails leader = this.peerNodesMap.get(leaderNodeID);
        URL omCheckpointUrl = leader.getOMDBCheckpointEndpointUrl(this.httpPolicy.isHttpEnabled(), true);
        LOG.info("Downloading latest checkpoint from Leader OM {}. Checkpoint URL: {}", (Object)leaderNodeID, (Object)omCheckpointUrl);
        SecurityUtil.doAsCurrentUser(() -> {
            HttpURLConnection connection = (HttpURLConnection)this.connectionFactory.openConnection(omCheckpointUrl, this.spnegoEnabled);
            connection.setRequestMethod("POST");
            String contentTypeValue = "multipart/form-data; boundary=---XXX";
            connection.setRequestProperty("Content-Type", contentTypeValue);
            connection.setDoOutput(true);
            OmRatisSnapshotProvider.writeFormData(connection, HAUtils.getExistingSstFiles((File)this.getCandidateDir()));
            connection.connect();
            int errorCode = connection.getResponseCode();
            if (errorCode != 200 && errorCode != 201) {
                throw new IOException("Unexpected exception when trying to reach OM to download latest checkpoint. Checkpoint URL: " + omCheckpointUrl + ". ErrorCode: " + errorCode);
            }
            try {
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (InputStream inputStream = connection.getInputStream();){
                        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)targetFile);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException ex) {
                    boolean deleted = FileUtils.deleteQuietly((File)targetFile);
                    if (!deleted) {
                        LOG.error("OM snapshot which failed to download {} cannot be deleted", (Object)targetFile);
                    }
                    throw ex;
                }
            }
            finally {
                connection.disconnect();
            }
            return null;
        });
    }

    public static void writeFormData(HttpURLConnection connection, List<String> sstFiles) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DataOutputStream out = new DataOutputStream(connection.getOutputStream());){
            String toExcludeSstField = "name=\"toExcludeSST[]\"";
            String crNl = "\r\n";
            String contentDisposition = "Content-Disposition: form-data; " + toExcludeSstField + crNl + crNl;
            String separator = "-----XXX";
            if (sstFiles.isEmpty()) {
                out.writeBytes(String.valueOf(separator) + crNl);
                out.writeBytes(contentDisposition);
            }
            for (String sstFile : sstFiles) {
                out.writeBytes(String.valueOf(separator) + crNl);
                out.writeBytes(contentDisposition);
                out.writeBytes(String.valueOf(sstFile) + crNl);
            }
            out.writeBytes(String.valueOf(separator) + "--" + crNl);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void close() throws IOException {
        if (this.connectionFactory != null) {
            this.connectionFactory.destroy();
        }
    }
}

