/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.client.DefaultReplicationConfig;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.OzoneManagerUtils;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OMFileRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMFileRequest.class);

    private OMFileRequest() {
    }

    public static OMPathInfo verifyFilesInPath(@Nonnull OMMetadataManager omMetadataManager, @Nonnull String volumeName, @Nonnull String bucketName, @Nonnull String keyName, @Nonnull Path keyPath) throws IOException {
        String fileNameFromDetails = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
        String dirNameFromDetails = omMetadataManager.getOzoneDirKey(volumeName, bucketName, keyName);
        ArrayList<String> missing = new ArrayList<String>();
        ArrayList<OzoneAcl> acls = new ArrayList();
        OMDirectoryResult result = OMDirectoryResult.NONE;
        while (keyPath != null) {
            String pathName = keyPath.toString();
            String dbKeyName = omMetadataManager.getOzoneKey(volumeName, bucketName, pathName);
            String dbDirKeyName = omMetadataManager.getOzoneDirKey(volumeName, bucketName, pathName);
            if (omMetadataManager.getKeyTable(OzoneManagerUtils.getBucketLayout(omMetadataManager, volumeName, bucketName)).isExist((Object)dbKeyName)) {
                result = dbKeyName.equals(fileNameFromDetails) ? OMDirectoryResult.FILE_EXISTS : OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH;
            } else if (omMetadataManager.getKeyTable(OzoneManagerUtils.getBucketLayout(omMetadataManager, volumeName, bucketName)).isExist((Object)dbDirKeyName)) {
                if (dbDirKeyName.equals(dirNameFromDetails)) {
                    result = OMDirectoryResult.DIRECTORY_EXISTS;
                } else {
                    result = OMDirectoryResult.DIRECTORY_EXISTS_IN_GIVENPATH;
                    acls = ((OmKeyInfo)omMetadataManager.getKeyTable(OzoneManagerUtils.getBucketLayout(omMetadataManager, volumeName, bucketName)).get((Object)dbDirKeyName)).getAcls();
                    LOG.trace("Acls from parent {} are : {}", (Object)dbDirKeyName, acls);
                }
            } else if (!dbDirKeyName.equals(dirNameFromDetails)) {
                missing.add(keyPath.toString());
            }
            if (result != OMDirectoryResult.NONE) {
                LOG.trace("verifyFiles in Path : /{}/{}/{} : {}", new Object[]{volumeName, bucketName, keyName, result});
                return new OMPathInfo(missing, result, acls);
            }
            keyPath = keyPath.getParent();
        }
        if (acls.isEmpty()) {
            String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
            acls = ((OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey)).getAcls();
            LOG.trace("Acls from bucket {} are : {}", (Object)bucketName, acls);
        }
        LOG.trace("verifyFiles in Path : /{}/{}/{} : {}", new Object[]{volumeName, bucketName, keyName, result});
        return new OMPathInfo(missing, OMDirectoryResult.NONE, acls);
    }

    public static OMPathInfoWithFSO verifyDirectoryKeysInPath(@Nonnull OMMetadataManager omMetadataManager, @Nonnull String volumeName, @Nonnull String bucketName, @Nonnull String keyName, @Nonnull Path keyPath) throws IOException {
        String leafNodeName = OzoneFSUtils.getFileName((String)keyName);
        ArrayList<String> missing = new ArrayList<String>();
        OMDirectoryResult result = OMDirectoryResult.NONE;
        Iterator<Path> elements = keyPath.iterator();
        String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
        OmBucketInfo omBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey);
        long volumeId = omMetadataManager.getVolumeId(volumeName);
        long bucketId = omMetadataManager.getBucketId(volumeName, bucketName);
        List acls = omBucketInfo.getAcls();
        long lastKnownParentId = omBucketInfo.getObjectID();
        String dbDirName = "";
        StringBuilder fullKeyPath = new StringBuilder(bucketKey);
        while (elements.hasNext()) {
            String fileName = elements.next().toString();
            fullKeyPath.append("/");
            fullKeyPath.append(fileName);
            if (missing.size() > 0) {
                if (!elements.hasNext()) continue;
                missing.add(fileName);
                continue;
            }
            String dbNodeName = omMetadataManager.getOzonePathKey(volumeId, bucketId, lastKnownParentId, fileName);
            OmDirectoryInfo omDirInfo = (OmDirectoryInfo)omMetadataManager.getDirectoryTable().get((Object)dbNodeName);
            if (omDirInfo != null) {
                dbDirName = String.valueOf(dbDirName) + omDirInfo.getName() + "/";
                if (elements.hasNext()) {
                    result = OMDirectoryResult.DIRECTORY_EXISTS_IN_GIVENPATH;
                    lastKnownParentId = omDirInfo.getObjectID();
                    acls = omDirInfo.getAcls();
                    continue;
                }
                result = OMDirectoryResult.DIRECTORY_EXISTS;
                continue;
            }
            if (omMetadataManager.getKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED).isExist((Object)dbNodeName)) {
                if (elements.hasNext()) {
                    result = OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH;
                    break;
                }
                result = OMDirectoryResult.FILE_EXISTS;
                break;
            }
            if (!elements.hasNext()) continue;
            missing.add(fileName);
        }
        LOG.trace("verifyFiles/Directories in Path : /{}/{}/{} : {}", new Object[]{volumeName, bucketName, keyName, result});
        if (result == OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH || result == OMDirectoryResult.FILE_EXISTS) {
            return new OMPathInfoWithFSO(leafNodeName, lastKnownParentId, missing, result, acls, fullKeyPath.toString());
        }
        String dbDirKeyName = omMetadataManager.getOzoneDirKey(volumeName, bucketName, dbDirName);
        LOG.trace("Acls from parent {} are : {}", (Object)dbDirKeyName, (Object)acls);
        return new OMPathInfoWithFSO(leafNodeName, lastKnownParentId, missing, result, acls);
    }

    public static void addKeyTableCacheEntries(OMMetadataManager omMetadataManager, String volumeName, String bucketName, BucketLayout layout, OmKeyInfo keyInfo, List<OmKeyInfo> parentInfoList, long index) throws IOException {
        Table table = omMetadataManager.getKeyTable(layout);
        for (OmKeyInfo parentInfo : parentInfoList) {
            table.addCacheEntry((Object)omMetadataManager.getOzoneKey(volumeName, bucketName, parentInfo.getKeyName()), (Object)parentInfo, index);
        }
        if (keyInfo != null) {
            table.addCacheEntry((Object)omMetadataManager.getOzoneKey(volumeName, bucketName, keyInfo.getKeyName()), (Object)keyInfo, index);
        }
    }

    public static void addDirectoryTableCacheEntries(OMMetadataManager omMetadataManager, long volumeId, long bucketId, long trxnLogIndex, List<OmDirectoryInfo> missingParentInfos, OmDirectoryInfo dirInfo) {
        Table table = omMetadataManager.getDirectoryTable();
        for (OmDirectoryInfo subDirInfo : missingParentInfos) {
            table.addCacheEntry((Object)omMetadataManager.getOzonePathKey(volumeId, bucketId, subDirInfo), (Object)subDirInfo, trxnLogIndex);
        }
        if (dirInfo != null) {
            table.addCacheEntry((Object)omMetadataManager.getOzonePathKey(volumeId, bucketId, dirInfo), (Object)dirInfo, trxnLogIndex);
        }
    }

    public static void addOpenFileTableCacheEntry(OMMetadataManager omMetadataManager, String dbOpenFileName, @Nullable OmKeyInfo omFileInfo, String fileName, long trxnLogIndex) {
        Table table = omMetadataManager.getOpenKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED);
        if (omFileInfo != null) {
            omFileInfo.setKeyName(fileName);
            omFileInfo.setFileName(fileName);
            table.addCacheEntry((Object)dbOpenFileName, (Object)omFileInfo, trxnLogIndex);
        } else {
            table.addCacheEntry((Object)dbOpenFileName, trxnLogIndex);
        }
    }

    public static void addFileTableCacheEntry(OMMetadataManager omMetadataManager, String dbFileKey, OmKeyInfo omFileInfo, String fileName, long trxnLogIndex) throws IOException {
        omFileInfo.setKeyName(fileName);
        omFileInfo.setFileName(fileName);
        BucketLayout bucketLayout = OzoneManagerUtils.getBucketLayout(omMetadataManager, omFileInfo.getVolumeName(), omFileInfo.getBucketName());
        omMetadataManager.getKeyTable(bucketLayout).addCacheEntry((Object)dbFileKey, (Object)omFileInfo, trxnLogIndex);
    }

    public static void addToOpenFileTable(OMMetadataManager omMetadataMgr, BatchOperation batchOp, OmKeyInfo omFileInfo, long openKeySessionID, long volumeId, long bucketId) throws IOException {
        String dbOpenFileKey = omMetadataMgr.getOpenFileName(volumeId, bucketId, omFileInfo.getParentObjectID(), omFileInfo.getFileName(), openKeySessionID);
        omMetadataMgr.getOpenKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED).putWithBatch(batchOp, (Object)dbOpenFileKey, (Object)omFileInfo);
    }

    public static String addToOpenFileTableForMultipart(OMMetadataManager omMetadataMgr, BatchOperation batchOp, OmKeyInfo omFileInfo, String uploadID, long volumeId, long bucketId) throws IOException {
        String multipartFileKey = omMetadataMgr.getMultipartKey(volumeId, bucketId, omFileInfo.getParentObjectID(), omFileInfo.getFileName(), uploadID);
        omMetadataMgr.getOpenKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED).putWithBatch(batchOp, (Object)multipartFileKey, (Object)omFileInfo);
        return multipartFileKey;
    }

    public static String addToFileTable(OMMetadataManager omMetadataMgr, BatchOperation batchOp, OmKeyInfo omFileInfo, long volumeId, long bucketId) throws IOException {
        String dbFileKey = omMetadataMgr.getOzonePathKey(volumeId, bucketId, omFileInfo.getParentObjectID(), omFileInfo.getFileName());
        omMetadataMgr.getKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED).putWithBatch(batchOp, (Object)dbFileKey, (Object)omFileInfo);
        return dbFileKey;
    }

    public static OmKeyInfo getOmKeyInfoFromFileTable(boolean openFileTable, OMMetadataManager omMetadataMgr, String dbOpenFileKey, String keyName) throws IOException {
        OmKeyInfo dbOmKeyInfo = openFileTable ? (OmKeyInfo)omMetadataMgr.getOpenKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED).get((Object)dbOpenFileKey) : (OmKeyInfo)omMetadataMgr.getKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED).get((Object)dbOpenFileKey);
        if (dbOmKeyInfo != null) {
            dbOmKeyInfo.setKeyName(keyName);
        }
        return dbOmKeyInfo;
    }

    @Nullable
    public static OzoneFileStatus getOMKeyInfoIfExists(OMMetadataManager omMetadataMgr, String volumeName, String bucketName, String keyName, long scmBlockSize, ReplicationConfig defaultReplication) throws IOException {
        return OMFileRequest.getOMKeyInfoIfExists(omMetadataMgr, volumeName, bucketName, keyName, scmBlockSize, defaultReplication, true);
    }

    @Nullable
    public static OzoneFileStatus getOMKeyInfoIfExists(OMMetadataManager omMetadataMgr, String volumeName, String bucketName, String keyName, long scmBlockSize, ReplicationConfig defaultReplication, boolean validateBucketAndVolume) throws IOException {
        if (validateBucketAndVolume) {
            OMFileRequest.validateBucket(omMetadataMgr, volumeName, bucketName);
        }
        Path keyPath = Paths.get(keyName, new String[0]);
        Iterator<Path> elements = keyPath.iterator();
        long volumeId = omMetadataMgr.getVolumeId(volumeName);
        String bucketKey = omMetadataMgr.getBucketKey(volumeName, bucketName);
        OmBucketInfo omBucketInfo = (OmBucketInfo)omMetadataMgr.getBucketTable().get((Object)bucketKey);
        long lastKnownParentId = omBucketInfo.getObjectID();
        OmDirectoryInfo omDirInfo = null;
        while (elements.hasNext()) {
            String fileName = elements.next().toString();
            String dbNodeName = omMetadataMgr.getOzonePathKey(volumeId, omBucketInfo.getObjectID(), lastKnownParentId, fileName);
            omDirInfo = (OmDirectoryInfo)omMetadataMgr.getDirectoryTable().get((Object)dbNodeName);
            if (omDirInfo != null) {
                lastKnownParentId = omDirInfo.getObjectID();
                continue;
            }
            if (!elements.hasNext() && !keyName.endsWith("/")) {
                OmKeyInfo omKeyInfo = OMFileRequest.getOmKeyInfoFromFileTable(false, omMetadataMgr, dbNodeName, keyName);
                if (omKeyInfo == null) continue;
                return new OzoneFileStatus(omKeyInfo, scmBlockSize, false);
            }
            return null;
        }
        if (omDirInfo != null) {
            OmKeyInfo omKeyInfo = OMFileRequest.getOmKeyInfo(volumeName, bucketName, omDirInfo, keyName);
            ReplicationConfig replicationConfig = Optional.ofNullable(omBucketInfo.getDefaultReplicationConfig()).map(DefaultReplicationConfig::getReplicationConfig).orElse(defaultReplication);
            omKeyInfo.setReplicationConfig(replicationConfig);
            return new OzoneFileStatus(omKeyInfo, scmBlockSize, true);
        }
        return null;
    }

    @NotNull
    public static OmKeyInfo getOmKeyInfo(String volumeName, String bucketName, OmDirectoryInfo dirInfo, String keyName) {
        return new OmKeyInfo.Builder().setParentObjectID(dirInfo.getParentObjectID()).setKeyName(keyName).setAcls(dirInfo.getAcls()).addAllMetadata(dirInfo.getMetadata()).setVolumeName(volumeName).setBucketName(bucketName).setCreationTime(dirInfo.getCreationTime()).setModificationTime(dirInfo.getModificationTime()).setObjectID(dirInfo.getObjectID()).setUpdateID(dirInfo.getUpdateID()).setFileName(dirInfo.getName()).setReplicationConfig((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ONE)).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList()))).build();
    }

    @NotNull
    public static String getAbsolutePath(String prefixName, String fileName) {
        if (Strings.isNullOrEmpty((String)prefixName)) {
            return fileName;
        }
        prefixName = OzoneFSUtils.addTrailingSlashIfNeeded((String)prefixName);
        return prefixName.concat(fileName);
    }

    public static OmDirectoryInfo getDirectoryInfo(OmKeyInfo keyInfo) {
        return new OmDirectoryInfo.Builder().setParentObjectID(keyInfo.getParentObjectID()).setAcls(keyInfo.getAcls()).addAllMetadata(keyInfo.getMetadata()).setCreationTime(keyInfo.getCreationTime()).setModificationTime(keyInfo.getModificationTime()).setObjectID(keyInfo.getObjectID()).setUpdateID(keyInfo.getUpdateID()).setName(OzoneFSUtils.getFileName((String)keyInfo.getKeyName())).build();
    }

    public static void verifyToDirIsASubDirOfFromDirectory(String fromKeyName, String toKeyName, boolean isDir) throws OMException {
        if (!isDir) {
            return;
        }
        Path dstParent = Paths.get(toKeyName, new String[0]).getParent();
        while (dstParent != null) {
            if (Paths.get(fromKeyName, new String[0]).equals(dstParent)) {
                throw new OMException("Cannot rename a directory to its own subdirectory", OMException.ResultCodes.KEY_RENAME_ERROR);
            }
            dstParent = dstParent.getParent();
        }
    }

    public static OmKeyInfo getKeyParentDir(String volumeName, String bucketName, String toKeyName, OzoneManager ozoneManager, OMMetadataManager metaMgr) throws IOException {
        int totalDirsCount = OzoneFSUtils.getFileCount((String)toKeyName);
        if (totalDirsCount <= 1) {
            return null;
        }
        String toKeyParentDir = OzoneFSUtils.getParentDir((String)toKeyName);
        OzoneFileStatus toKeyParentDirStatus = OMFileRequest.getOMKeyInfoIfExists(metaMgr, volumeName, bucketName, toKeyParentDir, 0L, ozoneManager.getDefaultReplicationConfig());
        if (toKeyParentDirStatus == null) {
            throw new OMException(String.format("Failed to get parent dir %s, %s doesn't exist", toKeyName, toKeyParentDir), OMException.ResultCodes.KEY_RENAME_ERROR);
        }
        if (toKeyParentDirStatus.isFile()) {
            throw new OMException(String.format("Failed to get parent dir %s, %s is a file", toKeyName, toKeyParentDir), OMException.ResultCodes.KEY_RENAME_ERROR);
        }
        return toKeyParentDirStatus.getKeyInfo();
    }

    public static boolean hasChildren(OmKeyInfo omKeyInfo, OMMetadataManager metaMgr) throws IOException {
        return OMFileRequest.checkSubDirectoryExists(omKeyInfo, metaMgr) || OMFileRequest.checkSubFileExists(omKeyInfo, metaMgr);
    }

    private static boolean checkSubDirectoryExists(OmKeyInfo omKeyInfo, OMMetadataManager metaMgr) throws IOException {
        Table dirTable = metaMgr.getDirectoryTable();
        Iterator cacheIter = dirTable.cacheIterator();
        while (cacheIter.hasNext()) {
            Map.Entry entry = (Map.Entry)cacheIter.next();
            OmDirectoryInfo cacheOmDirInfo = (OmDirectoryInfo)((CacheValue)entry.getValue()).getCacheValue();
            if (cacheOmDirInfo == null || !OMFileRequest.isImmediateChild(cacheOmDirInfo.getParentObjectID(), omKeyInfo.getObjectID())) continue;
            return true;
        }
        long volumeId = metaMgr.getVolumeId(omKeyInfo.getVolumeName());
        long bucketId = metaMgr.getBucketId(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName());
        String seekDirInDB = metaMgr.getOzonePathKey(volumeId, bucketId, omKeyInfo.getObjectID(), "");
        Throwable throwable = null;
        Object var10_11 = null;
        try (TableIterator iterator = dirTable.iterator();){
            iterator.seek((Object)seekDirInDB);
            if (iterator.hasNext()) {
                Table.KeyValue entry = (Table.KeyValue)iterator.next();
                OmDirectoryInfo dirInfo = (OmDirectoryInfo)entry.getValue();
                return OMFileRequest.isImmediateChild(dirInfo.getParentObjectID(), omKeyInfo.getObjectID());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return false;
    }

    private static boolean checkSubFileExists(OmKeyInfo omKeyInfo, OMMetadataManager metaMgr) throws IOException {
        BucketLayout bucketLayout = OzoneManagerUtils.getBucketLayout(metaMgr, omKeyInfo.getVolumeName(), omKeyInfo.getBucketName());
        Table fileTable = metaMgr.getKeyTable(bucketLayout);
        Iterator cacheIter = fileTable.cacheIterator();
        while (cacheIter.hasNext()) {
            Map.Entry entry = (Map.Entry)cacheIter.next();
            OmKeyInfo cacheOmFileInfo = (OmKeyInfo)((CacheValue)entry.getValue()).getCacheValue();
            if (cacheOmFileInfo == null || !OMFileRequest.isImmediateChild(cacheOmFileInfo.getParentObjectID(), omKeyInfo.getObjectID())) continue;
            return true;
        }
        long volumeId = metaMgr.getVolumeId(omKeyInfo.getVolumeName());
        long bucketId = metaMgr.getBucketId(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName());
        String seekFileInDB = metaMgr.getOzonePathKey(volumeId, bucketId, omKeyInfo.getObjectID(), "");
        Throwable throwable = null;
        Object var11_12 = null;
        try (TableIterator iterator = fileTable.iterator();){
            iterator.seek((Object)seekFileInDB);
            if (iterator.hasNext()) {
                Table.KeyValue entry = (Table.KeyValue)iterator.next();
                OmKeyInfo fileInfo = (OmKeyInfo)entry.getValue();
                return OMFileRequest.isImmediateChild(fileInfo.getParentObjectID(), omKeyInfo.getObjectID());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return false;
    }

    public static boolean isImmediateChild(long parentId, long ancestorId) {
        return parentId == ancestorId;
    }

    public static long getParentID(long volumeId, long bucketId, Iterator<Path> pathComponents, String keyName, OMMetadataManager omMetadataManager) throws IOException {
        return OMFileRequest.getParentID(volumeId, bucketId, pathComponents, keyName, omMetadataManager, null);
    }

    public static long getParentID(long volumeId, long bucketId, Iterator<Path> pathComponents, String keyName, OMMetadataManager omMetadataManager, String errMsg) throws IOException {
        long lastKnownParentId = bucketId;
        if (!pathComponents.hasNext()) {
            return bucketId;
        }
        if (StringUtils.isBlank((CharSequence)errMsg)) {
            errMsg = "Failed to find parent directory of " + keyName;
        }
        while (pathComponents.hasNext()) {
            String nodeName = pathComponents.next().toString();
            boolean reachedLastPathComponent = !pathComponents.hasNext();
            String dbNodeName = omMetadataManager.getOzonePathKey(volumeId, bucketId, lastKnownParentId, nodeName);
            OmDirectoryInfo omDirectoryInfo = (OmDirectoryInfo)omMetadataManager.getDirectoryTable().get((Object)dbNodeName);
            if (omDirectoryInfo != null) {
                if (reachedLastPathComponent) {
                    throw new OMException("Can not create file: " + keyName + " as there is already directory in the given path", OMException.ResultCodes.NOT_A_FILE);
                }
                lastKnownParentId = omDirectoryInfo.getObjectID();
                continue;
            }
            if (reachedLastPathComponent) break;
            throw new OMException(errMsg, OMException.ResultCodes.DIRECTORY_NOT_FOUND);
        }
        return lastKnownParentId;
    }

    public static long getParentId(OMMetadataManager omMetadataManager, String volumeName, String bucketName, String keyName) throws IOException {
        long volumeId = omMetadataManager.getVolumeId(volumeName);
        long bucketId = omMetadataManager.getBucketId(volumeName, bucketName);
        Iterator<Path> pathComponents = Paths.get(keyName, new String[0]).iterator();
        return OMFileRequest.getParentID(volumeId, bucketId, pathComponents, keyName, omMetadataManager);
    }

    public static void validateBucket(OMMetadataManager metadataManager, String volumeName, String bucketName) throws IOException {
        String bucketKey = metadataManager.getBucketKey(volumeName, bucketName);
        if (metadataManager.getBucketTable().get((Object)bucketKey) == null) {
            String volumeKey = metadataManager.getVolumeKey(volumeName);
            if (metadataManager.getVolumeTable().get((Object)volumeKey) == null) {
                LOG.error("volume not found: {}", (Object)volumeName);
                throw new OMException("Volume not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            LOG.error("bucket not found: {}/{} ", (Object)volumeName, (Object)bucketName);
            throw new OMException("Bucket not found", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
    }

    public static enum OMDirectoryResult {
        DIRECTORY_EXISTS_IN_GIVENPATH,
        FILE_EXISTS_IN_GIVENPATH,
        FILE_EXISTS,
        DIRECTORY_EXISTS,
        NONE;

    }

    public static class OMPathInfo {
        private final OMDirectoryResult directoryResult;
        private final List<String> missingParents;
        private final List<OzoneAcl> acls;

        public OMPathInfo(List missingParents, OMDirectoryResult result, List<OzoneAcl> aclList) {
            this.missingParents = missingParents;
            this.directoryResult = result;
            this.acls = aclList;
        }

        public List<String> getMissingParents() {
            return this.missingParents;
        }

        public OMDirectoryResult getDirectoryResult() {
            return this.directoryResult;
        }

        public List<OzoneAcl> getAcls() {
            return this.acls;
        }

        public boolean directParentExists() {
            return this.missingParents.isEmpty();
        }
    }

    public static class OMPathInfoWithFSO
    extends OMPathInfo {
        private final String leafNodeName;
        private final String fileExistsInPath;
        private long lastKnownParentId;
        private long leafNodeObjectId;

        public OMPathInfoWithFSO(String leafNodeName, long lastKnownParentId, List missingParents, OMDirectoryResult result, List<OzoneAcl> aclList, String fileExistsInPath) {
            super(missingParents, result, aclList);
            this.leafNodeName = leafNodeName;
            this.lastKnownParentId = lastKnownParentId;
            this.fileExistsInPath = fileExistsInPath;
        }

        public OMPathInfoWithFSO(String leafNodeName, long lastKnownParentId, List missingParents, OMDirectoryResult result, List<OzoneAcl> aclList) {
            this(leafNodeName, lastKnownParentId, missingParents, result, aclList, "");
        }

        public String getLeafNodeName() {
            return this.leafNodeName;
        }

        public long getLeafNodeObjectId() {
            return this.leafNodeObjectId;
        }

        public void setLeafNodeObjectId(long leafNodeObjectId) {
            this.leafNodeObjectId = leafNodeObjectId;
        }

        public void setLastKnownParentId(long lastKnownParentId) {
            this.lastKnownParentId = lastKnownParentId;
        }

        public long getLastKnownParentId() {
            return this.lastKnownParentId;
        }

        public String getFileExistsInPath() {
            return this.fileExistsInPath;
        }
    }
}

