/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.security;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.s3.security.S3SecretRequestHelper;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.security.S3RevokeSecretResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3RevokeSecretRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        S3RevokeSecretRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(S3RevokeSecretRequest.class);
    }

    public S3RevokeSecretRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.RevokeS3SecretRequest s3RevokeSecretRequest = this.getOmRequest().getRevokeS3SecretRequest();
        String accessId = s3RevokeSecretRequest.getKerberosID();
        UserGroupInformation ugi = S3SecretRequestHelper.getOrCreateUgi(accessId);
        S3SecretRequestHelper.checkAccessIdSecretOpPermission(ozoneManager, ugi, accessId);
        OzoneManagerProtocolProtos.RevokeS3SecretRequest revokeS3SecretRequest = OzoneManagerProtocolProtos.RevokeS3SecretRequest.newBuilder().setKerberosID(accessId).build();
        OzoneManagerProtocolProtos.OMRequest.Builder omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setRevokeS3SecretRequest(revokeS3SecretRequest).setCmdType(this.getOmRequest().getCmdType()).setClientId(this.getOmRequest().getClientId());
        if (this.getOmRequest().hasTraceID()) {
            omRequest.setTraceID(this.getOmRequest().getTraceID());
        }
        return omRequest.build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OMClientResponse omClientResponse = null;
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        IOException exception = null;
        OzoneManagerProtocolProtos.RevokeS3SecretRequest revokeS3SecretRequest = this.getOmRequest().getRevokeS3SecretRequest();
        String kerberosID = revokeS3SecretRequest.getKerberosID();
        try {
            omClientResponse = (OMClientResponse)ozoneManager.getS3SecretManager().doUnderLock(kerberosID, s3SecretManager -> {
                if (s3SecretManager.hasS3Secret(kerberosID)) {
                    LOG.info("Secret for {} exists in table, removing it.", (Object)kerberosID);
                    s3SecretManager.invalidateCacheEntry(kerberosID);
                    return new S3RevokeSecretResponse(kerberosID, s3SecretManager, omResponse.setStatus(OzoneManagerProtocolProtos.Status.OK).build());
                }
                LOG.info("Secret for {} doesn't exist in table hence cannot invalidate it", (Object)kerberosID);
                return new S3RevokeSecretResponse(null, s3SecretManager, omResponse.setStatus(OzoneManagerProtocolProtos.Status.S3_SECRET_NOT_FOUND).build());
            });
        }
        catch (IOException ex) {
            exception = ex;
            omClientResponse = new S3RevokeSecretResponse(null, ozoneManager.getS3SecretManager(), this.createErrorOMResponse(omResponse, ex));
        }
        HashMap<String, String> auditMap = new HashMap<String, String>();
        auditMap.put("S3RevokeSecretUser", kerberosID);
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.REVOKE_S3_SECRET, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            if (omResponse.getStatus() == OzoneManagerProtocolProtos.Status.OK) {
                LOG.info("Secret for {} is revoked.", (Object)kerberosID);
            } else {
                LOG.info("Secret for {} doesn't exist.", (Object)kerberosID);
            }
        } else {
            LOG.error("Error when revoking secret for {}.", (Object)kerberosID, (Object)exception);
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("S3RevokeSecretRequest.java", S3RevokeSecretRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.s3.security.S3RevokeSecretRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 53);
    }
}

