/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.security;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.OzoneManagerUtils;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.security.OMGetDelegationTokenRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.security.OMCancelDelegationTokenResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMCancelDelegationTokenRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMCancelDelegationTokenRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMGetDelegationTokenRequest.class);
    }

    public OMCancelDelegationTokenRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.OMRequest request = super.preExecute(ozoneManager);
        AuditLogger auditLogger = ozoneManager.getAuditLogger();
        Map<String, String> auditMap = null;
        try {
            Token token = OMPBHelper.convertToDelegationToken((SecurityProtos.TokenProto)request.getCancelDelegationTokenRequest().getToken());
            auditMap = OzoneManagerUtils.buildTokenAuditMap((Token<OzoneTokenIdentifier>)token);
            ozoneManager.cancelDelegationToken((Token<OzoneTokenIdentifier>)token);
            return request;
        }
        catch (IOException ioe) {
            this.auditLog(auditLogger, this.buildAuditMessage(OMAction.CANCEL_DELEGATION_TOKEN, auditMap, ioe, request.getUserInfo()));
            throw ioe;
        }
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        Token<OzoneTokenIdentifier> token = this.getToken();
        AuditLogger auditLogger = ozoneManager.getAuditLogger();
        Map<String, String> auditMap = OzoneManagerUtils.buildTokenAuditMap(token);
        OMCancelDelegationTokenResponse omClientResponse = null;
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        OzoneTokenIdentifier ozoneTokenIdentifier = null;
        Exception exception = null;
        try {
            ozoneTokenIdentifier = OzoneTokenIdentifier.readProtoBuf((byte[])token.getIdentifier());
            ozoneManager.getDelegationTokenMgr().removeToken(ozoneTokenIdentifier);
            omMetadataManager.getDelegationTokenTable().addCacheEntry(new CacheKey((Object)ozoneTokenIdentifier), CacheValue.get((long)transactionLogIndex));
            omClientResponse = new OMCancelDelegationTokenResponse(ozoneTokenIdentifier, omResponse.setCancelDelegationTokenResponse(OzoneManagerProtocolProtos.CancelDelegationTokenResponseProto.newBuilder().setResponse(SecurityProtos.CancelDelegationTokenResponseProto.newBuilder())).build());
        }
        catch (IOException | InvalidPathException ex) {
            LOG.error("Error in cancel DelegationToken {}", (Object)ozoneTokenIdentifier, (Object)ex);
            exception = ex;
            omClientResponse = new OMCancelDelegationTokenResponse(null, this.createErrorOMResponse(omResponse, exception));
        }
        this.auditLog(auditLogger, this.buildAuditMessage(OMAction.CANCEL_DELEGATION_TOKEN, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cancelled delegation token: {}", (Object)ozoneTokenIdentifier);
        }
        return omClientResponse;
    }

    public Token<OzoneTokenIdentifier> getToken() {
        SecurityProtos.CancelDelegationTokenRequestProto cancelDelegationTokenRequest = this.getOmRequest().getCancelDelegationTokenRequest();
        return OMPBHelper.convertToDelegationToken((SecurityProtos.TokenProto)cancelDelegationTokenRequest.getToken());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMCancelDelegationTokenRequest.java", OMCancelDelegationTokenRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.security.OMCancelDelegationTokenRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 61);
    }
}

