/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.upgrade;

import java.io.IOException;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.upgrade.OMCancelPrepareResponse;
import org.apache.hadoop.ozone.om.response.upgrade.OMPrepareResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMCancelPrepareRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMCancelPrepareRequest.class);

    public OMCancelPrepareRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        LOG.info("OM {} Received cancel prepare request with log index {}", (Object)ozoneManager.getOMNodeId(), (Object)transactionLogIndex);
        OzoneManagerProtocolProtos.OMRequest omRequest = this.getOmRequest();
        OzoneManagerProtocolProtos.OMResponse.Builder responseBuilder = OmResponseUtil.getOMResponseBuilder(omRequest);
        responseBuilder.setCmdType(OzoneManagerProtocolProtos.Type.CancelPrepare);
        OMClientResponse response = null;
        try {
            UserGroupInformation ugi = this.createUGIForApi();
            if (ozoneManager.getAclsEnabled() && !ozoneManager.isAdmin(ugi)) {
                throw new OMException("Access denied for user " + ugi + ". " + "Superuser privilege is required to cancel ozone manager " + "preparation.", OMException.ResultCodes.ACCESS_DENIED);
            }
            OzoneManagerProtocolProtos.CancelPrepareResponse omResponse = OzoneManagerProtocolProtos.CancelPrepareResponse.newBuilder().build();
            responseBuilder.setCancelPrepareResponse(omResponse);
            response = new OMCancelPrepareResponse(responseBuilder.build());
            ozoneManager.getPrepareState().cancelPrepare();
            LOG.info("OM {} prepare state cancelled at log index {}. Returning response {}", new Object[]{ozoneManager.getOMNodeId(), transactionLogIndex, omResponse});
        }
        catch (IOException e) {
            LOG.error("Cancel Prepare Request apply failed in {}. ", (Object)ozoneManager.getOMNodeId(), (Object)e);
            response = new OMPrepareResponse(this.createErrorOMResponse(responseBuilder, e));
        }
        return response;
    }
}

