/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OMAllocateBlockResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"openFileTable", "bucketTable"})
public class OMAllocateBlockResponseWithFSO
extends OMAllocateBlockResponse {
    private long volumeId;
    private long bucketId;

    public OMAllocateBlockResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmKeyInfo omKeyInfo, long clientID, @Nonnull BucketLayout bucketLayout, @Nonnull long volumeId, @Nonnull long bucketId) {
        super(omResponse, omKeyInfo, clientID, bucketLayout);
        this.volumeId = volumeId;
        this.bucketId = bucketId;
    }

    public OMAllocateBlockResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        OMFileRequest.addToOpenFileTable(omMetadataManager, batchOperation, this.getOmKeyInfo(), this.getClientID(), this.volumeId, this.bucketId);
    }
}

