/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OMKeyCommitResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"openFileTable", "fileTable", "deletedTable", "bucketTable"})
public class OMKeyCommitResponseWithFSO
extends OMKeyCommitResponse {
    private long volumeId;

    public OMKeyCommitResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmKeyInfo omKeyInfo, String ozoneKeyName, String openKeyName, @Nonnull OmBucketInfo omBucketInfo, Map<String, RepeatedOmKeyInfo> deleteKeyMap, long volumeId, boolean isHSync) {
        super(omResponse, omKeyInfo, ozoneKeyName, openKeyName, omBucketInfo, deleteKeyMap, isHSync);
        this.volumeId = volumeId;
    }

    public OMKeyCommitResponseWithFSO(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (!this.isHSync()) {
            omMetadataManager.getOpenKeyTable(this.getBucketLayout()).deleteWithBatch(batchOperation, (Object)this.getOpenKeyName());
        }
        OMFileRequest.addToFileTable(omMetadataManager, batchOperation, this.getOmKeyInfo(), this.volumeId, this.getOmBucketInfo().getObjectID());
        this.updateDeletedTable(omMetadataManager, batchOperation);
        omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(this.getOmBucketInfo().getVolumeName(), this.getOmBucketInfo().getBucketName()), (Object)this.getOmBucketInfo());
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }
}

