/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartAbortInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.s3.multipart.AbstractS3MultipartAbortResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"openKeyTable", "openFileTable", "deletedTable", "multipartInfoTable", "bucketTable"})
public class S3ExpiredMultipartUploadsAbortResponse
extends AbstractS3MultipartAbortResponse {
    private Map<OmBucketInfo, List<OmMultipartAbortInfo>> mpusToDelete;

    public S3ExpiredMultipartUploadsAbortResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull Map<OmBucketInfo, List<OmMultipartAbortInfo>> mpusToDelete, boolean isRatisEnabled) {
        super(omResponse, isRatisEnabled);
        this.mpusToDelete = mpusToDelete;
    }

    public S3ExpiredMultipartUploadsAbortResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse, BucketLayout.DEFAULT);
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        for (Map.Entry<OmBucketInfo, List<OmMultipartAbortInfo>> mpuInfoPair : this.mpusToDelete.entrySet()) {
            this.addAbortToBatch(omMetadataManager, batchOperation, mpuInfoPair.getKey(), mpuInfoPair.getValue());
        }
    }
}

