/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.security;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.S3SecretManager;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"s3SecretTable"})
public class S3RevokeSecretResponse
extends OMClientResponse {
    private final String kerberosID;
    private final S3SecretManager s3SecretManager;

    public S3RevokeSecretResponse(@Nullable String kerberosID, @Nonnull S3SecretManager s3SecretManager, @Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.kerberosID = kerberosID;
        this.s3SecretManager = s3SecretManager;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.kerberosID != null && this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            if (this.s3SecretManager.isBatchSupported()) {
                this.s3SecretManager.batcher().deleteWithBatch((AutoCloseable)batchOperation, this.kerberosID);
            } else {
                this.s3SecretManager.revokeSecret(this.kerberosID);
            }
        }
    }
}

