/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.common.DeleteBlockGroupResult;
import org.apache.hadoop.ozone.lock.BootstrapStateHandler;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.helpers.OMRatisHelper;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.service.SnapshotDeletingService;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.Preconditions;

public abstract class AbstractKeyDeletingService
extends BackgroundService
implements BootstrapStateHandler {
    private final OzoneManager ozoneManager;
    private final ScmBlockLocationProtocol scmClient;
    private final ClientId clientId = ClientId.randomId();
    private final AtomicLong deletedDirsCount;
    private final AtomicLong movedDirsCount;
    private final AtomicLong movedFilesCount;
    private final AtomicLong runCount;
    private final BootstrapStateHandler.Lock lock = new BootstrapStateHandler.Lock();

    public AbstractKeyDeletingService(String serviceName, long interval, TimeUnit unit, int threadPoolSize, long serviceTimeout, OzoneManager ozoneManager, ScmBlockLocationProtocol scmClient) {
        super(serviceName, interval, unit, threadPoolSize, serviceTimeout, ozoneManager.getThreadNamePrefix());
        this.ozoneManager = ozoneManager;
        this.scmClient = scmClient;
        this.deletedDirsCount = new AtomicLong(0L);
        this.movedDirsCount = new AtomicLong(0L);
        this.movedFilesCount = new AtomicLong(0L);
        this.runCount = new AtomicLong(0L);
    }

    protected int processKeyDeletes(List<BlockGroup> keyBlocksList, KeyManager manager, HashMap<String, RepeatedOmKeyInfo> keysToModify, String snapTableKey) throws IOException {
        long startTime = Time.monotonicNow();
        int delCount = 0;
        if (BackgroundService.LOG.isDebugEnabled()) {
            BackgroundService.LOG.debug("Send {} key(s) to SCM: {}", (Object)keyBlocksList.size(), keyBlocksList);
        } else if (BackgroundService.LOG.isInfoEnabled()) {
            int logSize = 10;
            if (keyBlocksList.size() < logSize) {
                logSize = keyBlocksList.size();
            }
            BackgroundService.LOG.info("Send {} key(s) to SCM, first {} keys: {}", new Object[]{keyBlocksList.size(), logSize, keyBlocksList.subList(0, logSize)});
        }
        List blockDeletionResults = this.scmClient.deleteKeyBlocks(keyBlocksList);
        BackgroundService.LOG.info("{} BlockGroup deletion are acked by SCM in {} ms", (Object)keyBlocksList.size(), (Object)(Time.monotonicNow() - startTime));
        if (blockDeletionResults != null) {
            startTime = Time.monotonicNow();
            delCount = this.isRatisEnabled() ? this.submitPurgeKeysRequest(blockDeletionResults, keysToModify, snapTableKey) : this.deleteAllKeys(blockDeletionResults, manager);
            BackgroundService.LOG.info("Blocks for {} (out of {}) keys are deleted from DB in {} ms", new Object[]{delCount, blockDeletionResults.size(), Time.monotonicNow() - startTime});
        }
        return delCount;
    }

    private int deleteAllKeys(List<DeleteBlockGroupResult> results, KeyManager manager) throws IOException {
        Table deletedTable = manager.getMetadataManager().getDeletedTable();
        DBStore store = manager.getMetadataManager().getStore();
        int deletedCount = 0;
        Throwable throwable = null;
        Object var7_8 = null;
        try (BatchOperation writeBatch = store.initBatchOperation();){
            for (DeleteBlockGroupResult result : results) {
                if (!result.isSuccess()) continue;
                deletedTable.deleteWithBatch(writeBatch, (Object)result.getObjectKey());
                if (BackgroundService.LOG.isDebugEnabled()) {
                    BackgroundService.LOG.debug("Key {} deleted from OM DB", (Object)result.getObjectKey());
                }
                ++deletedCount;
            }
            store.commitBatchOperation(writeBatch);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return deletedCount;
    }

    private int submitPurgeKeysRequest(List<DeleteBlockGroupResult> results, HashMap<String, RepeatedOmKeyInfo> keysToModify, String snapTableKey) {
        HashMap<Pair<String, String>, List<String>> purgeKeysMapPerBucket = new HashMap<Pair<String, String>, List<String>>();
        int deletedCount = 0;
        for (DeleteBlockGroupResult result : results) {
            if (!result.isSuccess()) continue;
            String string = result.getObjectKey();
            if (keysToModify != null && !keysToModify.containsKey(string)) {
                this.addToMap(purgeKeysMapPerBucket, string);
                if (BackgroundService.LOG.isDebugEnabled()) {
                    BackgroundService.LOG.debug("Key {} set to be updated in OM DB, Other versions of the key that are reclaimable are reclaimed.", (Object)string);
                }
            } else if (keysToModify == null) {
                this.addToMap(purgeKeysMapPerBucket, string);
                if (BackgroundService.LOG.isDebugEnabled()) {
                    BackgroundService.LOG.debug("Key {} set to be purged from OM DB", (Object)string);
                }
            }
            ++deletedCount;
        }
        OzoneManagerProtocolProtos.PurgeKeysRequest.Builder purgeKeysRequest = OzoneManagerProtocolProtos.PurgeKeysRequest.newBuilder();
        if (snapTableKey != null) {
            purgeKeysRequest.setSnapshotTableKey(snapTableKey);
        }
        for (Map.Entry entry : purgeKeysMapPerBucket.entrySet()) {
            Pair volumeBucketPair = (Pair)entry.getKey();
            OzoneManagerProtocolProtos.DeletedKeys deletedKeysInBucket = OzoneManagerProtocolProtos.DeletedKeys.newBuilder().setVolumeName((String)volumeBucketPair.getLeft()).setBucketName((String)volumeBucketPair.getRight()).addAllKeys((Iterable)entry.getValue()).build();
            purgeKeysRequest.addDeletedKeys(deletedKeysInBucket);
        }
        ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> arrayList = new ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos>();
        if (keysToModify != null) {
            for (Map.Entry entry : keysToModify.entrySet()) {
                OzoneManagerProtocolProtos.SnapshotMoveKeyInfos.Builder keyToUpdate = OzoneManagerProtocolProtos.SnapshotMoveKeyInfos.newBuilder();
                keyToUpdate.setKey((String)entry.getKey());
                List keyInfos = ((RepeatedOmKeyInfo)entry.getValue()).getOmKeyInfoList().stream().map(k -> k.getProtobuf(ClientVersion.CURRENT_VERSION)).collect(Collectors.toList());
                keyToUpdate.addAllKeyInfos(keyInfos);
                arrayList.add(keyToUpdate.build());
            }
            if (arrayList.size() > 0) {
                purgeKeysRequest.addAllKeysToUpdate(arrayList);
            }
        }
        OzoneManagerProtocolProtos.OMRequest oMRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.PurgeKeys).setPurgeKeysRequest(purgeKeysRequest).setClientId(this.clientId.toString()).build();
        try {
            RaftClientRequest raftClientRequest = this.createRaftClientRequestForPurge(oMRequest);
            this.ozoneManager.getOmRatisServer().submitRequest(oMRequest, raftClientRequest);
        }
        catch (ServiceException e) {
            BackgroundService.LOG.error("PurgeKey request failed. Will retry at next run.", (Throwable)e);
            return 0;
        }
        return deletedCount;
    }

    protected RaftClientRequest createRaftClientRequestForPurge(OzoneManagerProtocolProtos.OMRequest omRequest) {
        return RaftClientRequest.newBuilder().setClientId(this.clientId).setServerId(this.ozoneManager.getOmRatisServer().getRaftPeerId()).setGroupId(this.ozoneManager.getOmRatisServer().getRaftGroupId()).setCallId(this.runCount.get()).setMessage(Message.valueOf((ByteString)OMRatisHelper.convertRequestToByteString((OzoneManagerProtocolProtos.OMRequest)omRequest))).setType(RaftClientRequest.writeRequestType()).build();
    }

    private void addToMap(Map<Pair<String, String>, List<String>> map, String objectKey) {
        Pair volumeBucketPair;
        String[] split = objectKey.split("/");
        Preconditions.assertTrue((split.length >= 3 ? 1 : 0) != 0, (Object)("Volume and/or Bucket Name missing from Key Name " + objectKey));
        if (split.length == 3) {
            BackgroundService.LOG.warn("{} missing Key Name", (Object)objectKey);
        }
        if (!map.containsKey(volumeBucketPair = Pair.of((Object)split[1], (Object)split[2]))) {
            map.put((Pair<String, String>)volumeBucketPair, new ArrayList());
        }
        map.get(volumeBucketPair).add(objectKey);
    }

    protected void submitPurgePaths(List<OzoneManagerProtocolProtos.PurgePathRequest> requests, String snapTableKey) {
        OzoneManagerProtocolProtos.PurgeDirectoriesRequest.Builder purgeDirRequest = OzoneManagerProtocolProtos.PurgeDirectoriesRequest.newBuilder();
        if (snapTableKey != null) {
            purgeDirRequest.setSnapshotTableKey(snapTableKey);
        }
        purgeDirRequest.addAllDeletedPath(requests);
        OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.PurgeDirectories).setPurgeDirectoriesRequest(purgeDirRequest).setClientId(this.clientId.toString()).build();
        try {
            if (this.isRatisEnabled()) {
                RaftClientRequest raftClientRequest = this.createRaftClientRequestForPurge(omRequest);
                this.ozoneManager.getOmRatisServer().submitRequest(omRequest, raftClientRequest);
            } else {
                this.getOzoneManager().getOmServerProtocol().submitRequest(null, omRequest);
            }
        }
        catch (ServiceException e) {
            BackgroundService.LOG.error("PurgePaths request failed. Will retry at next run.", (Throwable)e);
        }
    }

    private OzoneManagerProtocolProtos.PurgePathRequest wrapPurgeRequest(long volumeId, long bucketId, String purgeDeletedDir, List<OmKeyInfo> purgeDeletedFiles, List<OmKeyInfo> markDirsAsDeleted) {
        OzoneManagerProtocolProtos.PurgePathRequest.Builder purgePathsRequest = OzoneManagerProtocolProtos.PurgePathRequest.newBuilder();
        purgePathsRequest.setVolumeId(volumeId);
        purgePathsRequest.setBucketId(bucketId);
        if (purgeDeletedDir != null) {
            purgePathsRequest.setDeletedDir(purgeDeletedDir);
        }
        for (OmKeyInfo purgeFile : purgeDeletedFiles) {
            purgePathsRequest.addDeletedSubFiles(purgeFile.getProtobuf(true, ClientVersion.CURRENT_VERSION));
        }
        for (OmKeyInfo dir : markDirsAsDeleted) {
            purgePathsRequest.addMarkDeletedSubDirs(dir.getProtobuf(ClientVersion.CURRENT_VERSION));
        }
        return purgePathsRequest.build();
    }

    protected OzoneManagerProtocolProtos.PurgePathRequest prepareDeleteDirRequest(long remainNum, OmKeyInfo pendingDeletedDirInfo, String delDirName, List<Pair<String, OmKeyInfo>> subDirList, KeyManager keyManager) throws IOException {
        if (BackgroundService.LOG.isDebugEnabled()) {
            BackgroundService.LOG.debug("Pending deleted dir name: {}", (Object)pendingDeletedDirInfo.getKeyName());
        }
        String[] keys = delDirName.split("/");
        long volumeId = Long.parseLong(keys[1]);
        long bucketId = Long.parseLong(keys[2]);
        List<OmKeyInfo> subDirs = keyManager.getPendingDeletionSubDirs(volumeId, bucketId, pendingDeletedDirInfo, remainNum);
        remainNum -= (long)subDirs.size();
        OMMetadataManager omMetadataManager = keyManager.getMetadataManager();
        for (OmKeyInfo dirInfo : subDirs) {
            String ozoneDbKey = omMetadataManager.getOzonePathKey(volumeId, bucketId, dirInfo.getParentObjectID(), dirInfo.getFileName());
            String ozoneDeleteKey = omMetadataManager.getOzoneDeletePathKey(dirInfo.getObjectID(), ozoneDbKey);
            subDirList.add((Pair<String, OmKeyInfo>)Pair.of((Object)ozoneDeleteKey, (Object)dirInfo));
            BackgroundService.LOG.debug("Moved sub dir name: {}", (Object)dirInfo.getKeyName());
        }
        List<OmKeyInfo> subFiles = keyManager.getPendingDeletionSubFiles(volumeId, bucketId, pendingDeletedDirInfo, remainNum);
        remainNum -= (long)subFiles.size();
        if (BackgroundService.LOG.isDebugEnabled()) {
            for (OmKeyInfo fileInfo : subFiles) {
                BackgroundService.LOG.debug("Moved sub file name: {}", (Object)fileInfo.getKeyName());
            }
        }
        String purgeDeletedDir = remainNum > 0L ? delDirName : null;
        return this.wrapPurgeRequest(volumeId, bucketId, purgeDeletedDir, subFiles, subDirs);
    }

    public long optimizeDirDeletesAndSubmitRequest(long remainNum, long dirNum, long subDirNum, long subFileNum, List<Pair<String, OmKeyInfo>> allSubDirList, List<OzoneManagerProtocolProtos.PurgePathRequest> purgePathRequestList, String snapTableKey, long startTime, int remainingBufLimit, KeyManager keyManager) {
        int subdirDelNum = 0;
        int consumedSize = 0;
        for (int subDirRecursiveCnt = 0; remainNum > 0L && subDirRecursiveCnt < allSubDirList.size(); ++subDirRecursiveCnt) {
            try {
                Pair<String, OmKeyInfo> stringOmKeyInfoPair = allSubDirList.get(subDirRecursiveCnt);
                OzoneManagerProtocolProtos.PurgePathRequest request = this.prepareDeleteDirRequest(remainNum, (OmKeyInfo)stringOmKeyInfoPair.getValue(), (String)stringOmKeyInfoPair.getKey(), allSubDirList, keyManager);
                if (this.isBufferLimitCrossed(remainingBufLimit, consumedSize, request.getSerializedSize())) break;
                consumedSize += request.getSerializedSize();
                purgePathRequestList.add(request);
                --remainNum;
                remainNum -= (long)request.getDeletedSubFilesCount();
                remainNum -= (long)request.getMarkDeletedSubDirsCount();
                if (request.getDeletedDir() != null && !request.getDeletedDir().isEmpty()) {
                    ++subdirDelNum;
                }
                subDirNum += (long)request.getMarkDeletedSubDirsCount();
                subFileNum += (long)request.getDeletedSubFilesCount();
                continue;
            }
            catch (IOException e) {
                BackgroundService.LOG.error("Error while running delete directories and files background task. Will retry at next run for subset.", (Throwable)e);
                break;
            }
        }
        if (!purgePathRequestList.isEmpty()) {
            this.submitPurgePaths(purgePathRequestList, snapTableKey);
        }
        if (dirNum != 0L || subDirNum != 0L || subFileNum != 0L) {
            this.deletedDirsCount.addAndGet(dirNum + (long)subdirDelNum);
            this.movedDirsCount.addAndGet(subDirNum - (long)subdirDelNum);
            this.movedFilesCount.addAndGet(subFileNum);
            BackgroundService.LOG.info("Number of dirs deleted: {}, Number of sub-dir deleted: {}, Number of sub-files moved: {} to DeletedTable, Number of sub-dirs moved {} to DeletedDirectoryTable, iteration elapsed: {}ms, totalRunCount: {}", new Object[]{dirNum, subdirDelNum, subFileNum, subDirNum - (long)subdirDelNum, Time.monotonicNow() - startTime, this.getRunCount()});
        }
        return remainNum;
    }

    public void calculateExclusiveSize(SnapshotInfo previousSnapshot, SnapshotInfo previousToPrevSnapshot, OmKeyInfo keyInfo, OmBucketInfo bucketInfo, long volumeId, Table<String, String> snapRenamedTable, Table<String, OmKeyInfo> previousKeyTable, Table<String, String> prevRenamedTable, Table<String, OmKeyInfo> previousToPrevKeyTable, Map<String, Long> exclusiveSizeMap, Map<String, Long> exclusiveReplicatedSizeMap) throws IOException {
        String prevSnapKey = previousSnapshot.getTableKey();
        long exclusiveReplicatedSize = exclusiveReplicatedSizeMap.getOrDefault(prevSnapKey, 0L) + keyInfo.getReplicatedSize();
        long exclusiveSize = exclusiveSizeMap.getOrDefault(prevSnapKey, 0L) + keyInfo.getDataSize();
        if (previousToPrevSnapshot == null) {
            exclusiveSizeMap.put(prevSnapKey, exclusiveSize);
            exclusiveReplicatedSizeMap.put(prevSnapKey, exclusiveReplicatedSize);
        } else {
            OmKeyInfo keyInfoPrevSnapshot = this.getPreviousSnapshotKeyName(keyInfo, bucketInfo, volumeId, snapRenamedTable, previousKeyTable);
            OmKeyInfo keyInfoPrevToPrevSnapshot = this.getPreviousSnapshotKeyName(keyInfoPrevSnapshot, bucketInfo, volumeId, prevRenamedTable, previousToPrevKeyTable);
            if (keyInfoPrevToPrevSnapshot == null) {
                exclusiveSizeMap.put(prevSnapKey, exclusiveSize);
                exclusiveReplicatedSizeMap.put(prevSnapKey, exclusiveReplicatedSize);
            }
        }
    }

    private OmKeyInfo getPreviousSnapshotKeyName(OmKeyInfo keyInfo, OmBucketInfo bucketInfo, long volumeId, Table<String, String> snapRenamedTable, Table<String, OmKeyInfo> previousKeyTable) throws IOException {
        OmKeyInfo prevKeyInfo;
        if (keyInfo == null) {
            return null;
        }
        String dbKeyPrevSnap = bucketInfo.getBucketLayout().isFileSystemOptimized() ? this.getOzoneManager().getMetadataManager().getOzonePathKey(volumeId, bucketInfo.getObjectID(), keyInfo.getParentObjectID(), keyInfo.getFileName()) : this.getOzoneManager().getMetadataManager().getOzoneKey(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyInfo.getKeyName());
        String dbRenameKey = this.getOzoneManager().getMetadataManager().getRenameKey(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyInfo.getObjectID());
        String renamedKey = (String)snapRenamedTable.getIfExist((Object)dbRenameKey);
        OmKeyInfo omKeyInfo = prevKeyInfo = renamedKey != null ? (OmKeyInfo)previousKeyTable.get((Object)renamedKey) : (OmKeyInfo)previousKeyTable.get((Object)dbKeyPrevSnap);
        if (prevKeyInfo == null || prevKeyInfo.getObjectID() != keyInfo.getObjectID()) {
            return null;
        }
        return SnapshotDeletingService.isBlockLocationInfoSame(prevKeyInfo, keyInfo) ? prevKeyInfo : null;
    }

    protected boolean isBufferLimitCrossed(int maxLimit, int cLimit, int increment) {
        return cLimit + increment >= maxLimit;
    }

    protected SnapshotInfo getPreviousActiveSnapshot(SnapshotInfo snapInfo, SnapshotChainManager chainManager) throws IOException {
        SnapshotInfo currSnapInfo = snapInfo;
        while (chainManager.hasPreviousPathSnapshot(currSnapInfo.getSnapshotPath(), currSnapInfo.getSnapshotId())) {
            UUID prevPathSnapshot = chainManager.previousPathSnapshot(currSnapInfo.getSnapshotPath(), currSnapInfo.getSnapshotId());
            String tableKey = chainManager.getTableKey(prevPathSnapshot);
            SnapshotInfo prevSnapInfo = SnapshotUtils.getSnapshotInfo(this.ozoneManager, tableKey);
            if (prevSnapInfo.getSnapshotStatus() == SnapshotInfo.SnapshotStatus.SNAPSHOT_ACTIVE) {
                return prevSnapInfo;
            }
            currSnapInfo = prevSnapInfo;
        }
        return null;
    }

    protected boolean isKeyReclaimable(Table<String, OmKeyInfo> previousKeyTable, Table<String, String> renamedTable, OmKeyInfo deletedKeyInfo, OmBucketInfo bucketInfo, long volumeId, HddsProtos.KeyValue.Builder renamedKeyBuilder) throws IOException {
        OmKeyInfo prevKeyInfo;
        if (previousKeyTable == null) {
            return true;
        }
        if (deletedKeyInfo.getObjectID() == 0L) {
            return true;
        }
        String dbKey = bucketInfo.getBucketLayout().isFileSystemOptimized() ? this.ozoneManager.getMetadataManager().getOzonePathKey(volumeId, bucketInfo.getObjectID(), deletedKeyInfo.getParentObjectID(), deletedKeyInfo.getFileName()) : this.ozoneManager.getMetadataManager().getOzoneKey(deletedKeyInfo.getVolumeName(), deletedKeyInfo.getBucketName(), deletedKeyInfo.getKeyName());
        String dbRenameKey = this.ozoneManager.getMetadataManager().getRenameKey(deletedKeyInfo.getVolumeName(), deletedKeyInfo.getBucketName(), deletedKeyInfo.getObjectID());
        String renamedKey = (String)renamedTable.getIfExist((Object)dbRenameKey);
        if (renamedKey != null && renamedKeyBuilder != null) {
            renamedKeyBuilder.setKey(dbRenameKey).setValue(renamedKey);
        }
        OmKeyInfo omKeyInfo = prevKeyInfo = renamedKey != null ? (OmKeyInfo)previousKeyTable.get((Object)renamedKey) : (OmKeyInfo)previousKeyTable.get((Object)dbKey);
        if (prevKeyInfo == null || prevKeyInfo.getObjectID() != deletedKeyInfo.getObjectID()) {
            return true;
        }
        return !SnapshotDeletingService.isBlockLocationInfoSame(prevKeyInfo, deletedKeyInfo);
    }

    public boolean isRatisEnabled() {
        if (this.ozoneManager == null) {
            return false;
        }
        return this.ozoneManager.isRatisEnabled();
    }

    public OzoneManager getOzoneManager() {
        return this.ozoneManager;
    }

    public ScmBlockLocationProtocol getScmClient() {
        return this.scmClient;
    }

    @VisibleForTesting
    public AtomicLong getRunCount() {
        return this.runCount;
    }

    @VisibleForTesting
    public long getDeletedDirsCount() {
        return this.deletedDirsCount.get();
    }

    @VisibleForTesting
    public long getMovedDirsCount() {
        return this.movedDirsCount.get();
    }

    @VisibleForTesting
    public long getMovedFilesCount() {
        return this.movedFilesCount.get();
    }

    public BootstrapStateHandler.Lock getBootstrapStateLock() {
        return this.lock;
    }
}

