/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.db.CodecRegistry;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksIterator;
import org.apache.hadoop.hdds.utils.db.managed.ManagedWriteBatch;
import org.apache.hadoop.hdds.utils.db.managed.ManagedWriteOptions;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.SnapshotDiffJob;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffResponse;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class SnapshotDiffCleanupService
extends BackgroundService {
    private static final int SNAPSHOT_DIFF_CLEANUP_CORE_POOL_SIZE = 1;
    private final AtomicBoolean suspended = new AtomicBoolean(false);
    private final AtomicLong runCount = new AtomicLong(0L);
    private final AtomicLong successRunCount = new AtomicLong(0L);
    private final OzoneManager ozoneManager;
    private final ManagedRocksDB db;
    private final ColumnFamilyHandle snapDiffJobCfh;
    private final ColumnFamilyHandle snapDiffPurgedJobCfh;
    private final ColumnFamilyHandle snapDiffReportCfh;
    private final CodecRegistry codecRegistry;
    private final long maxJobToPurgePerTask;
    private final long maxAllowedTime;

    public SnapshotDiffCleanupService(long interval, long serviceTimeout, OzoneManager ozoneManager, ManagedRocksDB db, ColumnFamilyHandle snapDiffJobCfh, ColumnFamilyHandle snapDiffPurgedJobCfh, ColumnFamilyHandle snapDiffReportCfh, CodecRegistry codecRegistry) {
        super(SnapshotDiffCleanupService.class.getSimpleName(), interval, TimeUnit.MILLISECONDS, 1, serviceTimeout, ozoneManager.getThreadNamePrefix());
        this.ozoneManager = ozoneManager;
        this.db = db;
        this.snapDiffJobCfh = snapDiffJobCfh;
        this.snapDiffPurgedJobCfh = snapDiffPurgedJobCfh;
        this.snapDiffReportCfh = snapDiffReportCfh;
        this.codecRegistry = codecRegistry;
        this.maxJobToPurgePerTask = ozoneManager.getConfiguration().getLong("ozone.om.snapshot.diff.max.jobs.purge.per.task", 100L);
        this.maxAllowedTime = ozoneManager.getConfiguration().getTimeDuration("ozone.om.snapshot.diff.job.report.persistent.time", OMConfigKeys.OZONE_OM_SNAPSHOT_DIFF_JOB_REPORT_PERSISTENT_TIME_DEFAULT, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    public void run() {
        this.removeOlderJobReport();
        this.moveOldSnapDiffJobsToPurgeTable();
    }

    @VisibleForTesting
    public byte[] getEntryFromPurgedJobTable(String jobId) {
        try {
            return ((RocksDB)this.db.get()).get(this.snapDiffPurgedJobCfh, this.codecRegistry.asRawData((Object)jobId));
        }
        catch (IOException | RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void moveOldSnapDiffJobsToPurgeTable() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                ManagedRocksIterator iterator = new ManagedRocksIterator(((RocksDB)this.db.get()).newIterator(this.snapDiffJobCfh));
                try {
                    block22: {
                        ManagedWriteBatch writeBatch = new ManagedWriteBatch();
                        try {
                            try (ManagedWriteOptions writeOptions = new ManagedWriteOptions();){
                                long currentTimeMillis = System.currentTimeMillis();
                                long purgeJobCount = 0L;
                                ((RocksIterator)iterator.get()).seekToFirst();
                                while (true) {
                                    if (!((RocksIterator)iterator.get()).isValid() || purgeJobCount >= this.maxJobToPurgePerTask) {
                                        ((RocksDB)this.db.get()).write((WriteOptions)writeOptions, (WriteBatch)writeBatch);
                                        break;
                                    }
                                    byte[] keyBytes = ((RocksIterator)iterator.get()).key();
                                    byte[] snapInfoBytes = ((RocksIterator)iterator.get()).value();
                                    ((RocksIterator)iterator.get()).next();
                                    SnapshotDiffJob snapDiffJob = (SnapshotDiffJob)this.codecRegistry.asObject(snapInfoBytes, SnapshotDiffJob.class);
                                    if (currentTimeMillis - snapDiffJob.getCreationTime() <= this.maxAllowedTime && snapDiffJob.getStatus() != SnapshotDiffResponse.JobStatus.FAILED && snapDiffJob.getStatus() != SnapshotDiffResponse.JobStatus.REJECTED && snapDiffJob.getStatus() != SnapshotDiffResponse.JobStatus.CANCELLED) continue;
                                    writeBatch.put(this.snapDiffPurgedJobCfh, this.codecRegistry.asRawData((Object)snapDiffJob.getJobId()), this.codecRegistry.asRawData((Object)snapDiffJob.getTotalDiffEntries()));
                                    writeBatch.delete(this.snapDiffJobCfh, keyBytes);
                                    ++purgeJobCount;
                                }
                            }
                            if (writeBatch == null) break block22;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (writeBatch == null) throw throwable;
                            writeBatch.close();
                            throw throwable;
                        }
                        writeBatch.close();
                    }
                    if (iterator == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (iterator == null) throw throwable;
                    iterator.close();
                    throw throwable;
                }
                iterator.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException | RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeOlderJobReport() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                ManagedRocksIterator rocksIterator = new ManagedRocksIterator(((RocksDB)this.db.get()).newIterator(this.snapDiffPurgedJobCfh));
                try {
                    block23: {
                        ManagedWriteBatch writeBatch = new ManagedWriteBatch();
                        try {
                            try (ManagedWriteOptions writeOptions = new ManagedWriteOptions();){
                                ((RocksIterator)rocksIterator.get()).seekToFirst();
                                while (true) {
                                    if (!((RocksIterator)rocksIterator.get()).isValid()) {
                                        ((RocksDB)this.db.get()).write((WriteOptions)writeOptions, (WriteBatch)writeBatch);
                                        break;
                                    }
                                    byte[] key = ((RocksIterator)rocksIterator.get()).key();
                                    byte[] value = ((RocksIterator)rocksIterator.get()).value();
                                    ((RocksIterator)rocksIterator.get()).next();
                                    String prefix = (String)this.codecRegistry.asObject(key, String.class);
                                    long totalNumberOfEntries = (Long)this.codecRegistry.asObject(value, Long.class);
                                    if (totalNumberOfEntries > 0L) {
                                        byte[] beginKey = this.codecRegistry.asRawData((Object)(String.valueOf(prefix) + "-" + 0));
                                        byte[] endKey = this.codecRegistry.asRawData((Object)(String.valueOf(prefix) + "-" + (totalNumberOfEntries - 1L)));
                                        writeBatch.deleteRange(this.snapDiffReportCfh, beginKey, endKey);
                                        writeBatch.delete(this.snapDiffReportCfh, endKey);
                                    }
                                    writeBatch.delete(this.snapDiffPurgedJobCfh, key);
                                }
                            }
                            if (writeBatch == null) break block23;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (writeBatch == null) throw throwable;
                            writeBatch.close();
                            throw throwable;
                        }
                        writeBatch.close();
                    }
                    if (rocksIterator == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (rocksIterator == null) throw throwable;
                    rocksIterator.close();
                    throw throwable;
                }
                rocksIterator.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException | RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new SnapshotDiffCleanUpTask());
        return queue;
    }

    private boolean shouldRun() {
        return !this.suspended.get();
    }

    public long getRunCount() {
        return this.runCount.get();
    }

    public long getSuccessfulRunCount() {
        return this.successRunCount.get();
    }

    @VisibleForTesting
    void suspend() {
        this.suspended.set(true);
    }

    @VisibleForTesting
    void resume() {
        this.suspended.set(false);
    }

    private class SnapshotDiffCleanUpTask
    implements BackgroundTask {
        private SnapshotDiffCleanUpTask() {
        }

        public BackgroundTaskResult call() {
            if (!SnapshotDiffCleanupService.this.shouldRun()) {
                return BackgroundTaskResult.EmptyTaskResult.newResult();
            }
            SnapshotDiffCleanupService.this.runCount.incrementAndGet();
            SnapshotDiffCleanupService.this.run();
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }
    }
}

