/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.upgrade;

import java.util.EnumMap;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.ozone.om.upgrade.OmUpgradeAction;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;

public enum OMLayoutFeature implements LayoutFeature
{
    INITIAL_VERSION(0, "Initial Layout Version"),
    ERASURE_CODED_STORAGE_SUPPORT(1, "Ozone version with built in support for Erasure Coded block data storage."),
    BUCKET_LAYOUT_SUPPORT(2, "Ozone version supporting bucket layouts and introducing the FILE_SYSTEM_OPTIMIZED and OBJECT_STORE bucket layout types."),
    MULTITENANCY_SCHEMA(3, "Multi-Tenancy Schema"),
    HSYNC(4, "Support hsync"),
    FILESYSTEM_SNAPSHOT(5, "Ozone version supporting snapshot"),
    QUOTA(6, "Ozone quota re-calculate");

    private int layoutVersion;
    private String description;
    private EnumMap<LayoutFeature.UpgradeActionType, OmUpgradeAction> actions = new EnumMap(LayoutFeature.UpgradeActionType.class);

    private OMLayoutFeature(int layoutVersion, String description) {
        this.layoutVersion = layoutVersion;
        this.description = description;
    }

    private OMLayoutFeature(int layoutVersion, String description, Pair<LayoutFeature.UpgradeActionType, OmUpgradeAction> ... actions) {
        this.layoutVersion = layoutVersion;
        this.description = description;
        Pair<LayoutFeature.UpgradeActionType, OmUpgradeAction>[] pairArray = actions;
        int n2 = actions.length;
        int n3 = 0;
        while (n3 < n2) {
            Pair<LayoutFeature.UpgradeActionType, OmUpgradeAction> action = pairArray[n3];
            this.actions.put((LayoutFeature.UpgradeActionType)action.getKey(), (OmUpgradeAction)action.getValue());
            ++n3;
        }
    }

    public int layoutVersion() {
        return this.layoutVersion;
    }

    public String description() {
        return this.description;
    }

    public void addAction(LayoutFeature.UpgradeActionType type, OmUpgradeAction action) {
        this.actions.put(type, action);
    }

    public Optional<OmUpgradeAction> action(LayoutFeature.UpgradeActionType phase) {
        return Optional.ofNullable(this.actions.get(phase));
    }
}

