/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.helpers;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.ozone.container.common.impl.BlockDeletingService;

@Metrics(name="BlockDeletingService Metrics", about="Metrics related to background block deleting service on Datanode", context="dfs")
public final class BlockDeletingServiceMetrics {
    private static BlockDeletingServiceMetrics instance;
    public static final String SOURCE_NAME;
    @Metric(about="The number of successful delete blocks")
    private MutableCounterLong successCount;
    @Metric(about="The total bytes for blocks successfully deleted.")
    private MutableCounterLong successBytes;
    @Metric(about="The number of failed delete blocks.")
    private MutableCounterLong failureCount;
    @Metric(about="The number of out of order delete block transaction.")
    private MutableCounterLong outOfOrderDeleteBlockTransactionCount;
    @Metric(about="The total number of blocks pending for processing.")
    private MutableGaugeLong totalPendingBlockCount;
    @Metric(about="The total number of DeleteBlockTransaction received")
    private MutableCounterLong receivedTransactionCount;
    @Metric(about="The total number of DeleteBlockTransaction that is a retry Transaction")
    private MutableCounterLong receivedRetryTransactionCount;
    @Metric(about="The total number of Container received to be processed")
    private MutableCounterLong receivedContainerCount;
    @Metric(about="The total number of blocks received to be processed.")
    private MutableGaugeLong receivedBlockCount;
    @Metric(about="The total number of blocks marked count.")
    private MutableGaugeLong markedBlockCount;
    @Metric(about="The total number of blocks chosen to be deleted.")
    private MutableGaugeLong totalBlockChosenCount;
    @Metric(about="The total number of Container chosen to be deleted.")
    private MutableGaugeLong totalContainerChosenCount;
    @Metric(about="The total number of transactions which failed due to container lock wait timeout.")
    private MutableGaugeLong totalLockTimeoutTransactionCount;

    private BlockDeletingServiceMetrics() {
    }

    public static BlockDeletingServiceMetrics create() {
        if (instance == null) {
            MetricsSystem ms = DefaultMetricsSystem.instance();
            instance = (BlockDeletingServiceMetrics)ms.register(SOURCE_NAME, "BlockDeletingService", (Object)new BlockDeletingServiceMetrics());
        }
        return instance;
    }

    public static void unRegister() {
        instance = null;
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    public void incrSuccessCount(long count) {
        this.successCount.incr(count);
    }

    public void incrSuccessBytes(long bytes) {
        this.successBytes.incr(bytes);
    }

    public void incrFailureCount() {
        this.failureCount.incr();
    }

    public void incrReceivedTransactionCount(long count) {
        this.receivedTransactionCount.incr(count);
    }

    public void incrReceivedRetryTransactionCount(long count) {
        this.receivedRetryTransactionCount.incr(count);
    }

    public void incrReceivedContainerCount(long count) {
        this.receivedContainerCount.incr(count);
    }

    public void incrTotalBlockChosenCount(long count) {
        this.totalBlockChosenCount.incr(count);
    }

    public void incrTotalContainerChosenCount(long count) {
        this.totalContainerChosenCount.incr(count);
    }

    public void incrReceivedBlockCount(long count) {
        this.receivedBlockCount.incr(count);
    }

    public void incrMarkedBlockCount(long count) {
        this.markedBlockCount.incr(count);
    }

    public void setTotalPendingBlockCount(long count) {
        this.totalPendingBlockCount.set(count);
    }

    public void incrTotalLockTimeoutTransactionCount() {
        this.totalLockTimeoutTransactionCount.incr();
    }

    public long getSuccessCount() {
        return this.successCount.value();
    }

    public long getSuccessBytes() {
        return this.successBytes.value();
    }

    public long getFailureCount() {
        return this.failureCount.value();
    }

    public void incOutOfOrderDeleteBlockTransactionCount() {
        this.outOfOrderDeleteBlockTransactionCount.incr();
    }

    public long getOutOfOrderDeleteBlockTransactionCount() {
        return this.outOfOrderDeleteBlockTransactionCount.value();
    }

    public long getTotalPendingBlockCount() {
        return this.totalPendingBlockCount.value();
    }

    public long getTotalBlockChosenCount() {
        return this.totalBlockChosenCount.value();
    }

    public long getTotalContainerChosenCount() {
        return this.totalContainerChosenCount.value();
    }

    public long getTotalLockTimeoutTransactionCount() {
        return this.totalLockTimeoutTransactionCount.value();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("successCount = " + this.successCount.value()).append("\t").append("successBytes = " + this.successBytes.value()).append("\t").append("failureCount = " + this.failureCount.value()).append("\t").append("outOfOrderDeleteBlockTransactionCount = " + this.outOfOrderDeleteBlockTransactionCount.value()).append("\t").append("totalPendingBlockCount = " + this.totalPendingBlockCount.value()).append("\t").append("totalBlockChosenCount = " + this.totalBlockChosenCount.value()).append("\t").append("totalContainerChosenCount = " + this.totalContainerChosenCount.value()).append("\t").append("receivedTransactionCount = " + this.receivedTransactionCount.value()).append("\t").append("receivedRetryTransactionCount = " + this.receivedRetryTransactionCount.value()).append("\t").append("receivedContainerCount = " + this.receivedContainerCount.value()).append("\t").append("receivedBlockCount = " + this.receivedBlockCount.value()).append("\t").append("markedBlockCount = " + this.markedBlockCount.value()).append("\t").append("totalLockTimeoutTransactionCount = " + this.totalLockTimeoutTransactionCount.value()).append("\t");
        return buffer.toString();
    }

    static {
        SOURCE_NAME = BlockDeletingService.class.getSimpleName();
    }
}

