/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.utils;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;

public final class ContainerCacheMetrics {
    private final String name;
    private final MetricsSystem ms;
    @Metric(value={"Rate to measure the db open latency"})
    private MutableRate dbOpenLatency;
    @Metric(value={"Rate to measure the db close latency"})
    private MutableRate dbCloseLatency;
    @Metric(value={"Number of Container Cache Hits"})
    private MutableCounterLong numCacheHits;
    @Metric(value={"Number of Container Cache Misses"})
    private MutableCounterLong numCacheMisses;
    @Metric(value={"Number of DB.get Ops"})
    private MutableCounterLong numDbGetOps;
    @Metric(value={"Number of DB.remove Ops"})
    private MutableCounterLong numDbRemoveOps;
    @Metric(value={"Number of Container Cache Evictions"})
    private MutableCounterLong numCacheEvictions;

    private ContainerCacheMetrics(String name, MetricsSystem ms) {
        this.name = name;
        this.ms = ms;
    }

    public static ContainerCacheMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        String name = "ContainerCacheMetrics";
        return (ContainerCacheMetrics)ms.register(name, "null", (Object)new ContainerCacheMetrics(name, ms));
    }

    public void incNumDbGetOps() {
        this.numDbGetOps.incr();
    }

    public void incNumDbRemoveOps() {
        this.numDbRemoveOps.incr();
    }

    public void incNumCacheMisses() {
        this.numCacheMisses.incr();
    }

    public void incNumCacheHits() {
        this.numCacheHits.incr();
    }

    public void incNumCacheEvictions() {
        this.numCacheEvictions.incr();
    }

    public void incDbCloseLatency(long millis) {
        this.dbCloseLatency.add(millis);
    }

    public void incDbOpenLatency(long millis) {
        this.dbOpenLatency.add(millis);
    }

    public long getNumDbGetOps() {
        return this.numDbGetOps.value();
    }

    public long getNumDbRemoveOps() {
        return this.numDbRemoveOps.value();
    }

    public long getNumCacheMisses() {
        return this.numCacheMisses.value();
    }

    public long getNumCacheHits() {
        return this.numCacheHits.value();
    }

    public long getNumCacheEvictions() {
        return this.numCacheEvictions.value();
    }
}

