/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.ozoneimpl.AbstractContainerScannerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBackgroundContainerScanner
extends Thread {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractBackgroundContainerScanner.class);
    private final long dataScanInterval;
    private final AtomicBoolean stopping;

    public AbstractBackgroundContainerScanner(String name, long dataScanInterval) {
        this.dataScanInterval = dataScanInterval;
        this.stopping = new AtomicBoolean(false);
        this.setName(name);
        this.setDaemon(true);
    }

    @Override
    public final void run() {
        AbstractContainerScannerMetrics metrics = this.getMetrics();
        try {
            while (!this.stopping.get()) {
                this.runIteration();
                metrics.resetNumContainersScanned();
                metrics.resetNumUnhealthyContainers();
            }
            LOG.info("{} exiting.", (Object)this);
        }
        catch (Exception e) {
            LOG.error("{} exiting because of exception ", (Object)this, (Object)e);
        }
        finally {
            if (metrics != null) {
                metrics.unregister();
            }
        }
    }

    @VisibleForTesting
    public final void runIteration() {
        long startTime = System.nanoTime();
        this.scanContainers();
        long totalDuration = System.nanoTime() - startTime;
        if (this.stopping.get()) {
            return;
        }
        AbstractContainerScannerMetrics metrics = this.getMetrics();
        metrics.incNumScanIterations();
        LOG.info("Completed an iteration in {} minutes. Number of iterations (since the data-node restart) : {}, Number of containers scanned in this iteration : {}, Number of unhealthy containers found in this iteration : {}", new Object[]{TimeUnit.NANOSECONDS.toMinutes(totalDuration), metrics.getNumScanIterations(), metrics.getNumContainersScanned(), metrics.getNumUnHealthyContainers()});
        long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(totalDuration);
        long remainingSleep = this.dataScanInterval - elapsedMillis;
        this.handleRemainingSleep(remainingSleep);
    }

    public final void scanContainers() {
        Iterator<Container<?>> itr = this.getContainerIterator();
        while (!this.stopping.get() && itr.hasNext()) {
            Container<?> c = itr.next();
            try {
                this.scanContainer(c);
            }
            catch (InterruptedException ex) {
                this.stopping.set(true);
            }
            catch (IOException ex) {
                LOG.warn("Unexpected exception while scanning container " + ((ContainerData)c.getContainerData()).getContainerID(), (Throwable)ex);
            }
        }
    }

    public abstract Iterator<Container<?>> getContainerIterator();

    public abstract void scanContainer(Container<?> var1) throws IOException, InterruptedException;

    public final void handleRemainingSleep(long remainingSleep) {
        if (remainingSleep > 0L) {
            try {
                Thread.sleep(remainingSleep);
            }
            catch (InterruptedException ignored) {
                this.stopping.set(true);
                LOG.warn("Background container scan was interrupted.");
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void shutdown() {
        if (this.stopping.compareAndSet(false, true)) {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException ex) {
                LOG.warn("Unexpected exception while stopping data scanner.", (Throwable)ex);
                Thread.currentThread().interrupt();
            }
        }
    }

    @VisibleForTesting
    public abstract AbstractContainerScannerMetrics getMetrics();
}

