/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.ozone.container.replication.ContainerUploader;
import org.apache.hadoop.ozone.container.replication.CopyContainerCompression;
import org.apache.hadoop.ozone.container.replication.GrpcReplicationClient;
import org.apache.hadoop.ozone.container.replication.SendContainerOutputStream;
import org.apache.ratis.thirdparty.io.grpc.stub.CallStreamObserver;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcContainerUploader
implements ContainerUploader {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcContainerUploader.class);
    private final SecurityConfig securityConfig;
    private final CertificateClient certClient;

    public GrpcContainerUploader(ConfigurationSource conf, CertificateClient certClient) {
        this.certClient = certClient;
        this.securityConfig = new SecurityConfig(conf);
    }

    @Override
    public OutputStream startUpload(long containerId, DatanodeDetails target, CompletableFuture<Void> callback, CopyContainerCompression compression) throws IOException {
        final GrpcReplicationClient client = this.createReplicationClient(target, compression);
        try {
            SendContainerResponseStreamObserver responseObserver = new SendContainerResponseStreamObserver(containerId, target, callback);
            WrappedRequestStreamObserver requestStream = new WrappedRequestStreamObserver((CallStreamObserver)client.upload(responseObserver), responseObserver);
            return new SendContainerOutputStream(requestStream, containerId, 0x100000, compression){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    catch (Throwable throwable) {
                        IOUtils.close((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{client});
                        throw throwable;
                    }
                    IOUtils.close((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{client});
                }
            };
        }
        catch (Exception e) {
            IOUtils.close((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{client});
            throw e;
        }
    }

    @VisibleForTesting
    protected GrpcReplicationClient createReplicationClient(DatanodeDetails target, CopyContainerCompression compression) throws IOException {
        return new GrpcReplicationClient(target.getIpAddress(), target.getPort(DatanodeDetails.Port.Name.REPLICATION).getValue(), this.securityConfig, this.certClient, compression);
    }

    public static class WrappedRequestStreamObserver<T>
    extends CallStreamObserver<T> {
        private final CallStreamObserver<T> observer;
        private final SendContainerResponseStreamObserver responseObserver;

        public WrappedRequestStreamObserver(CallStreamObserver observer, SendContainerResponseStreamObserver responseObserver) {
            this.observer = observer;
            this.responseObserver = responseObserver;
        }

        public boolean isReady() {
            if (this.responseObserver.isError()) {
                throw new RuntimeException(this.responseObserver.getError());
            }
            return this.observer.isReady();
        }

        public void setOnReadyHandler(Runnable runnable) {
            this.observer.setOnReadyHandler(runnable);
        }

        public void disableAutoInboundFlowControl() {
            this.observer.disableAutoInboundFlowControl();
        }

        public void request(int i) {
            this.observer.request(i);
        }

        public void setMessageCompression(boolean b) {
            this.observer.setMessageCompression(b);
        }

        public void onNext(T sendContainerResponse) {
            this.observer.onNext(sendContainerResponse);
        }

        public void onError(Throwable throwable) {
            if (!this.responseObserver.isError()) {
                this.responseObserver.onError(throwable);
            }
            this.observer.onError(throwable);
        }

        public void onCompleted() {
            this.observer.onCompleted();
        }
    }

    public static class SendContainerResponseStreamObserver
    implements StreamObserver<ContainerProtos.SendContainerResponse> {
        private final long containerId;
        private final DatanodeDetails target;
        private final CompletableFuture<Void> callback;
        private AtomicBoolean error = new AtomicBoolean(false);
        private volatile Throwable throwable = null;

        SendContainerResponseStreamObserver(long containerId, DatanodeDetails target, CompletableFuture<Void> callback) {
            this.containerId = containerId;
            this.target = target;
            this.callback = callback;
        }

        public void onNext(ContainerProtos.SendContainerResponse sendContainerResponse) {
            LOG.debug("Response for upload container {} to {}", (Object)this.containerId, (Object)this.target);
        }

        public void onError(Throwable t) {
            LOG.warn("Failed to upload container {} to {}", new Object[]{this.containerId, this.target, t});
            this.throwable = t;
            this.error.set(true);
            this.callback.completeExceptionally(t);
        }

        public void onCompleted() {
            LOG.info("Finished uploading container {} to {}", (Object)this.containerId, (Object)this.target);
            this.callback.complete(null);
        }

        public boolean isError() {
            return this.error.get();
        }

        public Throwable getError() {
            return this.throwable;
        }
    }
}

