/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.datanode.proto.IntraDatanodeProtocolServiceGrpc;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.ozone.container.replication.ContainerImporter;
import org.apache.hadoop.ozone.container.replication.ContainerReplicationSource;
import org.apache.hadoop.ozone.container.replication.CopyContainerCompression;
import org.apache.hadoop.ozone.container.replication.CopyContainerResponseStream;
import org.apache.hadoop.ozone.container.replication.SendContainerRequestHandler;
import org.apache.ratis.thirdparty.io.grpc.stub.CallStreamObserver;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcReplicationService
extends IntraDatanodeProtocolServiceGrpc.IntraDatanodeProtocolServiceImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcReplicationService.class);
    static final int BUFFER_SIZE = 0x100000;
    private final ContainerReplicationSource source;
    private final ContainerImporter importer;

    public GrpcReplicationService(ContainerReplicationSource source, ContainerImporter importer) {
        this.source = source;
        this.importer = importer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(ContainerProtos.CopyContainerRequestProto request, StreamObserver<ContainerProtos.CopyContainerResponseProto> responseObserver) {
        long containerID = request.getContainerID();
        CopyContainerCompression compression = CopyContainerCompression.fromProto(request.getCompression());
        LOG.info("Streaming container data ({}) to other datanode with compression {}", (Object)containerID, (Object)compression);
        CopyContainerResponseStream outputStream = null;
        try {
            outputStream = new CopyContainerResponseStream((CallStreamObserver<ContainerProtos.CopyContainerResponseProto>)((CallStreamObserver)responseObserver), containerID, 0x100000);
            this.source.copyData(containerID, outputStream, compression);
        }
        catch (IOException e) {
            try {
                LOG.warn("Error streaming container {}", (Object)containerID, (Object)e);
                responseObserver.onError((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{outputStream});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{outputStream});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{outputStream});
    }

    public StreamObserver<ContainerProtos.SendContainerRequest> upload(StreamObserver<ContainerProtos.SendContainerResponse> responseObserver) {
        return new SendContainerRequestHandler(this.importer, responseObserver);
    }
}

