/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.stream;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ByteProcessor;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.hadoop.ozone.container.stream.StreamingDestination;

public class DirstreamClientHandler
extends ChannelInboundHandlerAdapter {
    private final StreamingDestination destination;
    private boolean headerMode = true;
    private StringBuilder currentFileName = new StringBuilder();
    private RandomAccessFile destFile;
    private FileChannel destFileChannel;
    private long remaining;

    public DirstreamClientHandler(StreamingDestination streamingDestination) {
        this.destination = streamingDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws IOException {
        try {
            ByteBuf buffer = (ByteBuf)msg;
            this.doRead(ctx, buffer);
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void doRead(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        if (this.headerMode) {
            int eolPosition = buffer.forEachByte(ByteProcessor.FIND_LF) - buffer.readerIndex();
            if (eolPosition > 0) {
                this.headerMode = false;
                ByteBuf name = buffer.readBytes(eolPosition);
                this.currentFileName.append(name.toString(StandardCharsets.UTF_8));
                name.release();
                buffer.skipBytes(1);
                String[] parts = this.currentFileName.toString().split(" ", 2);
                this.remaining = Long.parseLong(parts[0]);
                Path destFilePath = this.destination.mapToDestination(parts[1]);
                Path destfileParent = destFilePath.getParent();
                if (destfileParent == null) {
                    throw new IllegalArgumentException("Streaming destination provider return with invalid path: " + destFilePath);
                }
                Files.createDirectories(destfileParent, new FileAttribute[0]);
                this.destFile = new RandomAccessFile(destFilePath.toFile(), "rw");
                this.destFileChannel = this.destFile.getChannel();
            } else {
                this.currentFileName.append(buffer.toString(StandardCharsets.UTF_8));
            }
        }
        if (!this.headerMode) {
            int readableBytes = buffer.readableBytes();
            if (this.remaining >= (long)readableBytes) {
                this.remaining -= (long)buffer.readBytes((GatheringByteChannel)this.destFileChannel, readableBytes);
            } else {
                this.remaining -= (long)buffer.readBytes((GatheringByteChannel)this.destFileChannel, (int)this.remaining);
                this.currentFileName = new StringBuilder();
                this.headerMode = true;
                this.destFile.close();
                if (readableBytes > 0) {
                    this.doRead(ctx, buffer);
                }
            }
        }
    }

    public boolean isAtTheEnd() {
        return this.getCurrentFileName().equals("0 END");
    }

    public void channelUnregistered(ChannelHandlerContext ctx) {
        try {
            if (this.destFile != null) {
                this.destFile.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        try {
            this.destFileChannel.close();
            this.destFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ctx.close();
    }

    public String getCurrentFileName() {
        return this.currentFileName.toString();
    }
}

