/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.utils.DBStoreHAManager;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.StringCodec;
import org.apache.hadoop.ozone.common.ha.ratis.RatisSnapshotInfo;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.statemachine.SnapshotInfo;

public final class TransactionInfo {
    private static final Codec<TransactionInfo> CODEC = new DelegatedCodec((Codec)StringCodec.get(), TransactionInfo::new, TransactionInfo::generateTransactionInfo, DelegatedCodec.CopyType.SHALLOW);
    private final long term;
    private final long transactionIndex;

    public static Codec<TransactionInfo> getCodec() {
        return CODEC;
    }

    private TransactionInfo(String transactionInfo) {
        String[] tInfo = transactionInfo.split("#");
        Preconditions.checkArgument((tInfo.length == 2 ? 1 : 0) != 0, (Object)"Incorrect TransactionInfo value");
        this.term = Long.parseLong(tInfo[0]);
        this.transactionIndex = Long.parseLong(tInfo[1]);
    }

    private TransactionInfo(long currentTerm, long transactionIndex) {
        this.term = currentTerm;
        this.transactionIndex = transactionIndex;
    }

    public boolean isDefault() {
        return this.transactionIndex == -1L && this.term == 0L;
    }

    public int compareTo(TransactionInfo info) {
        if (info.getTerm() == this.getTerm()) {
            return (int)(this.getTransactionIndex() - info.getTransactionIndex());
        }
        return (int)(this.getTerm() - info.getTerm());
    }

    public long getTerm() {
        return this.term;
    }

    public long getTransactionIndex() {
        return this.transactionIndex;
    }

    public TermIndex getTermIndex() {
        return TermIndex.valueOf((long)this.term, (long)this.transactionIndex);
    }

    private String generateTransactionInfo() {
        return this.term + "#" + this.transactionIndex;
    }

    public byte[] convertToByteArray() {
        return StringUtils.string2Bytes((String)this.generateTransactionInfo());
    }

    public static TransactionInfo getFromByteArray(byte[] bytes) {
        String tInfo = StringUtils.bytes2String((byte[])bytes);
        return new TransactionInfo(tInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionInfo that = (TransactionInfo)o;
        return this.term == that.term && this.transactionIndex == that.transactionIndex;
    }

    public static TransactionInfo fromTermIndex(TermIndex termIndex) {
        return new Builder().setCurrentTerm(termIndex.getTerm()).setTransactionIndex(termIndex.getIndex()).build();
    }

    public int hashCode() {
        return Objects.hash(this.term, this.transactionIndex);
    }

    public String toString() {
        return this.generateTransactionInfo();
    }

    public static TransactionInfo readTransactionInfo(DBStoreHAManager metadataManager) throws IOException {
        return metadataManager.getTransactionInfoTable().get("#TRANSACTIONINFO");
    }

    public SnapshotInfo toSnapshotInfo() {
        return new RatisSnapshotInfo(this.term, this.transactionIndex);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long currentTerm = 0L;
        private long transactionIndex = -1L;

        public Builder setCurrentTerm(long term) {
            this.currentTerm = term;
            return this;
        }

        public Builder setTransactionIndex(long tIndex) {
            this.transactionIndex = tIndex;
            return this;
        }

        public TransactionInfo build() {
            return new TransactionInfo(this.currentTerm, this.transactionIndex);
        }
    }
}

