/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.lib.util;

import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;

@InterfaceAudience.Private
public final class Check {
    private static final String IDENTIFIER_PATTERN_STR = "[a-zA-z_][a-zA-Z0-9_\\-]*";
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("^[a-zA-z_][a-zA-Z0-9_\\-]*$");

    private Check() {
    }

    public static <T> T notNull(T obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        return obj;
    }

    public static <T> List<T> notNullElements(List<T> list, String name) {
        Check.notNull(list, name);
        for (int i = 0; i < list.size(); ++i) {
            Check.notNull(list.get(i), MessageFormat.format("list [{0}] element [{1}]", name, i));
        }
        return list;
    }

    public static String notEmpty(String str, String name) {
        if (str == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        if (str.length() == 0) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
        return str;
    }

    public static List<String> notEmptyElements(List<String> list, String name) {
        Check.notNull(list, name);
        for (int i = 0; i < list.size(); ++i) {
            Check.notEmpty(list.get(i), MessageFormat.format("list [{0}] element [{1}]", name, i));
        }
        return list;
    }

    public static String validIdentifier(String value, int maxLen, String name) {
        Check.notEmpty(value, name);
        if (value.length() > maxLen) {
            throw new IllegalArgumentException(MessageFormat.format("[{0}] = [{1}] exceeds max len [{2}]", name, value, maxLen));
        }
        if (!IDENTIFIER_PATTERN.matcher(value).find()) {
            throw new IllegalArgumentException(MessageFormat.format("[{0}] = [{1}] must be '{2}'", name, value, IDENTIFIER_PATTERN_STR));
        }
        return value;
    }

    public static int gt0(int value, String name) {
        return (int)Check.gt0((long)value, name);
    }

    public static long gt0(long value, String name) {
        if (value <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("parameter [{0}] = [{1}] must be greater than zero", name, value));
        }
        return value;
    }

    public static int ge0(int value, String name) {
        return (int)Check.ge0((long)value, name);
    }

    public static long ge0(long value, String name) {
        if (value < 0L) {
            throw new IllegalArgumentException(MessageFormat.format("parameter [{0}] = [{1}] must be greater than or equals zero", name, value));
        }
        return value;
    }
}

