/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.storage.AbstractCommitWatcher;
import org.apache.hadoop.hdds.scm.storage.BufferPool;
import org.apache.hadoop.ozone.common.ChunkBuffer;

class CommitWatcher
extends AbstractCommitWatcher<ChunkBuffer> {
    private final BufferPool bufferPool;
    private final ConcurrentMap<Long, CompletableFuture<ContainerProtos.ContainerCommandResponseProto>> futureMap = new ConcurrentHashMap<Long, CompletableFuture<ContainerProtos.ContainerCommandResponseProto>>();

    CommitWatcher(BufferPool bufferPool, XceiverClientSpi xceiverClient) {
        super(xceiverClient);
        this.bufferPool = bufferPool;
    }

    @Override
    void releaseBuffers(long index) {
        long acked = 0L;
        for (ChunkBuffer buffer : this.remove(index)) {
            acked += (long)buffer.position();
            this.bufferPool.releaseBuffer(buffer);
        }
        long totalLength = this.addAckDataLength(acked);
        CompletableFuture removed = (CompletableFuture)this.futureMap.remove(totalLength);
        Objects.requireNonNull(removed, () -> "Future not found for " + totalLength + ": existing = " + this.futureMap.keySet());
    }

    @VisibleForTesting
    ConcurrentMap<Long, CompletableFuture<ContainerProtos.ContainerCommandResponseProto>> getFutureMap() {
        return this.futureMap;
    }

    public void putFlushFuture(long flushPos, CompletableFuture<ContainerProtos.ContainerCommandResponseProto> flushFuture) {
        this.futureMap.compute(flushPos, (key, previous) -> previous == null ? flushFuture : previous.thenCombine(flushFuture, (prev, curr) -> curr));
    }

    public void waitOnFlushFutures() throws InterruptedException, ExecutionException {
        CompletableFuture.allOf(this.futureMap.values().toArray(new CompletableFuture[0])).get();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.futureMap.clear();
    }
}

