/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import java.nio.ByteBuffer;

public class StreamBuffer {
    private final ByteBuffer buffer;

    public StreamBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public StreamBuffer(ByteBuffer buffer, int offset, int length) {
        this((ByteBuffer)buffer.asReadOnlyBuffer().position(offset).limit(offset + length));
    }

    public ByteBuffer duplicate() {
        return this.buffer.duplicate();
    }

    public int length() {
        return this.buffer.limit() - this.buffer.position();
    }

    public int position() {
        return this.buffer.position();
    }

    public void put(StreamBuffer sb) {
        this.buffer.put(sb.buffer);
    }

    public static StreamBuffer allocate(int size) {
        return new StreamBuffer(ByteBuffer.allocate(size));
    }
}

