/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number;

import com.ibm.icu.impl.StandardPlural;
import com.ibm.icu.impl.TextTrieMap;
import com.ibm.icu.impl.number.AffixUtils;
import com.ibm.icu.impl.number.DecimalFormatProperties;
import com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import com.ibm.icu.impl.number.PatternStringParser;
import com.ibm.icu.impl.number.RoundingUtils;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.CurrencyPluralInfo;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.CurrencyAmount;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Parse {
    private static final UnicodeSet UNISET_WHITESPACE = new UnicodeSet("[[:Zs:][\\u0009]]").freeze();
    private static final UnicodeSet UNISET_BIDI = new UnicodeSet("[[\\u200E\\u200F\\u061C]]").freeze();
    private static final UnicodeSet UNISET_PERIOD_LIKE = new UnicodeSet("[.\\u2024\\u3002\\uFE12\\uFE52\\uFF0E\\uFF61]").freeze();
    private static final UnicodeSet UNISET_STRICT_PERIOD_LIKE = new UnicodeSet("[.\\u2024\\uFE52\\uFF0E\\uFF61]").freeze();
    private static final UnicodeSet UNISET_COMMA_LIKE = new UnicodeSet("[,\\u060C\\u066B\\u3001\\uFE10\\uFE11\\uFE50\\uFE51\\uFF0C\\uFF64]").freeze();
    private static final UnicodeSet UNISET_STRICT_COMMA_LIKE = new UnicodeSet("[,\\u066B\\uFE10\\uFE50\\uFF0C]").freeze();
    private static final UnicodeSet UNISET_OTHER_GROUPING_SEPARATORS = new UnicodeSet("[\\ '\\u00A0\\u066C\\u2000-\\u200A\\u2018\\u2019\\u202F\\u205F\\u3000\\uFF07]").freeze();
    private static final BigDecimal MIN_LONG_AS_BIG_DECIMAL = new BigDecimal(Long.MIN_VALUE);
    private static final BigDecimal MAX_LONG_AS_BIG_DECIMAL = new BigDecimal(Long.MAX_VALUE);
    protected static final ThreadLocal<ParserState> threadLocalParseState = new ThreadLocal<ParserState>(){

        @Override
        protected ParserState initialValue() {
            return new ParserState();
        }
    };
    protected static final ThreadLocal<ParsePosition> threadLocalParsePosition = new ThreadLocal<ParsePosition>(){

        @Override
        protected ParsePosition initialValue() {
            return new ParsePosition(0);
        }
    };
    @Deprecated
    public static final UnicodeSet UNISET_PLUS = new UnicodeSet(43, 43, 8314, 8314, 8330, 8330, 10133, 10133, 64297, 64297, 65122, 65122, 65291, 65291).freeze();
    @Deprecated
    public static final UnicodeSet UNISET_MINUS = new UnicodeSet(45, 45, 8315, 8315, 8331, 8331, 8722, 8722, 10134, 10134, 65123, 65123, 65293, 65293).freeze();
    public static volatile boolean DEBUGGING = false;

    static TextTrieMap<Byte> makeDigitTrie(String[] digitStrings) {
        boolean requiresTrie = false;
        for (int i = 0; i < 10; ++i) {
            String str = digitStrings[i];
            if (Character.charCount(Character.codePointAt(str, 0)) == str.length()) continue;
            requiresTrie = true;
            break;
        }
        if (!requiresTrie) {
            return null;
        }
        TextTrieMap<Byte> trieMap = new TextTrieMap<Byte>(false);
        for (int i = 0; i < 10; ++i) {
            trieMap.put(digitStrings[i], (byte)i);
        }
        return trieMap;
    }

    public static Number parse(String input, DecimalFormatProperties properties, DecimalFormatSymbols symbols) {
        ParsePosition ppos = threadLocalParsePosition.get();
        ppos.setIndex(0);
        return Parse.parse(input, ppos, properties, symbols);
    }

    public static Number parse(CharSequence input, ParsePosition ppos, DecimalFormatProperties properties, DecimalFormatSymbols symbols) {
        StateItem best = Parse._parse(input, ppos, false, properties, symbols);
        return best == null ? (Number)null : (Number)best.toNumber(properties);
    }

    public static CurrencyAmount parseCurrency(String input, DecimalFormatProperties properties, DecimalFormatSymbols symbols) throws ParseException {
        return Parse.parseCurrency(input, null, properties, symbols);
    }

    public static CurrencyAmount parseCurrency(CharSequence input, ParsePosition ppos, DecimalFormatProperties properties, DecimalFormatSymbols symbols) throws ParseException {
        StateItem best;
        if (ppos == null) {
            ppos = threadLocalParsePosition.get();
            ppos.setIndex(0);
            ppos.setErrorIndex(-1);
        }
        return (best = Parse._parse(input, ppos, true, properties, symbols)) == null ? null : best.toCurrencyAmount(properties);
    }

    private static StateItem _parse(CharSequence input, ParsePosition ppos, boolean parseCurrency, DecimalFormatProperties properties, DecimalFormatSymbols symbols) {
        StateItem item;
        int i;
        int offset;
        int cp;
        if (input == null || ppos == null || properties == null || symbols == null) {
            throw new IllegalArgumentException("All arguments are required for parse.");
        }
        ParseMode mode = properties.getParseMode();
        if (mode == null) {
            mode = ParseMode.LENIENT;
        }
        boolean integerOnly = properties.getParseIntegerOnly();
        boolean ignoreExponent = properties.getParseNoExponent();
        boolean ignoreGrouping = properties.getGroupingSize() <= 0;
        ParserState state2 = threadLocalParseState.get().clear();
        state2.properties = properties;
        state2.symbols = symbols;
        state2.mode = mode;
        state2.parseCurrency = parseCurrency;
        state2.groupingMode = properties.getParseGroupingMode();
        if (state2.groupingMode == null) {
            state2.groupingMode = GroupingMode.DEFAULT;
        }
        state2.caseSensitive = properties.getParseCaseSensitive();
        state2.decimalCp1 = Character.codePointAt(symbols.getDecimalSeparatorString(), 0);
        state2.decimalCp2 = Character.codePointAt(symbols.getMonetaryDecimalSeparatorString(), 0);
        state2.groupingCp1 = Character.codePointAt(symbols.getGroupingSeparatorString(), 0);
        state2.groupingCp2 = Character.codePointAt(symbols.getMonetaryGroupingSeparatorString(), 0);
        state2.decimalType1 = SeparatorType.fromCp(state2.decimalCp1, mode);
        state2.decimalType2 = SeparatorType.fromCp(state2.decimalCp2, mode);
        state2.groupingType1 = SeparatorType.fromCp(state2.groupingCp1, mode);
        state2.groupingType2 = SeparatorType.fromCp(state2.groupingCp2, mode);
        StateItem initialStateItem = state2.getNext().clear();
        initialStateItem.name = StateName.BEFORE_PREFIX;
        if (mode == ParseMode.LENIENT || mode == ParseMode.STRICT) {
            state2.digitTrie = Parse.makeDigitTrie(symbols.getDigitStringsLocal());
            AffixHolder.addToState(state2, properties);
            if (parseCurrency) {
                CurrencyAffixPatterns.addToState(symbols.getULocale(), state2);
            }
        }
        if (DEBUGGING) {
            System.out.println("Parsing: " + input);
            System.out.println(properties);
            System.out.println(state2);
        }
        for (offset = ppos.getIndex(); offset < input.length(); offset += Character.charCount(cp)) {
            cp = Character.codePointAt(input, offset);
            state2.swap();
            block16: for (i = 0; i < state2.prevLength; ++i) {
                item = state2.prevItems[i];
                if (DEBUGGING) {
                    System.out.println(":" + offset + item.id + " " + item);
                }
                switch (item.name) {
                    case BEFORE_PREFIX: {
                        if (mode == ParseMode.LENIENT || mode == ParseMode.FAST) {
                            Parse.acceptMinusOrPlusSign(cp, StateName.BEFORE_PREFIX, state2, item, false);
                            if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        }
                        Parse.acceptIntegerDigit(cp, StateName.AFTER_INTEGER_DIGIT, state2, item);
                        if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        Parse.acceptBidi(cp, StateName.BEFORE_PREFIX, state2, item);
                        if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        Parse.acceptWhitespace(cp, StateName.BEFORE_PREFIX, state2, item);
                        if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        Parse.acceptPadding(cp, StateName.BEFORE_PREFIX, state2, item);
                        if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        Parse.acceptNan(cp, StateName.BEFORE_SUFFIX, state2, item);
                        if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        Parse.acceptInfinity(cp, StateName.BEFORE_SUFFIX, state2, item);
                        if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        if (!integerOnly) {
                            Parse.acceptDecimalPoint(cp, StateName.AFTER_FRACTION_DIGIT, state2, item);
                            if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        }
                        if (mode == ParseMode.LENIENT || mode == ParseMode.STRICT) {
                            Parse.acceptPrefix(cp, StateName.AFTER_PREFIX, state2, item);
                        }
                        if (mode != ParseMode.LENIENT && mode != ParseMode.FAST) continue block16;
                        if (!ignoreGrouping) {
                            Parse.acceptGrouping(cp, StateName.AFTER_INTEGER_DIGIT, state2, item);
                            if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        }
                        if (!parseCurrency) continue block16;
                        Parse.acceptCurrency(cp, StateName.BEFORE_PREFIX, state2, item);
                        continue block16;
                    }
                    case AFTER_PREFIX: {
                        Parse.acceptBidi(cp, StateName.AFTER_PREFIX, state2, item);
                        Parse.acceptPadding(cp, StateName.AFTER_PREFIX, state2, item);
                        Parse.acceptNan(cp, StateName.BEFORE_SUFFIX, state2, item);
                        Parse.acceptInfinity(cp, StateName.BEFORE_SUFFIX, state2, item);
                        Parse.acceptIntegerDigit(cp, StateName.AFTER_INTEGER_DIGIT, state2, item);
                        if (!integerOnly) {
                            Parse.acceptDecimalPoint(cp, StateName.AFTER_FRACTION_DIGIT, state2, item);
                        }
                        if (mode != ParseMode.LENIENT && mode != ParseMode.FAST) continue block16;
                        Parse.acceptWhitespace(cp, StateName.AFTER_PREFIX, state2, item);
                        if (!ignoreGrouping) {
                            Parse.acceptGrouping(cp, StateName.AFTER_INTEGER_DIGIT, state2, item);
                        }
                        if (!parseCurrency) continue block16;
                        Parse.acceptCurrency(cp, StateName.AFTER_PREFIX, state2, item);
                        continue block16;
                    }
                    case AFTER_INTEGER_DIGIT: {
                        Parse.acceptIntegerDigit(cp, StateName.AFTER_INTEGER_DIGIT, state2, item);
                        if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        if (!integerOnly) {
                            Parse.acceptDecimalPoint(cp, StateName.AFTER_FRACTION_DIGIT, state2, item);
                            if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        }
                        if (!ignoreGrouping) {
                            Parse.acceptGrouping(cp, StateName.AFTER_INTEGER_DIGIT, state2, item);
                            if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        }
                        Parse.acceptBidi(cp, StateName.BEFORE_SUFFIX, state2, item);
                        if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        Parse.acceptPadding(cp, StateName.BEFORE_SUFFIX, state2, item);
                        if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        if (!ignoreExponent) {
                            Parse.acceptExponentSeparator(cp, StateName.AFTER_EXPONENT_SEPARATOR, state2, item);
                            if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        }
                        if (mode == ParseMode.LENIENT || mode == ParseMode.STRICT) {
                            Parse.acceptSuffix(cp, StateName.AFTER_SUFFIX, state2, item);
                        }
                        if (mode != ParseMode.LENIENT && mode != ParseMode.FAST) continue block16;
                        Parse.acceptWhitespace(cp, StateName.BEFORE_SUFFIX, state2, item);
                        if (state2.length > 0 && mode == ParseMode.FAST || state2.length > 0 && mode == ParseMode.FAST || !parseCurrency) continue block16;
                        Parse.acceptCurrency(cp, StateName.BEFORE_SUFFIX, state2, item);
                        continue block16;
                    }
                    case AFTER_FRACTION_DIGIT: {
                        Parse.acceptFractionDigit(cp, StateName.AFTER_FRACTION_DIGIT, state2, item);
                        if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        Parse.acceptBidi(cp, StateName.BEFORE_SUFFIX, state2, item);
                        if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        Parse.acceptPadding(cp, StateName.BEFORE_SUFFIX, state2, item);
                        if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        if (!ignoreExponent) {
                            Parse.acceptExponentSeparator(cp, StateName.AFTER_EXPONENT_SEPARATOR, state2, item);
                            if (state2.length > 0 && mode == ParseMode.FAST) continue block16;
                        }
                        if (mode == ParseMode.LENIENT || mode == ParseMode.STRICT) {
                            Parse.acceptSuffix(cp, StateName.AFTER_SUFFIX, state2, item);
                        }
                        if (mode != ParseMode.LENIENT && mode != ParseMode.FAST) continue block16;
                        Parse.acceptWhitespace(cp, StateName.BEFORE_SUFFIX, state2, item);
                        if (state2.length > 0 && mode == ParseMode.FAST || state2.length > 0 && mode == ParseMode.FAST || !parseCurrency) continue block16;
                        Parse.acceptCurrency(cp, StateName.BEFORE_SUFFIX, state2, item);
                        continue block16;
                    }
                    case AFTER_EXPONENT_SEPARATOR: {
                        Parse.acceptBidi(cp, StateName.AFTER_EXPONENT_SEPARATOR, state2, item);
                        Parse.acceptMinusOrPlusSign(cp, StateName.AFTER_EXPONENT_SEPARATOR, state2, item, true);
                        Parse.acceptExponentDigit(cp, StateName.AFTER_EXPONENT_DIGIT, state2, item);
                        continue block16;
                    }
                    case AFTER_EXPONENT_DIGIT: {
                        Parse.acceptBidi(cp, StateName.BEFORE_SUFFIX_SEEN_EXPONENT, state2, item);
                        Parse.acceptPadding(cp, StateName.BEFORE_SUFFIX_SEEN_EXPONENT, state2, item);
                        Parse.acceptExponentDigit(cp, StateName.AFTER_EXPONENT_DIGIT, state2, item);
                        if (mode == ParseMode.LENIENT || mode == ParseMode.STRICT) {
                            Parse.acceptSuffix(cp, StateName.AFTER_SUFFIX, state2, item);
                        }
                        if (mode != ParseMode.LENIENT && mode != ParseMode.FAST) continue block16;
                        Parse.acceptWhitespace(cp, StateName.BEFORE_SUFFIX_SEEN_EXPONENT, state2, item);
                        if (!parseCurrency) continue block16;
                        Parse.acceptCurrency(cp, StateName.BEFORE_SUFFIX_SEEN_EXPONENT, state2, item);
                        continue block16;
                    }
                    case BEFORE_SUFFIX: {
                        Parse.acceptBidi(cp, StateName.BEFORE_SUFFIX, state2, item);
                        Parse.acceptPadding(cp, StateName.BEFORE_SUFFIX, state2, item);
                        if (!ignoreExponent) {
                            Parse.acceptExponentSeparator(cp, StateName.AFTER_EXPONENT_SEPARATOR, state2, item);
                        }
                        if (mode == ParseMode.LENIENT || mode == ParseMode.STRICT) {
                            Parse.acceptSuffix(cp, StateName.AFTER_SUFFIX, state2, item);
                        }
                        if (mode != ParseMode.LENIENT && mode != ParseMode.FAST) continue block16;
                        Parse.acceptWhitespace(cp, StateName.BEFORE_SUFFIX, state2, item);
                        if (!parseCurrency) continue block16;
                        Parse.acceptCurrency(cp, StateName.BEFORE_SUFFIX, state2, item);
                        continue block16;
                    }
                    case BEFORE_SUFFIX_SEEN_EXPONENT: {
                        Parse.acceptBidi(cp, StateName.BEFORE_SUFFIX_SEEN_EXPONENT, state2, item);
                        Parse.acceptPadding(cp, StateName.BEFORE_SUFFIX_SEEN_EXPONENT, state2, item);
                        if (mode == ParseMode.LENIENT || mode == ParseMode.STRICT) {
                            Parse.acceptSuffix(cp, StateName.AFTER_SUFFIX, state2, item);
                        }
                        if (mode != ParseMode.LENIENT && mode != ParseMode.FAST) continue block16;
                        Parse.acceptWhitespace(cp, StateName.BEFORE_SUFFIX_SEEN_EXPONENT, state2, item);
                        if (!parseCurrency) continue block16;
                        Parse.acceptCurrency(cp, StateName.BEFORE_SUFFIX_SEEN_EXPONENT, state2, item);
                        continue block16;
                    }
                    case AFTER_SUFFIX: {
                        if (mode != ParseMode.LENIENT && mode != ParseMode.FAST || !parseCurrency) continue block16;
                        Parse.acceptBidi(cp, StateName.AFTER_SUFFIX, state2, item);
                        Parse.acceptPadding(cp, StateName.AFTER_SUFFIX, state2, item);
                        Parse.acceptWhitespace(cp, StateName.AFTER_SUFFIX, state2, item);
                        if (!parseCurrency) continue block16;
                        Parse.acceptCurrency(cp, StateName.AFTER_SUFFIX, state2, item);
                        continue block16;
                    }
                    case INSIDE_CURRENCY: {
                        Parse.acceptCurrencyOffset(cp, state2, item);
                        continue block16;
                    }
                    case INSIDE_DIGIT: {
                        Parse.acceptDigitTrieOffset(cp, state2, item);
                        continue block16;
                    }
                    case INSIDE_STRING: {
                        Parse.acceptStringOffset(cp, state2, item);
                        continue block16;
                    }
                    case INSIDE_AFFIX_PATTERN: {
                        Parse.acceptAffixPatternOffset(cp, state2, item);
                    }
                }
            }
            if (state2.length != 0) continue;
            state2.swapBack();
            break;
        }
        if (state2.length == 0) {
            if (DEBUGGING) {
                System.out.println("No matches found");
                System.out.println("- - - - - - - - - -");
            }
            return null;
        }
        StateItem best = null;
        block17: for (i = 0; i < state2.length; ++i) {
            item = state2.items[i];
            if (DEBUGGING) {
                System.out.println(":end " + item);
            }
            if (!item.hasNumber()) {
                if (!DEBUGGING) continue;
                System.out.println("-> rejected due to no number value");
                continue;
            }
            if (mode == ParseMode.STRICT) {
                int numGroupingRegions;
                boolean hasEmptyAffix;
                boolean sawPrefix = item.sawPrefix || item.affix != null && item.affix.p.isEmpty();
                boolean sawSuffix = item.sawSuffix || item.affix != null && item.affix.s.isEmpty();
                boolean bl = hasEmptyAffix = state2.affixHolders.contains(AffixHolder.EMPTY_POSITIVE) || state2.affixHolders.contains(AffixHolder.EMPTY_NEGATIVE);
                if (!(sawPrefix && sawSuffix || !sawPrefix && !sawSuffix && hasEmptyAffix)) {
                    if (!DEBUGGING) continue;
                    System.out.println("-> rejected due to mismatched prefix/suffix");
                    continue;
                }
                if (properties.getMinimumExponentDigits() > 0 && !item.sawExponentDigit) {
                    if (!DEBUGGING) continue;
                    System.out.println("-> reject due to lack of exponent");
                    continue;
                }
                int grouping1 = properties.getGroupingSize();
                int grouping2 = properties.getSecondaryGroupingSize();
                grouping1 = grouping1 > 0 ? grouping1 : grouping2;
                grouping2 = grouping2 > 0 ? grouping2 : grouping1;
                long groupingWidths = item.groupingWidths;
                for (numGroupingRegions = 16 - Long.numberOfLeadingZeros(groupingWidths) / 4; numGroupingRegions > 1 && (groupingWidths & 0xFL) == 0L; --numGroupingRegions) {
                    if (item.sawDecimalPoint) {
                        if (!DEBUGGING) continue block17;
                        System.out.println("-> rejected due to decimal point after grouping");
                        continue block17;
                    }
                    groupingWidths >>>= 4;
                }
                if (grouping1 > 0 && numGroupingRegions > 1) {
                    if ((groupingWidths & 0xFL) != (long)grouping1) {
                        if (!DEBUGGING) continue;
                        System.out.println("-> rejected due to first grouping violation");
                        continue;
                    }
                    if ((groupingWidths >>> (numGroupingRegions - 1) * 4 & 0xFL) > (long)grouping2) {
                        if (!DEBUGGING) continue;
                        System.out.println("-> rejected due to final grouping violation");
                        continue;
                    }
                    for (int j = 1; j < numGroupingRegions - 1; ++j) {
                        if ((groupingWidths >>> j * 4 & 0xFL) == (long)grouping2) continue;
                        if (!DEBUGGING) continue block17;
                        System.out.println("-> rejected due to inner grouping violation");
                        continue block17;
                    }
                }
            }
            if (properties.getDecimalPatternMatchRequired() && item.sawDecimalPoint != (properties.getDecimalSeparatorAlwaysShown() || properties.getMaximumFractionDigits() != 0)) {
                if (!DEBUGGING) continue;
                System.out.println("-> rejected due to decimal point violation");
                continue;
            }
            if (parseCurrency && !item.sawCurrency) {
                if (!DEBUGGING) continue;
                System.out.println("-> rejected due to lack of currency");
                continue;
            }
            if (best == null) {
                best = item;
                continue;
            }
            if (item.score > best.score) {
                best = item;
                continue;
            }
            if (item.trailingCount >= best.trailingCount) continue;
            best = item;
        }
        if (DEBUGGING) {
            System.out.println("- - - - - - - - - -");
        }
        if (best != null) {
            ppos.setIndex(offset - best.trailingCount);
            return best;
        }
        ppos.setErrorIndex(offset);
        return null;
    }

    private static void acceptWhitespace(int cp, StateName nextName, ParserState state2, StateItem item) {
        if (UNISET_WHITESPACE.contains(cp)) {
            state2.getNext().copyFrom(item, nextName, cp);
        }
    }

    private static void acceptBidi(int cp, StateName nextName, ParserState state2, StateItem item) {
        if (UNISET_BIDI.contains(cp)) {
            state2.getNext().copyFrom(item, nextName, cp);
        }
    }

    private static void acceptPadding(int cp, StateName nextName, ParserState state2, StateItem item) {
        String padding = state2.properties.getPadString();
        if (padding == null || padding.length() == 0) {
            return;
        }
        int referenceCp = Character.codePointAt(padding, 0);
        if (cp == referenceCp) {
            state2.getNext().copyFrom(item, nextName, cp);
        }
    }

    private static void acceptIntegerDigit(int cp, StateName nextName, ParserState state2, StateItem item) {
        Parse.acceptDigitHelper(cp, nextName, state2, item, DigitType.INTEGER);
    }

    private static void acceptFractionDigit(int cp, StateName nextName, ParserState state2, StateItem item) {
        Parse.acceptDigitHelper(cp, nextName, state2, item, DigitType.FRACTION);
    }

    private static void acceptExponentDigit(int cp, StateName nextName, ParserState state2, StateItem item) {
        Parse.acceptDigitHelper(cp, nextName, state2, item, DigitType.EXPONENT);
    }

    private static void acceptDigitHelper(int cp, StateName nextName, ParserState state2, StateItem item, DigitType type) {
        int digit = UCharacter.digit(cp, 10);
        StateItem next = null;
        if (digit >= 0) {
            next = state2.getNext().copyFrom(item, nextName, -1);
        }
        if (digit < 0 && (state2.mode == ParseMode.LENIENT || state2.mode == ParseMode.STRICT)) {
            if (state2.digitTrie == null) {
                for (int d = 0; d < 10; d = (int)((byte)(d + 1))) {
                    int referenceCp = Character.codePointAt(state2.symbols.getDigitStringsLocal()[d], 0);
                    if (cp != referenceCp) continue;
                    digit = d;
                    next = state2.getNext().copyFrom(item, nextName, -1);
                }
            } else {
                Parse.acceptDigitTrie(cp, nextName, state2, item, type);
            }
        }
        Parse.recordDigit(next, (byte)digit, type);
    }

    private static void recordDigit(StateItem next, byte digit, DigitType type) {
        if (next == null) {
            return;
        }
        next.appendDigit(digit, type);
        if (type == DigitType.INTEGER && (next.groupingWidths & 0xFL) < 15L) {
            ++next.groupingWidths;
        }
    }

    private static void acceptMinusOrPlusSign(int cp, StateName nextName, ParserState state2, StateItem item, boolean exponent) {
        Parse.acceptMinusSign(cp, nextName, null, state2, item, exponent);
        Parse.acceptPlusSign(cp, nextName, null, state2, item, exponent);
    }

    private static long acceptMinusSign(int cp, StateName returnTo1, StateName returnTo2, ParserState state2, StateItem item, boolean exponent) {
        if (UNISET_MINUS.contains(cp)) {
            StateItem next = state2.getNext().copyFrom(item, returnTo1, -1);
            next.returnTo1 = returnTo2;
            if (exponent) {
                next.sawNegativeExponent = true;
            } else {
                next.sawNegative = true;
            }
            return 1L << state2.lastInsertedIndex();
        }
        return 0L;
    }

    private static long acceptPlusSign(int cp, StateName returnTo1, StateName returnTo2, ParserState state2, StateItem item, boolean exponent) {
        if (UNISET_PLUS.contains(cp)) {
            StateItem next = state2.getNext().copyFrom(item, returnTo1, -1);
            next.returnTo1 = returnTo2;
            return 1L << state2.lastInsertedIndex();
        }
        return 0L;
    }

    private static void acceptGrouping(int cp, StateName nextName, ParserState state2, StateItem item) {
        if (item.groupingCp == -1) {
            SeparatorType cpType = SeparatorType.fromCp(cp, state2.mode);
            if (cp != state2.groupingCp1 && cp != state2.groupingCp2) {
                if (cpType == SeparatorType.UNKNOWN) {
                    return;
                }
                if (state2.groupingMode == GroupingMode.RESTRICTED) {
                    if (cpType != state2.groupingType1 || cpType != state2.groupingType2) {
                        return;
                    }
                } else {
                    if (cpType == SeparatorType.COMMA_LIKE && (state2.decimalType1 == SeparatorType.COMMA_LIKE || state2.decimalType2 == SeparatorType.COMMA_LIKE)) {
                        return;
                    }
                    if (cpType == SeparatorType.PERIOD_LIKE && (state2.decimalType1 == SeparatorType.PERIOD_LIKE || state2.decimalType2 == SeparatorType.PERIOD_LIKE)) {
                        return;
                    }
                }
            }
            StateItem next = state2.getNext().copyFrom(item, nextName, cp);
            next.groupingCp = cp;
            next.groupingWidths <<= 4;
        } else if (cp == item.groupingCp) {
            StateItem next = state2.getNext().copyFrom(item, nextName, cp);
            next.groupingWidths <<= 4;
        }
    }

    private static void acceptDecimalPoint(int cp, StateName nextName, ParserState state2, StateItem item) {
        if (cp == item.groupingCp) {
            return;
        }
        SeparatorType cpType = SeparatorType.fromCp(cp, state2.mode);
        if (cpType != state2.decimalType1 && cpType != state2.decimalType2) {
            return;
        }
        if ((cpType == SeparatorType.OTHER_GROUPING || cpType == SeparatorType.UNKNOWN) && cp != state2.decimalCp1 && cp != state2.decimalCp2) {
            return;
        }
        StateItem next = state2.getNext().copyFrom(item, nextName, -1);
        next.sawDecimalPoint = true;
    }

    private static void acceptNan(int cp, StateName nextName, ParserState state2, StateItem item) {
        String nan = state2.symbols.getNaN();
        long added = Parse.acceptString(cp, nextName, null, state2, item, nan, 0, false);
        int i = Long.numberOfTrailingZeros(added);
        while (1L << i <= added) {
            if ((1L << i & added) != 0L) {
                state2.getItem((int)i).sawNaN = true;
            }
            ++i;
        }
    }

    private static void acceptInfinity(int cp, StateName nextName, ParserState state2, StateItem item) {
        String inf = state2.symbols.getInfinity();
        long added = Parse.acceptString(cp, nextName, null, state2, item, inf, 0, false);
        int i = Long.numberOfTrailingZeros(added);
        while (1L << i <= added) {
            if ((1L << i & added) != 0L) {
                state2.getItem((int)i).sawInfinity = true;
            }
            ++i;
        }
    }

    private static void acceptExponentSeparator(int cp, StateName nextName, ParserState state2, StateItem item) {
        String exp = state2.symbols.getExponentSeparator();
        Parse.acceptString(cp, nextName, null, state2, item, exp, 0, true);
    }

    private static void acceptPrefix(int cp, StateName nextName, ParserState state2, StateItem item) {
        for (AffixHolder holder : state2.affixHolders) {
            Parse.acceptAffixHolder(cp, nextName, state2, item, holder, true);
        }
    }

    private static void acceptSuffix(int cp, StateName nextName, ParserState state2, StateItem item) {
        if (item.affix != null) {
            Parse.acceptAffixHolder(cp, nextName, state2, item, item.affix, false);
        } else {
            for (AffixHolder holder : state2.affixHolders) {
                Parse.acceptAffixHolder(cp, nextName, state2, item, holder, false);
            }
        }
    }

    private static void acceptAffixHolder(int cp, StateName nextName, ParserState state2, StateItem item, AffixHolder holder, boolean prefix) {
        if (holder == null) {
            return;
        }
        String str = prefix ? holder.p : holder.s;
        long added = holder.strings ? Parse.acceptString(cp, nextName, null, state2, item, str, 0, false) : Parse.acceptAffixPattern(cp, nextName, state2, item, str, AffixUtils.nextToken(0L, str));
        int i = Long.numberOfTrailingZeros(added);
        while (1L << i <= added) {
            if ((1L << i & added) != 0L) {
                StateItem next = state2.getItem(i);
                next.affix = holder;
                if (prefix) {
                    next.sawPrefix = true;
                }
                if (!prefix) {
                    next.sawSuffix = true;
                }
                if (holder.negative) {
                    next.sawNegative = true;
                }
                next.score += 10;
                if (!holder.negative) {
                    ++next.score;
                }
                if (!next.sawPrefix && holder.p.isEmpty()) {
                    next.score += 5;
                }
                if (!next.sawSuffix && holder.s.isEmpty()) {
                    next.score += 5;
                }
            }
            ++i;
        }
    }

    private static long acceptStringOffset(int cp, ParserState state2, StateItem item) {
        return Parse.acceptString(cp, item.returnTo1, item.returnTo2, state2, item, item.currentString, item.currentOffset, item.currentTrailing);
    }

    private static long acceptString(int cp, StateName ret1, StateName ret2, ParserState state2, StateItem item, CharSequence str, int offset, boolean trailing) {
        if (str == null || str.length() == 0) {
            return 0L;
        }
        return Parse.acceptStringOrAffixPatternWithIgnorables(cp, ret1, ret2, state2, item, str, offset, trailing, true);
    }

    private static long acceptStringNonIgnorable(int cp, StateName ret1, StateName ret2, ParserState state2, StateItem item, CharSequence str, boolean trailing, int referenceCp, long firstOffsetOrTag, long nextOffsetOrTag) {
        long added = 0L;
        int firstOffset = (int)firstOffsetOrTag;
        int nextOffset = (int)nextOffsetOrTag;
        if (Parse.codePointEquals(referenceCp, cp, state2)) {
            if (firstOffset < str.length()) {
                added |= Parse.acceptStringHelper(cp, ret1, ret2, state2, item, str, firstOffset, trailing);
            }
            if (nextOffset >= str.length()) {
                added |= Parse.acceptStringHelper(cp, ret1, ret2, state2, item, str, nextOffset, trailing);
            }
            return added;
        }
        return 0L;
    }

    private static long acceptStringHelper(int cp, StateName returnTo1, StateName returnTo2, ParserState state2, StateItem item, CharSequence str, int newOffset, boolean trailing) {
        StateItem next = state2.getNext().copyFrom(item, null, cp);
        ++next.score;
        if (newOffset < str.length()) {
            next.name = StateName.INSIDE_STRING;
            next.returnTo1 = returnTo1;
            next.returnTo2 = returnTo2;
            next.currentString = str;
            next.currentOffset = newOffset;
            next.currentTrailing = trailing;
        } else {
            next.name = returnTo1;
            if (!trailing) {
                next.trailingCount = 0;
            }
            next.returnTo1 = returnTo2;
            next.returnTo2 = null;
        }
        return 1L << state2.lastInsertedIndex();
    }

    private static long acceptAffixPatternOffset(int cp, ParserState state2, StateItem item) {
        return Parse.acceptAffixPattern(cp, item.returnTo1, state2, item, item.currentAffixPattern, item.currentStepwiseParserTag);
    }

    private static long acceptAffixPattern(int cp, StateName ret1, ParserState state2, StateItem item, CharSequence str, long tag) {
        if (str == null || str.length() == 0) {
            return 0L;
        }
        return Parse.acceptStringOrAffixPatternWithIgnorables(cp, ret1, null, state2, item, str, tag, false, false);
    }

    private static long acceptAffixPatternNonIgnorable(int cp, StateName returnTo, ParserState state2, StateItem item, CharSequence str, int typeOrCp, long firstTag, long nextTag) {
        boolean resolvedCurrency;
        boolean resolvedPlusSign;
        boolean resolvedMinusSign;
        String resolvedStr;
        int resolvedCp;
        block31: {
            block30: {
                resolvedCp = -1;
                resolvedStr = null;
                resolvedMinusSign = false;
                resolvedPlusSign = false;
                resolvedCurrency = false;
                if (typeOrCp >= 0) break block30;
                switch (typeOrCp) {
                    case -1: {
                        resolvedMinusSign = true;
                        break block31;
                    }
                    case -2: {
                        resolvedPlusSign = true;
                        break block31;
                    }
                    case -3: {
                        resolvedStr = state2.symbols.getPercentString();
                        if (resolvedStr.length() != 1 || resolvedStr.charAt(0) != '%') {
                            resolvedCp = 37;
                        }
                        break block31;
                    }
                    case -4: {
                        resolvedStr = state2.symbols.getPerMillString();
                        if (resolvedStr.length() != 1 || resolvedStr.charAt(0) != '\u2030') {
                            resolvedCp = 8240;
                        }
                        break block31;
                    }
                    case -15: 
                    case -9: 
                    case -8: 
                    case -7: 
                    case -6: 
                    case -5: {
                        resolvedCurrency = true;
                        break block31;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            resolvedCp = typeOrCp;
        }
        long added = 0L;
        if (resolvedCp >= 0 && Parse.codePointEquals(cp, resolvedCp, state2)) {
            if (firstTag >= 0L) {
                added |= Parse.acceptAffixPatternHelper(cp, returnTo, state2, item, str, firstTag);
            }
            if (nextTag < 0L) {
                added |= Parse.acceptAffixPatternHelper(cp, returnTo, state2, item, str, nextTag);
            }
        }
        if (resolvedMinusSign) {
            if (firstTag >= 0L) {
                added |= Parse.acceptMinusSign(cp, StateName.INSIDE_AFFIX_PATTERN, returnTo, state2, item, false);
            }
            if (nextTag < 0L) {
                added |= Parse.acceptMinusSign(cp, returnTo, null, state2, item, false);
            }
            if (added == 0L) {
                String mss = state2.symbols.getMinusSignString();
                int mssCp = Character.codePointAt(mss, 0);
                if (mss.length() != Character.charCount(mssCp) || !UNISET_MINUS.contains(mssCp)) {
                    resolvedStr = mss;
                }
            }
        }
        if (resolvedPlusSign) {
            if (firstTag >= 0L) {
                added |= Parse.acceptPlusSign(cp, StateName.INSIDE_AFFIX_PATTERN, returnTo, state2, item, false);
            }
            if (nextTag < 0L) {
                added |= Parse.acceptPlusSign(cp, returnTo, null, state2, item, false);
            }
            if (added == 0L) {
                String pss = state2.symbols.getPlusSignString();
                int pssCp = Character.codePointAt(pss, 0);
                if (pss.length() != Character.charCount(pssCp) || !UNISET_MINUS.contains(pssCp)) {
                    resolvedStr = pss;
                }
            }
        }
        if (resolvedStr != null) {
            if (firstTag >= 0L) {
                added |= Parse.acceptString(cp, StateName.INSIDE_AFFIX_PATTERN, returnTo, state2, item, resolvedStr, 0, false);
            }
            if (nextTag < 0L) {
                added |= Parse.acceptString(cp, returnTo, null, state2, item, resolvedStr, 0, false);
            }
        }
        if (resolvedCurrency) {
            if (firstTag >= 0L) {
                added |= Parse.acceptCurrency(cp, StateName.INSIDE_AFFIX_PATTERN, returnTo, state2, item);
            }
            if (nextTag < 0L) {
                added |= Parse.acceptCurrency(cp, returnTo, null, state2, item);
            }
        }
        int i = Long.numberOfTrailingZeros(added);
        while (1L << i <= added) {
            if ((1L << i & added) != 0L) {
                state2.getItem((int)i).currentAffixPattern = str;
                state2.getItem((int)i).currentStepwiseParserTag = firstTag;
            }
            ++i;
        }
        return added;
    }

    private static long acceptAffixPatternHelper(int cp, StateName returnTo, ParserState state2, StateItem item, CharSequence str, long newTag) {
        StateItem next = state2.getNext().copyFrom(item, null, cp);
        ++next.score;
        if (newTag >= 0L) {
            next.name = StateName.INSIDE_AFFIX_PATTERN;
            next.returnTo1 = returnTo;
            next.currentAffixPattern = str;
            next.currentStepwiseParserTag = newTag;
        } else {
            next.name = returnTo;
            next.trailingCount = 0;
            next.returnTo1 = null;
        }
        return 1L << state2.lastInsertedIndex();
    }

    private static long acceptStringOrAffixPatternWithIgnorables(int cp, StateName ret1, StateName ret2, ParserState state2, StateItem item, CharSequence str, long offsetOrTag, boolean trailing, boolean isString) {
        int nextTypeOrCp;
        int typeOrCp;
        int n = typeOrCp = isString ? Character.codePointAt(str, (int)offsetOrTag) : AffixUtils.getTypeOrCp(offsetOrTag);
        if (Parse.isIgnorable(typeOrCp, state2)) {
            long prevOffsetOrTag;
            nextTypeOrCp = typeOrCp;
            long nextOffsetOrTag = offsetOrTag;
            long firstOffsetOrTag = 0L;
            do {
                prevOffsetOrTag = nextOffsetOrTag;
                long l = nextOffsetOrTag = isString ? nextOffsetOrTag + (long)Character.charCount(nextTypeOrCp) : AffixUtils.nextToken(nextOffsetOrTag, str);
                if (firstOffsetOrTag == 0L) {
                    firstOffsetOrTag = nextOffsetOrTag;
                }
                if (!(isString ? nextOffsetOrTag >= (long)str.length() : nextOffsetOrTag < 0L)) continue;
                nextTypeOrCp = Integer.MIN_VALUE;
                break;
            } while (Parse.isIgnorable(nextTypeOrCp = isString ? Character.codePointAt(str, (int)nextOffsetOrTag) : AffixUtils.getTypeOrCp(nextOffsetOrTag), state2));
            if (nextTypeOrCp == Integer.MIN_VALUE) {
                if (Parse.codePointEquals(cp, typeOrCp, state2)) {
                    long added = 0L;
                    added |= isString ? Parse.acceptStringHelper(cp, ret1, ret2, state2, item, str, (int)firstOffsetOrTag, trailing) : Parse.acceptAffixPatternHelper(cp, ret1, state2, item, str, firstOffsetOrTag);
                    if (firstOffsetOrTag != nextOffsetOrTag) {
                        added |= isString ? Parse.acceptStringHelper(cp, ret1, ret2, state2, item, str, (int)nextOffsetOrTag, trailing) : Parse.acceptAffixPatternHelper(cp, ret1, state2, item, str, nextOffsetOrTag);
                    }
                    return added;
                }
                return 0L;
            }
            if (Parse.isIgnorable(cp, state2)) {
                return isString ? Parse.acceptStringHelper(cp, ret1, ret2, state2, item, str, (int)prevOffsetOrTag, trailing) : Parse.acceptAffixPatternHelper(cp, ret1, state2, item, str, prevOffsetOrTag);
            }
            assert (nextTypeOrCp != Integer.MIN_VALUE);
            typeOrCp = nextTypeOrCp;
            offsetOrTag = nextOffsetOrTag;
        }
        assert (!Parse.isIgnorable(typeOrCp, state2));
        nextTypeOrCp = typeOrCp;
        long nextOffsetOrTag = offsetOrTag;
        long firstOffsetOrTag = 0L;
        do {
            long l = nextOffsetOrTag = isString ? nextOffsetOrTag + (long)Character.charCount(nextTypeOrCp) : AffixUtils.nextToken(nextOffsetOrTag, str);
            if (firstOffsetOrTag == 0L) {
                firstOffsetOrTag = nextOffsetOrTag;
            }
            if (!(isString ? nextOffsetOrTag >= (long)str.length() : nextOffsetOrTag < 0L)) continue;
            nextTypeOrCp = -1;
            break;
        } while (Parse.isIgnorable(nextTypeOrCp = isString ? Character.codePointAt(str, (int)nextOffsetOrTag) : AffixUtils.getTypeOrCp(nextOffsetOrTag), state2));
        return isString ? Parse.acceptStringNonIgnorable(cp, ret1, ret2, state2, item, str, trailing, typeOrCp, firstOffsetOrTag, nextOffsetOrTag) : Parse.acceptAffixPatternNonIgnorable(cp, ret1, state2, item, str, typeOrCp, firstOffsetOrTag, nextOffsetOrTag);
    }

    private static void acceptCurrency(int cp, StateName nextName, ParserState state2, StateItem item) {
        Parse.acceptCurrency(cp, nextName, null, state2, item);
    }

    private static long acceptCurrency(int cp, StateName returnTo1, StateName returnTo2, ParserState state2, StateItem item) {
        String str2;
        String str1;
        if (item.sawCurrency) {
            return 0L;
        }
        long added = 0L;
        Currency currency = state2.properties.getCurrency();
        if (currency != null) {
            str1 = currency.getName(state2.symbols.getULocale(), 0, null);
            str2 = currency.getCurrencyCode();
        } else {
            currency = state2.symbols.getCurrency();
            str1 = state2.symbols.getCurrencySymbol();
            str2 = state2.symbols.getInternationalCurrencySymbol();
        }
        added |= Parse.acceptString(cp, returnTo1, returnTo2, state2, item, str1, 0, false);
        int i = Long.numberOfTrailingZeros(added |= Parse.acceptString(cp, returnTo1, returnTo2, state2, item, str2, 0, false));
        while (1L << i <= added) {
            if ((1L << i & added) != 0L) {
                state2.getItem((int)i).sawCurrency = true;
                state2.getItem((int)i).isoCode = str2;
            }
            ++i;
        }
        if (state2.parseCurrency) {
            ULocale uloc = state2.symbols.getULocale();
            TextTrieMap.ParseState trie1 = Currency.openParseState(uloc, cp, 1);
            TextTrieMap.ParseState trie2 = Currency.openParseState(uloc, cp, 0);
            added |= Parse.acceptCurrencyHelper(cp, returnTo1, returnTo2, state2, item, trie1);
            added |= Parse.acceptCurrencyHelper(cp, returnTo1, returnTo2, state2, item, trie2);
        }
        return added;
    }

    private static void acceptCurrencyOffset(int cp, ParserState state2, StateItem item) {
        Parse.acceptCurrencyHelper(cp, item.returnTo1, item.returnTo2, state2, item, item.currentCurrencyTrieState);
    }

    private static long acceptCurrencyHelper(int cp, StateName returnTo1, StateName returnTo2, ParserState state2, StateItem item, TextTrieMap.ParseState trieState) {
        StateItem next;
        if (trieState == null) {
            return 0L;
        }
        trieState.accept(cp);
        long added = 0L;
        Iterator currentMatches = trieState.getCurrentMatches();
        if (currentMatches != null) {
            next = state2.getNext().copyFrom(item, returnTo1, -1);
            next.returnTo1 = returnTo2;
            next.returnTo2 = null;
            next.sawCurrency = true;
            next.isoCode = ((Currency.CurrencyStringInfo)currentMatches.next()).getISOCode();
            added |= 1L << state2.lastInsertedIndex();
        }
        if (!trieState.atEnd()) {
            next = state2.getNext().copyFrom(item, StateName.INSIDE_CURRENCY, -1);
            next.returnTo1 = returnTo1;
            next.returnTo2 = returnTo2;
            next.currentCurrencyTrieState = trieState;
            added |= 1L << state2.lastInsertedIndex();
        }
        return added;
    }

    private static long acceptDigitTrie(int cp, StateName nextName, ParserState state2, StateItem item, DigitType type) {
        assert (state2.digitTrie != null);
        TextTrieMap.ParseState trieState = state2.digitTrie.openParseState(cp);
        if (trieState == null) {
            return 0L;
        }
        return Parse.acceptDigitTrieHelper(cp, nextName, state2, item, type, trieState);
    }

    private static void acceptDigitTrieOffset(int cp, ParserState state2, StateItem item) {
        Parse.acceptDigitTrieHelper(cp, item.returnTo1, state2, item, item.currentDigitType, item.currentDigitTrieState);
    }

    private static long acceptDigitTrieHelper(int cp, StateName returnTo1, ParserState state2, StateItem item, DigitType type, TextTrieMap.ParseState trieState) {
        if (trieState == null) {
            return 0L;
        }
        trieState.accept(cp);
        long added = 0L;
        Iterator currentMatches = trieState.getCurrentMatches();
        if (currentMatches != null) {
            byte digit = (Byte)currentMatches.next();
            StateItem next = state2.getNext().copyFrom(item, returnTo1, -1);
            next.returnTo1 = null;
            Parse.recordDigit(next, digit, type);
            added |= 1L << state2.lastInsertedIndex();
        }
        if (!trieState.atEnd()) {
            StateItem next = state2.getNext().copyFrom(item, StateName.INSIDE_DIGIT, -1);
            next.returnTo1 = returnTo1;
            next.currentDigitTrieState = trieState;
            next.currentDigitType = type;
            added |= 1L << state2.lastInsertedIndex();
        }
        return added;
    }

    private static boolean codePointEquals(int cp1, int cp2, ParserState state2) {
        if (!state2.caseSensitive) {
            cp1 = UCharacter.foldCase(cp1, true);
            cp2 = UCharacter.foldCase(cp2, true);
        }
        return cp1 == cp2;
    }

    private static boolean isIgnorable(int cp, ParserState state2) {
        if (cp < 0) {
            return false;
        }
        if (UNISET_BIDI.contains(cp)) {
            return true;
        }
        return state2.mode == ParseMode.LENIENT && UNISET_WHITESPACE.contains(cp);
    }

    private static class CurrencyAffixPatterns {
        private final Set<AffixHolder> set = new HashSet<AffixHolder>();
        private static final ConcurrentHashMap<ULocale, CurrencyAffixPatterns> currencyAffixPatterns = new ConcurrentHashMap();
        private static final ThreadLocal<DecimalFormatProperties> threadLocalProperties = new ThreadLocal<DecimalFormatProperties>(){

            @Override
            protected DecimalFormatProperties initialValue() {
                return new DecimalFormatProperties();
            }
        };

        static void addToState(ULocale uloc, ParserState state2) {
            CurrencyAffixPatterns value = currencyAffixPatterns.get(uloc);
            if (value == null) {
                CurrencyAffixPatterns newValue = new CurrencyAffixPatterns(uloc);
                currencyAffixPatterns.putIfAbsent(uloc, newValue);
                value = currencyAffixPatterns.get(uloc);
            }
            state2.affixHolders.addAll(value.set);
        }

        private CurrencyAffixPatterns(ULocale uloc) {
            String pattern = NumberFormat.getPatternForStyle(uloc, 1);
            this.addPattern(pattern);
            CurrencyPluralInfo pluralInfo = CurrencyPluralInfo.getInstance(uloc);
            for (StandardPlural plural : StandardPlural.VALUES) {
                pattern = pluralInfo.getCurrencyPluralPattern(plural.getKeyword());
                this.addPattern(pattern);
            }
        }

        private void addPattern(String pattern) {
            DecimalFormatProperties properties = threadLocalProperties.get();
            try {
                PatternStringParser.parseToExistingProperties(pattern, properties);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.set.add(AffixHolder.fromPropertiesPositivePattern(properties));
            this.set.add(AffixHolder.fromPropertiesNegativePattern(properties));
        }
    }

    private static class AffixHolder {
        final String p;
        final String s;
        final boolean strings;
        final boolean negative;
        static final AffixHolder EMPTY_POSITIVE = new AffixHolder("", "", true, false);
        static final AffixHolder EMPTY_NEGATIVE = new AffixHolder("", "", true, true);

        static void addToState(ParserState state2, DecimalFormatProperties properties) {
            AffixHolder pp = AffixHolder.fromPropertiesPositivePattern(properties);
            AffixHolder np = AffixHolder.fromPropertiesNegativePattern(properties);
            AffixHolder ps = AffixHolder.fromPropertiesPositiveString(properties);
            AffixHolder ns = AffixHolder.fromPropertiesNegativeString(properties);
            if (pp != null) {
                state2.affixHolders.add(pp);
            }
            if (ps != null) {
                state2.affixHolders.add(ps);
            }
            if (np != null) {
                state2.affixHolders.add(np);
            }
            if (ns != null) {
                state2.affixHolders.add(ns);
            }
        }

        static AffixHolder fromPropertiesPositivePattern(DecimalFormatProperties properties) {
            String ppp = properties.getPositivePrefixPattern();
            String psp = properties.getPositiveSuffixPattern();
            if (properties.getSignAlwaysShown()) {
                boolean foundSign = false;
                String npp = properties.getNegativePrefixPattern();
                String nsp = properties.getNegativeSuffixPattern();
                if (AffixUtils.containsType(npp, -1)) {
                    foundSign = true;
                    ppp = AffixUtils.replaceType(npp, -1, '+');
                }
                if (AffixUtils.containsType(nsp, -1)) {
                    foundSign = true;
                    psp = AffixUtils.replaceType(nsp, -1, '+');
                }
                if (!foundSign) {
                    ppp = "+" + ppp;
                }
            }
            return AffixHolder.getInstance(ppp, psp, false, false);
        }

        static AffixHolder fromPropertiesNegativePattern(DecimalFormatProperties properties) {
            String npp = properties.getNegativePrefixPattern();
            String nsp = properties.getNegativeSuffixPattern();
            if (npp == null && nsp == null) {
                npp = properties.getPositivePrefixPattern();
                nsp = properties.getPositiveSuffixPattern();
                npp = npp == null ? "-" : "-" + npp;
            }
            return AffixHolder.getInstance(npp, nsp, false, true);
        }

        static AffixHolder fromPropertiesPositiveString(DecimalFormatProperties properties) {
            String pp = properties.getPositivePrefix();
            String ps = properties.getPositiveSuffix();
            if (pp == null && ps == null) {
                return null;
            }
            return AffixHolder.getInstance(pp, ps, true, false);
        }

        static AffixHolder fromPropertiesNegativeString(DecimalFormatProperties properties) {
            String np = properties.getNegativePrefix();
            String ns = properties.getNegativeSuffix();
            if (np == null && ns == null) {
                return null;
            }
            return AffixHolder.getInstance(np, ns, true, true);
        }

        static AffixHolder getInstance(String p, String s, boolean strings, boolean negative) {
            if (p == null && s == null) {
                return negative ? EMPTY_NEGATIVE : EMPTY_POSITIVE;
            }
            if (p == null) {
                p = "";
            }
            if (s == null) {
                s = "";
            }
            if (p.length() == 0 && s.length() == 0) {
                return negative ? EMPTY_NEGATIVE : EMPTY_POSITIVE;
            }
            return new AffixHolder(p, s, strings, negative);
        }

        AffixHolder(String pp, String sp, boolean strings, boolean negative) {
            this.p = pp;
            this.s = sp;
            this.strings = strings;
            this.negative = negative;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof AffixHolder)) {
                return false;
            }
            AffixHolder _other = (AffixHolder)other;
            if (!this.p.equals(_other.p)) {
                return false;
            }
            if (!this.s.equals(_other.s)) {
                return false;
            }
            if (this.strings != _other.strings) {
                return false;
            }
            return this.negative == _other.negative;
        }

        public int hashCode() {
            return this.p.hashCode() ^ this.s.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append(this.p);
            sb.append("|");
            sb.append(this.s);
            sb.append("|");
            sb.append(this.strings ? (char)'S' : 'P');
            sb.append("}");
            return sb.toString();
        }
    }

    private static class ParserState {
        StateItem[] items = new StateItem[16];
        StateItem[] prevItems = new StateItem[16];
        int length;
        int prevLength;
        DecimalFormatProperties properties;
        DecimalFormatSymbols symbols;
        ParseMode mode;
        boolean caseSensitive;
        boolean parseCurrency;
        GroupingMode groupingMode;
        int decimalCp1;
        int decimalCp2;
        int groupingCp1;
        int groupingCp2;
        SeparatorType decimalType1;
        SeparatorType decimalType2;
        SeparatorType groupingType1;
        SeparatorType groupingType2;
        TextTrieMap<Byte> digitTrie;
        Set<AffixHolder> affixHolders = new HashSet<AffixHolder>();

        ParserState() {
            for (int i = 0; i < this.items.length; ++i) {
                this.items[i] = new StateItem((char)(65 + i));
                this.prevItems[i] = new StateItem((char)(65 + i));
            }
        }

        ParserState clear() {
            this.length = 0;
            this.prevLength = 0;
            this.digitTrie = null;
            this.affixHolders.clear();
            return this;
        }

        void swap() {
            StateItem[] temp = this.prevItems;
            this.prevItems = this.items;
            this.items = temp;
            this.prevLength = this.length;
            this.length = 0;
        }

        void swapBack() {
            StateItem[] temp = this.prevItems;
            this.prevItems = this.items;
            this.items = temp;
            this.length = this.prevLength;
            this.prevLength = 0;
        }

        StateItem getNext() {
            if (this.length >= this.items.length) {
                this.length = this.items.length - 1;
            }
            StateItem item = this.items[this.length];
            ++this.length;
            return item;
        }

        public int lastInsertedIndex() {
            assert (this.length > 0);
            return this.length - 1;
        }

        public StateItem getItem(int i) {
            assert (i >= 0 && i < this.length);
            return this.items[i];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<ParseState mode:");
            sb.append((Object)this.mode);
            sb.append(" caseSensitive:");
            sb.append(this.caseSensitive);
            sb.append(" parseCurrency:");
            sb.append(this.parseCurrency);
            sb.append(" groupingMode:");
            sb.append((Object)this.groupingMode);
            sb.append(" decimalCps:");
            sb.append((char)this.decimalCp1);
            sb.append((char)this.decimalCp2);
            sb.append(" groupingCps:");
            sb.append((char)this.groupingCp1);
            sb.append((char)this.groupingCp2);
            sb.append(" affixes:");
            sb.append(this.affixHolders);
            sb.append(">");
            return sb.toString();
        }
    }

    private static class StateItem {
        StateName name;
        int trailingCount;
        int score;
        DecimalQuantity_DualStorageBCD fq = new DecimalQuantity_DualStorageBCD();
        int numDigits;
        int trailingZeros;
        int exponent;
        int groupingCp;
        long groupingWidths;
        String isoCode;
        boolean sawNegative;
        boolean sawNegativeExponent;
        boolean sawCurrency;
        boolean sawNaN;
        boolean sawInfinity;
        AffixHolder affix;
        boolean sawPrefix;
        boolean sawSuffix;
        boolean sawDecimalPoint;
        boolean sawExponentDigit;
        StateName returnTo1;
        StateName returnTo2;
        CharSequence currentString;
        int currentOffset;
        boolean currentTrailing;
        CharSequence currentAffixPattern;
        long currentStepwiseParserTag;
        TextTrieMap.ParseState currentCurrencyTrieState;
        TextTrieMap.ParseState currentDigitTrieState;
        DigitType currentDigitType;
        final char id;
        String path;

        StateItem(char _id) {
            this.id = _id;
        }

        StateItem clear() {
            this.name = StateName.BEFORE_PREFIX;
            this.trailingCount = 0;
            this.score = 0;
            this.fq.clear();
            this.numDigits = 0;
            this.trailingZeros = 0;
            this.exponent = 0;
            this.groupingCp = -1;
            this.groupingWidths = 0L;
            this.isoCode = null;
            this.sawNegative = false;
            this.sawNegativeExponent = false;
            this.sawCurrency = false;
            this.sawNaN = false;
            this.sawInfinity = false;
            this.affix = null;
            this.sawPrefix = false;
            this.sawSuffix = false;
            this.sawDecimalPoint = false;
            this.sawExponentDigit = false;
            this.returnTo1 = null;
            this.returnTo2 = null;
            this.currentString = null;
            this.currentOffset = 0;
            this.currentTrailing = false;
            this.currentAffixPattern = null;
            this.currentStepwiseParserTag = 0L;
            this.currentCurrencyTrieState = null;
            this.currentDigitTrieState = null;
            this.currentDigitType = null;
            this.path = "";
            return this;
        }

        StateItem copyFrom(StateItem other, StateName newName, int trailing) {
            this.name = newName;
            this.score = other.score;
            this.trailingCount = trailing < 0 ? 0 : other.trailingCount + Character.charCount(trailing);
            this.fq.copyFrom(other.fq);
            this.numDigits = other.numDigits;
            this.trailingZeros = other.trailingZeros;
            this.exponent = other.exponent;
            this.groupingCp = other.groupingCp;
            this.groupingWidths = other.groupingWidths;
            this.isoCode = other.isoCode;
            this.sawNegative = other.sawNegative;
            this.sawNegativeExponent = other.sawNegativeExponent;
            this.sawCurrency = other.sawCurrency;
            this.sawNaN = other.sawNaN;
            this.sawInfinity = other.sawInfinity;
            this.affix = other.affix;
            this.sawPrefix = other.sawPrefix;
            this.sawSuffix = other.sawSuffix;
            this.sawDecimalPoint = other.sawDecimalPoint;
            this.sawExponentDigit = other.sawExponentDigit;
            this.returnTo1 = other.returnTo1;
            this.returnTo2 = other.returnTo2;
            this.currentString = other.currentString;
            this.currentOffset = other.currentOffset;
            this.currentTrailing = other.currentTrailing;
            this.currentAffixPattern = other.currentAffixPattern;
            this.currentStepwiseParserTag = other.currentStepwiseParserTag;
            this.currentCurrencyTrieState = other.currentCurrencyTrieState;
            this.currentDigitTrieState = other.currentDigitTrieState;
            this.currentDigitType = other.currentDigitType;
            if (DEBUGGING) {
                this.path = other.path + other.id;
            }
            return this;
        }

        void appendDigit(byte digit, DigitType type) {
            if (type == DigitType.EXPONENT) {
                this.sawExponentDigit = true;
                int newExponent = this.exponent * 10 + digit;
                this.exponent = newExponent < this.exponent ? Integer.MAX_VALUE : newExponent;
            } else {
                ++this.numDigits;
                if (type == DigitType.FRACTION && digit == 0) {
                    ++this.trailingZeros;
                } else if (type == DigitType.FRACTION) {
                    this.fq.appendDigit(digit, this.trailingZeros, false);
                    this.trailingZeros = 0;
                } else {
                    this.fq.appendDigit(digit, 0, true);
                }
            }
        }

        public boolean hasNumber() {
            return this.numDigits > 0 || this.sawNaN || this.sawInfinity;
        }

        Number toNumber(DecimalFormatProperties properties) {
            if (this.sawNaN) {
                return Double.NaN;
            }
            if (this.sawInfinity) {
                if (this.sawNegative) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.POSITIVE_INFINITY;
            }
            if (this.fq.isZero() && this.sawNegative) {
                return -0.0;
            }
            boolean forceBigDecimal = properties.getParseToBigDecimal();
            if (this.exponent == Integer.MAX_VALUE) {
                if (this.sawNegativeExponent && this.sawNegative) {
                    return -0.0;
                }
                if (this.sawNegativeExponent) {
                    return 0.0;
                }
                if (this.sawNegative) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.POSITIVE_INFINITY;
            }
            if (this.exponent > 1000) {
                forceBigDecimal = true;
            }
            BigDecimal multiplier = properties.getMultiplier();
            if (properties.getMagnitudeMultiplier() != 0) {
                if (multiplier == null) {
                    multiplier = BigDecimal.ONE;
                }
                multiplier = multiplier.scaleByPowerOfTen(properties.getMagnitudeMultiplier());
            }
            int delta = (this.sawNegativeExponent ? -1 : 1) * this.exponent;
            MathContext mc = RoundingUtils.getMathContextOr34Digits(properties);
            BigDecimal result = this.fq.toBigDecimal();
            if (this.sawNegative) {
                result = result.negate();
            }
            result = result.scaleByPowerOfTen(delta);
            if (multiplier != null) {
                result = result.divide(multiplier, mc);
            }
            result = result.stripTrailingZeros();
            if (forceBigDecimal || result.scale() > 0) {
                return result;
            }
            if (result.compareTo(MIN_LONG_AS_BIG_DECIMAL) >= 0 && result.compareTo(MAX_LONG_AS_BIG_DECIMAL) <= 0) {
                return result.longValueExact();
            }
            return result.toBigIntegerExact();
        }

        public CurrencyAmount toCurrencyAmount(DecimalFormatProperties properties) {
            assert (this.isoCode != null);
            Number number = this.toNumber(properties);
            Currency currency = Currency.getInstance(this.isoCode);
            return new CurrencyAmount(number, currency);
        }

        public String toString() {
            char[] cArray;
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(this.path);
            sb.append("] ");
            sb.append(this.name.name());
            if (this.name == StateName.INSIDE_STRING) {
                sb.append("{");
                sb.append(this.currentString);
                sb.append(":");
                sb.append(this.currentOffset);
                sb.append("}");
            }
            if (this.name == StateName.INSIDE_AFFIX_PATTERN) {
                sb.append("{");
                sb.append(this.currentAffixPattern);
                sb.append(":");
                sb.append(AffixUtils.getOffset(this.currentStepwiseParserTag) - 1);
                sb.append("}");
            }
            sb.append(" ");
            sb.append(this.fq.toBigDecimal());
            sb.append(" grouping:");
            if (this.groupingCp == -1) {
                char[] cArray2 = new char[1];
                cArray = cArray2;
                cArray2[0] = 63;
            } else {
                cArray = Character.toChars(this.groupingCp);
            }
            sb.append(cArray);
            sb.append(" widths:");
            sb.append(Long.toHexString(this.groupingWidths));
            sb.append(" seen:");
            sb.append(this.sawNegative ? 1 : 0);
            sb.append(this.sawNegativeExponent ? 1 : 0);
            sb.append(this.sawNaN ? 1 : 0);
            sb.append(this.sawInfinity ? 1 : 0);
            sb.append(this.sawPrefix ? 1 : 0);
            sb.append(this.sawSuffix ? 1 : 0);
            sb.append(this.sawDecimalPoint ? 1 : 0);
            sb.append(" trailing:");
            sb.append(this.trailingCount);
            sb.append(" score:");
            sb.append(this.score);
            sb.append(" affix:");
            sb.append(this.affix);
            sb.append(" currency:");
            sb.append(this.isoCode);
            return sb.toString();
        }
    }

    private static enum DigitType {
        INTEGER,
        FRACTION,
        EXPONENT;

    }

    private static enum SeparatorType {
        COMMA_LIKE,
        PERIOD_LIKE,
        OTHER_GROUPING,
        UNKNOWN;


        static SeparatorType fromCp(int cp, ParseMode mode) {
            if (mode == ParseMode.FAST) {
                return UNKNOWN;
            }
            if (mode == ParseMode.STRICT) {
                if (UNISET_STRICT_COMMA_LIKE.contains(cp)) {
                    return COMMA_LIKE;
                }
                if (UNISET_STRICT_PERIOD_LIKE.contains(cp)) {
                    return PERIOD_LIKE;
                }
                if (UNISET_OTHER_GROUPING_SEPARATORS.contains(cp)) {
                    return OTHER_GROUPING;
                }
                return UNKNOWN;
            }
            if (UNISET_COMMA_LIKE.contains(cp)) {
                return COMMA_LIKE;
            }
            if (UNISET_PERIOD_LIKE.contains(cp)) {
                return PERIOD_LIKE;
            }
            if (UNISET_OTHER_GROUPING_SEPARATORS.contains(cp)) {
                return OTHER_GROUPING;
            }
            return UNKNOWN;
        }
    }

    private static enum StateName {
        BEFORE_PREFIX,
        AFTER_PREFIX,
        AFTER_INTEGER_DIGIT,
        AFTER_FRACTION_DIGIT,
        AFTER_EXPONENT_SEPARATOR,
        AFTER_EXPONENT_DIGIT,
        BEFORE_SUFFIX,
        BEFORE_SUFFIX_SEEN_EXPONENT,
        AFTER_SUFFIX,
        INSIDE_CURRENCY,
        INSIDE_DIGIT,
        INSIDE_STRING,
        INSIDE_AFFIX_PATTERN;

    }

    public static enum GroupingMode {
        DEFAULT,
        RESTRICTED;

    }

    public static enum ParseMode {
        LENIENT,
        STRICT,
        FAST;

    }
}

